/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.LazyLoadingContainer;
import org.activiti.explorer.navigation.UriFragment;
import org.activiti.explorer.ui.AbstractTablePage;
import org.activiti.explorer.ui.ComponentFactory;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.ToolBar;
import org.activiti.explorer.ui.process.ProcessDefinitionDetailPanel;
import org.activiti.explorer.ui.process.ProcessDefinitionFilter;
import org.activiti.explorer.ui.process.ProcessDefinitionFilterFactory;
import org.activiti.explorer.ui.process.ProcessDefinitionListQuery;
import org.activiti.explorer.ui.process.ProcessMenuBar;
import org.activiti.explorer.ui.util.ThemeImageColumnGenerator;

public class ProcessDefinitionPage
extends AbstractTablePage {
    private static final long serialVersionUID = 1L;
    protected transient RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
    protected String processDefinitionId;
    protected LazyLoadingContainer processDefinitionContainer;
    protected Table processDefinitionTable;
    protected ProcessDefinitionDetailPanel detailPanel;
    private ProcessDefinitionFilter definitionFilter;

    public ProcessDefinitionPage() {
        ExplorerApp.get().setCurrentUriFragment(new UriFragment("process"));
        ComponentFactory factory = ExplorerApp.get().getComponentFactory(ProcessDefinitionFilterFactory.class);
        this.definitionFilter = (ProcessDefinitionFilter)factory.create();
    }

    public ProcessDefinitionPage(String processDefinitionId) {
        this();
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    protected void initUi() {
        super.initUi();
        if (this.processDefinitionId == null) {
            this.selectElement(0);
        } else {
            this.selectElement(this.processDefinitionContainer.getIndexForObjectId(this.processDefinitionId));
        }
    }

    @Override
    protected ToolBar createMenuBar() {
        return new ProcessMenuBar();
    }

    @Override
    protected Table createList() {
        final Table processDefinitionTable = new Table();
        processDefinitionTable.addStyleName("proc-def-list");
        processDefinitionTable.setEditable(false);
        processDefinitionTable.setImmediate(true);
        processDefinitionTable.setSelectable(true);
        processDefinitionTable.setNullSelectionAllowed(false);
        processDefinitionTable.setSortDisabled(true);
        processDefinitionTable.setSizeFull();
        ProcessDefinitionListQuery lazyLoadingQuery = new ProcessDefinitionListQuery(this.repositoryService, this.definitionFilter);
        this.processDefinitionContainer = new LazyLoadingContainer(lazyLoadingQuery, 30);
        processDefinitionTable.setContainerDataSource((Container)this.processDefinitionContainer);
        processDefinitionTable.addListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                Item item = processDefinitionTable.getItem(event.getProperty().getValue());
                String processDefinitionId = (String)item.getItemProperty((Object)"id").getValue();
                ProcessDefinitionPage.this.showProcessDefinitionDetail(processDefinitionId);
            }
        });
        processDefinitionTable.addGeneratedColumn((Object)"icon", (Table.ColumnGenerator)new ThemeImageColumnGenerator(Images.PROCESS_22));
        processDefinitionTable.setColumnWidth((Object)"icon", 22);
        processDefinitionTable.addContainerProperty((Object)"name", String.class, null);
        processDefinitionTable.setColumnHeaderMode(-1);
        return processDefinitionTable;
    }

    protected void showProcessDefinitionDetail(String processDefinitionId) {
        this.detailPanel = new ProcessDefinitionDetailPanel(processDefinitionId, this);
        this.setDetailComponent((Component)this.detailPanel);
        this.changeUrl(processDefinitionId);
    }

    protected void changeUrl(String processDefinitionId) {
        UriFragment processDefinitionFragment = new UriFragment("process", processDefinitionId);
        ExplorerApp.get().setCurrentUriFragment(processDefinitionFragment);
    }

    public void showStartForm(ProcessDefinition processDefinition, StartFormData startFormData) {
        if (this.detailPanel != null) {
            this.showProcessDefinitionDetail(processDefinition.getId());
        }
        this.detailPanel.showProcessStartForm(startFormData);
    }
}

