/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.reports;

import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.ui.custom.ToolBar;
import org.activiti.explorer.ui.custom.ToolbarEntry;

public class ReportsMenuBar
extends ToolBar {
    private static final long serialVersionUID = 1L;
    public static final String ENTRY_RUN_REPORTS = "runReports";
    public static final String ENTRY_SAVED_REPORTS = "savedResults";
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected ViewManager viewManager = ExplorerApp.get().getViewManager();

    public ReportsMenuBar() {
        this.setWidth("100%");
        this.initToolbarEntries();
    }

    protected void initToolbarEntries() {
        this.addRunReportsToolbarEntry();
        this.addSavedReportsToolbarEntry();
    }

    protected void addRunReportsToolbarEntry() {
        this.addToolbarEntry(ENTRY_RUN_REPORTS, this.i18nManager.getMessage("reporting.menu.run.reports"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                ReportsMenuBar.this.viewManager.showRunReportPage();
            }
        });
    }

    protected void addSavedReportsToolbarEntry() {
        this.addToolbarEntry(ENTRY_SAVED_REPORTS, this.i18nManager.getMessage("reporting.menu.saved.reports"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                ReportsMenuBar.this.viewManager.showSavedReportPage();
            }
        });
    }
}

