/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import math.geom2d.Point2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.line.Line2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.polygon.Polyline2D;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventListener;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Lane;
import org.activiti.bpmn.model.Pool;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.editor.constants.EditorJsonConstants;
import org.activiti.editor.constants.StencilConstants;
import org.activiti.editor.language.json.converter.ActivityProcessor;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BoundaryEventJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.activiti.editor.language.json.converter.BusinessRuleTaskJsonConverter;
import org.activiti.editor.language.json.converter.CallActivityJsonConverter;
import org.activiti.editor.language.json.converter.CatchEventJsonConverter;
import org.activiti.editor.language.json.converter.EndEventJsonConverter;
import org.activiti.editor.language.json.converter.EventGatewayJsonConverter;
import org.activiti.editor.language.json.converter.EventSubProcessJsonConverter;
import org.activiti.editor.language.json.converter.ExclusiveGatewayJsonConverter;
import org.activiti.editor.language.json.converter.InclusiveGatewayJsonConverter;
import org.activiti.editor.language.json.converter.MailTaskJsonConverter;
import org.activiti.editor.language.json.converter.ManualTaskJsonConverter;
import org.activiti.editor.language.json.converter.ParallelGatewayJsonConverter;
import org.activiti.editor.language.json.converter.ReceiveTaskJsonConverter;
import org.activiti.editor.language.json.converter.ScriptTaskJsonConverter;
import org.activiti.editor.language.json.converter.SequenceFlowJsonConverter;
import org.activiti.editor.language.json.converter.ServiceTaskJsonConverter;
import org.activiti.editor.language.json.converter.StartEventJsonConverter;
import org.activiti.editor.language.json.converter.SubProcessJsonConverter;
import org.activiti.editor.language.json.converter.ThrowEventJsonConverter;
import org.activiti.editor.language.json.converter.UserTaskJsonConverter;
import org.activiti.editor.language.json.converter.util.JsonConverterUtil;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnJsonConverter
implements EditorJsonConstants,
StencilConstants,
ActivityProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BpmnJsonConverter.class);
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected static Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap = new HashMap<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>>();
    protected static Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap = new HashMap<String, Class<? extends BaseBpmnJsonConverter>>();
    private static final List<String> DI_CIRCLES;
    private static final List<String> DI_RECTANGLES;
    private static final List<String> DI_GATEWAY;

    public ObjectNode convertToJson(BpmnModel model) {
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        modelNode.put("bounds", (JsonNode)BpmnJsonConverterUtil.createBoundsNode(1485.0, 1050.0, 0.0, 0.0));
        modelNode.put("resourceId", "canvas");
        ObjectNode stencilNode = this.objectMapper.createObjectNode();
        stencilNode.put("id", "BPMNDiagram");
        modelNode.put("stencil", (JsonNode)stencilNode);
        ObjectNode stencilsetNode = this.objectMapper.createObjectNode();
        stencilsetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        stencilsetNode.put("url", "../editor/stencilsets/bpmn2.0/bpmn2.0.json");
        modelNode.put("stencilset", (JsonNode)stencilsetNode);
        ArrayNode shapesArrayNode = this.objectMapper.createArrayNode();
        Process mainProcess = model.getMainProcess();
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        if (StringUtils.isNotEmpty((CharSequence)mainProcess.getId())) {
            propertiesNode.put("process_id", mainProcess.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)mainProcess.getName())) {
            propertiesNode.put("name", mainProcess.getName());
        }
        if (!mainProcess.isExecutable()) {
            propertiesNode.put("process_executable", "No");
        }
        propertiesNode.put("process_namespace", model.getTargetNamespace());
        this.convertListenersToJson(mainProcess.getEventListeners(), propertiesNode);
        if (StringUtils.isNotEmpty((CharSequence)mainProcess.getDocumentation())) {
            propertiesNode.put("documentation", mainProcess.getDocumentation());
        }
        modelNode.put("properties", (JsonNode)propertiesNode);
        if (model.getPools().size() > 0) {
            for (Pool pool : model.getPools()) {
                GraphicInfo poolGraphicInfo = model.getGraphicInfo(pool.getId());
                ObjectNode poolNode = BpmnJsonConverterUtil.createChildShape(pool.getId(), "Pool", poolGraphicInfo.getX() + poolGraphicInfo.getWidth(), poolGraphicInfo.getY() + poolGraphicInfo.getHeight(), poolGraphicInfo.getX(), poolGraphicInfo.getY());
                shapesArrayNode.add((JsonNode)poolNode);
                ObjectNode poolPropertiesNode = this.objectMapper.createObjectNode();
                poolPropertiesNode.put("overrideid", pool.getId());
                poolPropertiesNode.put("process_id", pool.getProcessRef());
                if (!pool.isExecutable()) {
                    poolPropertiesNode.put("process_executable", "No");
                }
                if (StringUtils.isNotEmpty((CharSequence)pool.getName())) {
                    poolPropertiesNode.put("name", pool.getName());
                }
                poolNode.put("properties", (JsonNode)poolPropertiesNode);
                poolNode.put("outgoing", (JsonNode)this.objectMapper.createArrayNode());
                ArrayNode laneShapesArrayNode = this.objectMapper.createArrayNode();
                poolNode.put("childShapes", (JsonNode)laneShapesArrayNode);
                Process process = model.getProcess(pool.getId());
                if (process == null) continue;
                this.processFlowElements(process.findFlowElementsOfType(SequenceFlow.class), model, shapesArrayNode, poolGraphicInfo.getX(), poolGraphicInfo.getY());
                for (Lane lane : process.getLanes()) {
                    GraphicInfo laneGraphicInfo = model.getGraphicInfo(lane.getId());
                    ObjectNode laneNode = BpmnJsonConverterUtil.createChildShape(lane.getId(), "Lane", laneGraphicInfo.getX() + laneGraphicInfo.getWidth(), laneGraphicInfo.getY() + laneGraphicInfo.getHeight(), laneGraphicInfo.getX(), laneGraphicInfo.getY());
                    laneShapesArrayNode.add((JsonNode)laneNode);
                    ObjectNode lanePropertiesNode = this.objectMapper.createObjectNode();
                    lanePropertiesNode.put("overrideid", lane.getId());
                    if (StringUtils.isNotEmpty((CharSequence)lane.getName())) {
                        lanePropertiesNode.put("name", lane.getName());
                    }
                    laneNode.put("properties", (JsonNode)lanePropertiesNode);
                    ArrayNode elementShapesArrayNode = this.objectMapper.createArrayNode();
                    laneNode.put("childShapes", (JsonNode)elementShapesArrayNode);
                    laneNode.put("outgoing", (JsonNode)this.objectMapper.createArrayNode());
                    for (FlowElement flowElement : process.getFlowElements()) {
                        Class<? extends BaseBpmnJsonConverter> converter;
                        if (!lane.getFlowReferences().contains(flowElement.getId()) || (converter = convertersToJsonMap.get(flowElement.getClass())) == null) continue;
                        try {
                            converter.newInstance().convertToJson(flowElement, this, model, elementShapesArrayNode, laneGraphicInfo.getX(), laneGraphicInfo.getY());
                        }
                        catch (Exception e) {
                            LOGGER.error("Error converting {}", (Object)flowElement, (Object)e);
                        }
                    }
                }
            }
        } else {
            this.processFlowElements(model.getMainProcess().getFlowElements(), model, shapesArrayNode, 0.0, 0.0);
        }
        modelNode.put("childShapes", (JsonNode)shapesArrayNode);
        return modelNode;
    }

    @Override
    public void processFlowElements(Collection<? extends FlowElement> flowElements, BpmnModel model, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        for (FlowElement flowElement : flowElements) {
            Class<? extends BaseBpmnJsonConverter> converter = convertersToJsonMap.get(flowElement.getClass());
            if (converter == null) continue;
            try {
                converter.newInstance().convertToJson(flowElement, this, model, shapesArrayNode, subProcessX, subProcessY);
            }
            catch (Exception e) {
                LOGGER.error("Error converting {}", (Object)flowElement, (Object)e);
            }
        }
    }

    public BpmnModel convertToBpmnModel(JsonNode modelNode) {
        BpmnModel bpmnModel = new BpmnModel();
        HashMap<String, JsonNode> shapeMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> sourceRefMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> edgeMap = new HashMap<String, JsonNode>();
        HashMap<String, List<JsonNode>> sourceAndTargetMap = new HashMap<String, List<JsonNode>>();
        this.readShapeDI(modelNode, 0.0, 0.0, shapeMap, sourceRefMap, bpmnModel);
        this.filterAllEdges(modelNode, edgeMap, sourceAndTargetMap, shapeMap, sourceRefMap);
        this.readEdgeDI(edgeMap, sourceAndTargetMap, bpmnModel);
        ArrayNode shapesArrayNode = (ArrayNode)modelNode.get("childShapes");
        boolean emptyPoolFound = true;
        for (JsonNode shapeNode : shapesArrayNode) {
            String stencilId = BpmnJsonConverterUtil.getStencilId(shapeNode);
            if (!"Pool".equals(stencilId)) continue;
            Pool pool = new Pool();
            pool.setId(BpmnJsonConverterUtil.getElementId(shapeNode));
            pool.setName(JsonConverterUtil.getPropertyValueAsString("name", shapeNode));
            pool.setProcessRef(JsonConverterUtil.getPropertyValueAsString("process_id", shapeNode));
            JsonNode processExecutableNode = JsonConverterUtil.getProperty("process_executable", shapeNode);
            if (processExecutableNode != null && StringUtils.isNotEmpty((CharSequence)processExecutableNode.asText())) {
                pool.setExecutable(JsonConverterUtil.getPropertyValueAsBoolean("process_executable", shapeNode));
            }
            bpmnModel.getPools().add(pool);
            Process process = new Process();
            process.setId(pool.getProcessRef());
            process.setName(pool.getName());
            process.setExecutable(pool.isExecutable());
            bpmnModel.addProcess(process);
            this.processJsonElements((JsonNode)shapesArrayNode, modelNode, (BaseElement)process, shapeMap);
            ArrayNode laneArrayNode = (ArrayNode)shapeNode.get("childShapes");
            for (JsonNode laneNode : laneArrayNode) {
                String laneStencilId = BpmnJsonConverterUtil.getStencilId(laneNode);
                if (!"Lane".equals(laneStencilId)) continue;
                emptyPoolFound = false;
                Lane lane = new Lane();
                lane.setId(BpmnJsonConverterUtil.getElementId(laneNode));
                lane.setName(JsonConverterUtil.getPropertyValueAsString("name", laneNode));
                lane.setParentProcess(process);
                process.getLanes().add(lane);
                this.processJsonElements(laneNode.get("childShapes"), modelNode, (BaseElement)lane, shapeMap);
            }
        }
        if (emptyPoolFound) {
            JsonNode processEventListenerNode;
            JsonNode processExecutionListenerNode;
            JsonNode processTargetNamespace;
            JsonNode processExecutableNode;
            JsonNode processNameNode;
            JsonNode processIdNode = JsonConverterUtil.getProperty("process_id", modelNode);
            Process process = new Process();
            bpmnModel.getProcesses().add(process);
            if (processIdNode != null && StringUtils.isNotEmpty((CharSequence)processIdNode.asText())) {
                process.setId(processIdNode.asText());
            }
            if ((processNameNode = JsonConverterUtil.getProperty("name", modelNode)) != null && StringUtils.isNotEmpty((CharSequence)processNameNode.asText())) {
                process.setName(processNameNode.asText());
            }
            if ((processExecutableNode = JsonConverterUtil.getProperty("process_executable", modelNode)) != null && StringUtils.isNotEmpty((CharSequence)processExecutableNode.asText())) {
                process.setExecutable(JsonConverterUtil.getPropertyValueAsBoolean("process_executable", modelNode));
            }
            if ((processTargetNamespace = JsonConverterUtil.getProperty("process_namespace", modelNode)) != null && StringUtils.isNotEmpty((CharSequence)processTargetNamespace.asText())) {
                bpmnModel.setTargetNamespace(processTargetNamespace.asText());
            }
            if ((processExecutionListenerNode = modelNode.get("properties").get("executionlisteners")) != null && StringUtils.isNotEmpty((CharSequence)processExecutionListenerNode.asText())) {
                process.setExecutionListeners(this.convertJsonToListeners(processExecutionListenerNode));
            }
            if ((processEventListenerNode = modelNode.get("properties").get("eventlisteners")) != null) {
                process.setEventListeners(this.convertJsonToEventListeners(processEventListenerNode));
            }
            this.processJsonElements((JsonNode)shapesArrayNode, modelNode, (BaseElement)process, shapeMap);
        }
        HashMap<String, SubProcess> subShapesMap = new HashMap<String, SubProcess>();
        for (Process process : bpmnModel.getProcesses()) {
            for (FlowElement flowElement : process.findFlowElementsOfType(SubProcess.class)) {
                SubProcess subProcess = (SubProcess)flowElement;
                this.fillSubShapes(subShapesMap, subProcess);
            }
            if (subShapesMap.size() <= 0) continue;
            ArrayList<String> removeSubFlowsList = new ArrayList<String>();
            List sequenceFlowList = process.findFlowElementsOfType(SequenceFlow.class);
            for (FlowElement flowElement : sequenceFlowList) {
                SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
                if (process.getFlowElement(flowElement.getId()) == null || !subShapesMap.containsKey(sequenceFlow.getSourceRef())) continue;
                SubProcess subProcess = (SubProcess)subShapesMap.get(sequenceFlow.getSourceRef());
                subProcess.addFlowElement((FlowElement)sequenceFlow);
                removeSubFlowsList.add(sequenceFlow.getId());
            }
            for (String flowId : removeSubFlowsList) {
                process.removeFlowElement(flowId);
            }
        }
        for (Process process : bpmnModel.getProcesses()) {
            this.postProcessElements((FlowElementsContainer)process, process.getFlowElements());
        }
        return bpmnModel;
    }

    @Override
    public void processJsonElements(JsonNode shapesArrayNode, JsonNode modelNode, BaseElement parentElement, Map<String, JsonNode> shapeMap) {
        for (JsonNode shapeNode : shapesArrayNode) {
            Class<? extends BaseBpmnJsonConverter> converter = convertersToBpmnMap.get(BpmnJsonConverterUtil.getStencilId(shapeNode));
            if (converter == null) continue;
            try {
                converter.newInstance().convertToBpmnModel(shapeNode, modelNode, this, parentElement, shapeMap);
            }
            catch (Exception e) {
                LOGGER.error("Error converting {}", (Object)BpmnJsonConverterUtil.getStencilId(shapeNode), (Object)e);
            }
        }
    }

    private List<ActivitiListener> convertJsonToListeners(JsonNode listenersNode) {
        ArrayList<ActivitiListener> executionListeners = new ArrayList<ActivitiListener>();
        try {
            listenersNode = this.objectMapper.readTree(listenersNode.asText());
        }
        catch (Exception e) {
            LOGGER.info("Listeners node can not be read", (Throwable)e);
        }
        JsonNode itemsArrayNode = listenersNode.get("items");
        if (itemsArrayNode != null) {
            for (JsonNode itemNode : itemsArrayNode) {
                JsonNode typeNode = itemNode.get("execution_listener_event_type");
                if (typeNode == null || !StringUtils.isNotEmpty((CharSequence)typeNode.asText())) continue;
                ActivitiListener listener = new ActivitiListener();
                listener.setEvent(typeNode.asText());
                if (StringUtils.isNotEmpty((CharSequence)itemNode.get("execution_listener_class").asText())) {
                    listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
                    listener.setImplementation(itemNode.get("execution_listener_class").asText());
                } else if (StringUtils.isNotEmpty((CharSequence)itemNode.get("execution_listener_expression").asText())) {
                    listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION);
                    listener.setImplementation(itemNode.get("execution_listener_expression").asText());
                } else if (StringUtils.isNotEmpty((CharSequence)itemNode.get("execution_listener_delegate_expression").asText())) {
                    listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
                    listener.setImplementation(itemNode.get("execution_listener_delegate_expression").asText());
                }
                executionListeners.add(listener);
            }
        }
        return executionListeners;
    }

    private List<EventListener> convertJsonToEventListeners(JsonNode listenersNode) {
        ArrayList<EventListener> eventListeners = new ArrayList<EventListener>();
        if (StringUtils.isEmpty((CharSequence)listenersNode.asText())) {
            return eventListeners;
        }
        try {
            listenersNode = this.objectMapper.readTree(listenersNode.asText());
        }
        catch (Exception e) {
            LOGGER.info("Event listeners node can not be read", (Throwable)e);
        }
        JsonNode itemsArrayNode = listenersNode.get("items");
        if (itemsArrayNode != null) {
            for (JsonNode itemNode : itemsArrayNode) {
                EventListener listener = new EventListener();
                if (this.isNotEmpty("event_listener_events", itemNode)) {
                    listener.setEvents(itemNode.get("event_listener_events").asText());
                }
                if (this.isNotEmpty("event_listener_entity_type", itemNode)) {
                    listener.setEntityType(itemNode.get("event_listener_entity_type").asText());
                }
                if (this.isNotEmpty("event_listener_class", itemNode)) {
                    listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
                    listener.setImplementation(itemNode.get("event_listener_class").asText());
                } else if (this.isNotEmpty("event_listener_delegate_expression", itemNode)) {
                    listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
                    listener.setImplementation(itemNode.get("event_listener_delegate_expression").asText());
                } else if (this.isNotEmpty("event_listener_throw_event", itemNode)) {
                    String throwEventType = itemNode.get("event_listener_throw_event").asText();
                    if ("signal".equals(throwEventType)) {
                        listener.setImplementation(itemNode.get("event_listener_throw_event_ref").asText());
                        listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_THROW_SIGNAL_EVENT);
                    } else if ("globalSignal".equals(throwEventType)) {
                        listener.setImplementation(itemNode.get("event_listener_throw_event_ref").asText());
                        listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_THROW_GLOBAL_SIGNAL_EVENT);
                    } else if ("message".equals(throwEventType)) {
                        listener.setImplementation(itemNode.get("event_listener_throw_event_ref").asText());
                        listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_THROW_MESSAGE_EVENT);
                    } else if ("error".equals(throwEventType)) {
                        listener.setImplementation(itemNode.get("event_listener_throw_event_ref").asText());
                        listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_THROW_ERROR_EVENT);
                    } else {
                        listener = null;
                    }
                } else {
                    listener = null;
                }
                if (listener == null) continue;
                eventListeners.add(listener);
            }
        }
        return eventListeners;
    }

    private boolean isNotEmpty(String propertyName, JsonNode node) {
        JsonNode value = node.get(propertyName);
        if (value != null) {
            return StringUtils.isNotEmpty((CharSequence)value.asText());
        }
        return false;
    }

    private void fillSubShapes(Map<String, SubProcess> subShapesMap, SubProcess subProcess) {
        for (FlowElement flowElement : subProcess.getFlowElements()) {
            if (flowElement instanceof SubProcess) {
                SubProcess childSubProcess = (SubProcess)flowElement;
                this.fillSubShapes(subShapesMap, childSubProcess);
                continue;
            }
            subShapesMap.put(flowElement.getId(), subProcess);
        }
    }

    private void postProcessElements(FlowElementsContainer process, Collection<FlowElement> flowElementList) {
        for (FlowElement flowElement : flowElementList) {
            FlowElement targerFlowElement;
            if (flowElement instanceof BoundaryEvent) {
                BoundaryEvent boundaryEvent = (BoundaryEvent)flowElement;
                Activity activity = this.retrieveAttachedRefObject(boundaryEvent.getAttachedToRefId(), process.getFlowElements());
                if (activity == null) {
                    LOGGER.warn("Boundary event " + boundaryEvent.getId() + " is not attached to any activity");
                    continue;
                }
                boundaryEvent.setAttachedToRef(activity);
                activity.getBoundaryEvents().add(boundaryEvent);
                continue;
            }
            if (flowElement instanceof SubProcess) {
                SubProcess subProcess = (SubProcess)flowElement;
                this.postProcessElements((FlowElementsContainer)subProcess, subProcess.getFlowElements());
                continue;
            }
            if (!(flowElement instanceof SequenceFlow)) continue;
            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
            FlowElement sourceFlowElement = process.getFlowElement(sequenceFlow.getSourceRef());
            if (sourceFlowElement != null && sourceFlowElement instanceof FlowNode) {
                ((FlowNode)sourceFlowElement).getOutgoingFlows().add(sequenceFlow);
            }
            if ((targerFlowElement = process.getFlowElement(sequenceFlow.getTargetRef())) == null || !(targerFlowElement instanceof FlowNode)) continue;
            ((FlowNode)targerFlowElement).getIncomingFlows().add(sequenceFlow);
        }
    }

    private Activity retrieveAttachedRefObject(String attachedToRefId, Collection<FlowElement> flowElementList) {
        for (FlowElement flowElement : flowElementList) {
            SubProcess subProcess;
            Activity activity;
            if (attachedToRefId.equals(flowElement.getId())) {
                return (Activity)flowElement;
            }
            if (!(flowElement instanceof SubProcess) || (activity = this.retrieveAttachedRefObject(attachedToRefId, (subProcess = (SubProcess)flowElement).getFlowElements())) == null) continue;
            return activity;
        }
        return null;
    }

    private void readShapeDI(JsonNode objectNode, double parentX, double parentY, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap, BpmnModel bpmnModel) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                String stencilId = BpmnJsonConverterUtil.getStencilId(jsonChildNode);
                if ("SequenceFlow".equals(stencilId)) continue;
                GraphicInfo graphicInfo = new GraphicInfo();
                JsonNode boundsNode = jsonChildNode.get("bounds");
                ObjectNode upperLeftNode = (ObjectNode)boundsNode.get("upperLeft");
                graphicInfo.setX(upperLeftNode.get("x").asDouble() + parentX);
                graphicInfo.setY(upperLeftNode.get("y").asDouble() + parentY);
                ObjectNode lowerRightNode = (ObjectNode)boundsNode.get("lowerRight");
                graphicInfo.setWidth(lowerRightNode.get("x").asDouble() - graphicInfo.getX() + parentX);
                graphicInfo.setHeight(lowerRightNode.get("y").asDouble() - graphicInfo.getY() + parentY);
                String childShapeId = jsonChildNode.get("resourceId").asText();
                bpmnModel.addGraphicInfo(BpmnJsonConverterUtil.getElementId(jsonChildNode), graphicInfo);
                shapeMap.put(childShapeId, jsonChildNode);
                ArrayNode outgoingNode = (ArrayNode)jsonChildNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null) continue;
                        sourceRefMap.put(resourceNode.asText(), jsonChildNode);
                    }
                }
                this.readShapeDI(jsonChildNode, graphicInfo.getX(), graphicInfo.getY(), shapeMap, sourceRefMap, bpmnModel);
            }
        }
    }

    private void filterAllEdges(JsonNode objectNode, Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                ObjectNode childNode = (ObjectNode)jsonChildNode;
                String stencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)childNode);
                if ("SubProcess".equals(stencilId)) {
                    this.filterAllEdges((JsonNode)childNode, edgeMap, sourceAndTargetMap, shapeMap, sourceRefMap);
                    continue;
                }
                if (!"SequenceFlow".equals(stencilId)) continue;
                String childEdgeId = BpmnJsonConverterUtil.getElementId((JsonNode)childNode);
                String targetRefId = childNode.get("target").get("resourceId").asText();
                ArrayList<JsonNode> sourceAndTargetList = new ArrayList<JsonNode>();
                sourceAndTargetList.add(sourceRefMap.get(childNode.get("resourceId").asText()));
                sourceAndTargetList.add(shapeMap.get(targetRefId));
                edgeMap.put(childEdgeId, (JsonNode)childNode);
                sourceAndTargetMap.put(childEdgeId, sourceAndTargetList);
            }
        }
    }

    public void convertListenersToJson(List<EventListener> eventListeners, ObjectNode propertiesNode) {
        ObjectNode listenersNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (EventListener listener : eventListeners) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put("event_listener_events", listener.getEvents());
            propertyItemNode.put("event_listener_entity_type", listener.getEntityType());
            if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(listener.getImplementationType())) {
                propertyItemNode.put("event_listener_class", listener.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(listener.getImplementationType())) {
                propertyItemNode.put("event_listener_delegate_expression", listener.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_SIGNAL_EVENT.equals(listener.getImplementationType())) {
                propertyItemNode.put("event_listener_throw_event", "signal");
                propertyItemNode.put("event_listener_throw_event_ref", listener.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_GLOBAL_SIGNAL_EVENT.equals(listener.getImplementationType())) {
                propertyItemNode.put("event_listener_throw_event", "globalSignal");
                propertyItemNode.put("event_listener_throw_event_ref", listener.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_MESSAGE_EVENT.equals(listener.getImplementationType())) {
                propertyItemNode.put("event_listener_throw_event", "message");
                propertyItemNode.put("event_listener_throw_event_ref", listener.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_ERROR_EVENT.equals(listener.getImplementationType())) {
                propertyItemNode.put("event_listener_throw_event", "error");
                propertyItemNode.put("event_listener_throw_event_ref", listener.getImplementation());
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        listenersNode.put("totalCount", itemsNode.size());
        listenersNode.put("items", (JsonNode)itemsNode);
        propertiesNode.put("eventlisteners", (JsonNode)listenersNode);
    }

    private void readEdgeDI(Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, BpmnModel bpmnModel) {
        for (String edgeId : edgeMap.keySet()) {
            Collection intersections;
            Point2D intersection;
            JsonNode edgeNode = edgeMap.get(edgeId);
            List<JsonNode> sourceAndTargetList = sourceAndTargetMap.get(edgeId);
            JsonNode sourceRefNode = sourceAndTargetList.get(0);
            JsonNode targetRefNode = sourceAndTargetList.get(1);
            if (sourceRefNode == null) {
                LOGGER.info("Skipping edge {} because source ref is null", (Object)edgeId);
                continue;
            }
            if (targetRefNode == null) {
                LOGGER.info("Skipping edge {} because target ref is null", (Object)edgeId);
                continue;
            }
            JsonNode dockersNode = edgeNode.get("dockers");
            double sourceDockersX = dockersNode.get(0).get("x").getDoubleValue();
            double sourceDockersY = dockersNode.get(0).get("y").getDoubleValue();
            GraphicInfo sourceInfo = bpmnModel.getGraphicInfo(BpmnJsonConverterUtil.getElementId(sourceRefNode));
            GraphicInfo targetInfo = bpmnModel.getGraphicInfo(BpmnJsonConverterUtil.getElementId(targetRefNode));
            double sourceRefLineX = sourceInfo.getX() + sourceDockersX;
            double sourceRefLineY = sourceInfo.getY() + sourceDockersY;
            double nextPointInLineX = dockersNode.get(1).get("x").getDoubleValue();
            double nextPointInLineY = dockersNode.get(1).get("y").getDoubleValue();
            if (dockersNode.size() == 2) {
                nextPointInLineX += targetInfo.getX();
                nextPointInLineY += targetInfo.getY();
            }
            Line2D firstLine = new Line2D(sourceRefLineX, sourceRefLineY, nextPointInLineX, nextPointInLineY);
            String sourceRefStencilId = BpmnJsonConverterUtil.getStencilId(sourceRefNode);
            String targetRefStencilId = BpmnJsonConverterUtil.getStencilId(targetRefNode);
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            if (DI_CIRCLES.contains(sourceRefStencilId)) {
                Circle2D eventCircle = new Circle2D(sourceInfo.getX() + sourceDockersX, sourceInfo.getY() + sourceDockersY, sourceDockersX);
                Collection intersections2 = eventCircle.intersections((LinearShape2D)firstLine);
                intersection = (Point2D)intersections2.iterator().next();
                graphicInfoList.add(this.createGraphicInfo(intersection.getX(), intersection.getY()));
            } else if (DI_RECTANGLES.contains(sourceRefStencilId)) {
                Polyline2D rectangle = this.createRectangle(sourceInfo);
                Collection intersections3 = rectangle.intersections((LinearShape2D)firstLine);
                intersection = (Point2D)intersections3.iterator().next();
                graphicInfoList.add(this.createGraphicInfo(intersection.getX(), intersection.getY()));
            } else if (DI_GATEWAY.contains(sourceRefStencilId)) {
                Polyline2D gatewayRectangle = this.createGateway(sourceInfo);
                Collection intersections4 = gatewayRectangle.intersections((LinearShape2D)firstLine);
                intersection = (Point2D)intersections4.iterator().next();
                graphicInfoList.add(this.createGraphicInfo(intersection.getX(), intersection.getY()));
            }
            Line2D lastLine = null;
            if (dockersNode.size() > 2) {
                for (int i = 1; i < dockersNode.size() - 1; ++i) {
                    double x = dockersNode.get(i).get("x").getDoubleValue();
                    double y = dockersNode.get(i).get("y").getDoubleValue();
                    graphicInfoList.add(this.createGraphicInfo(x, y));
                }
                double startLastLineX = dockersNode.get(dockersNode.size() - 2).get("x").getDoubleValue();
                double startLastLineY = dockersNode.get(dockersNode.size() - 2).get("y").getDoubleValue();
                double endLastLineX = dockersNode.get(dockersNode.size() - 1).get("x").getDoubleValue();
                double endLastLineY = dockersNode.get(dockersNode.size() - 1).get("y").getDoubleValue();
                lastLine = new Line2D(startLastLineX, startLastLineY, endLastLineX += targetInfo.getX(), endLastLineY += targetInfo.getY());
            } else {
                lastLine = firstLine;
            }
            if (DI_RECTANGLES.contains(targetRefStencilId)) {
                Polyline2D rectangle = this.createRectangle(targetInfo);
                intersections = rectangle.intersections((LinearShape2D)lastLine);
                Point2D intersection2 = (Point2D)intersections.iterator().next();
                graphicInfoList.add(this.createGraphicInfo(intersection2.getX(), intersection2.getY()));
            } else if (DI_CIRCLES.contains(targetRefStencilId)) {
                double targetDockersX = dockersNode.get(dockersNode.size() - 1).get("x").getDoubleValue();
                double targetDockersY = dockersNode.get(dockersNode.size() - 1).get("y").getDoubleValue();
                Circle2D eventCircle = new Circle2D(targetInfo.getX() + targetDockersX, targetInfo.getY() + targetDockersY, targetDockersX);
                Collection intersections5 = eventCircle.intersections((LinearShape2D)lastLine);
                Point2D intersection3 = (Point2D)intersections5.iterator().next();
                graphicInfoList.add(this.createGraphicInfo(intersection3.getX(), intersection3.getY()));
            } else if (DI_GATEWAY.contains(targetRefStencilId)) {
                Polyline2D gatewayRectangle = this.createGateway(targetInfo);
                intersections = gatewayRectangle.intersections((LinearShape2D)lastLine);
                Point2D intersection4 = (Point2D)intersections.iterator().next();
                graphicInfoList.add(this.createGraphicInfo(intersection4.getX(), intersection4.getY()));
            }
            bpmnModel.addFlowGraphicInfoList(edgeId, graphicInfoList);
        }
    }

    private Polyline2D createRectangle(GraphicInfo graphicInfo) {
        Polyline2D rectangle = new Polyline2D(new Point2D[]{new Point2D(graphicInfo.getX(), graphicInfo.getY()), new Point2D(graphicInfo.getX() + graphicInfo.getWidth(), graphicInfo.getY()), new Point2D(graphicInfo.getX() + graphicInfo.getWidth(), graphicInfo.getY() + graphicInfo.getHeight()), new Point2D(graphicInfo.getX(), graphicInfo.getY() + graphicInfo.getHeight()), new Point2D(graphicInfo.getX(), graphicInfo.getY())});
        return rectangle;
    }

    private Polyline2D createGateway(GraphicInfo graphicInfo) {
        double middleX = graphicInfo.getX() + graphicInfo.getWidth() / 2.0;
        double middleY = graphicInfo.getY() + graphicInfo.getHeight() / 2.0;
        Polyline2D gatewayRectangle = new Polyline2D(new Point2D[]{new Point2D(graphicInfo.getX(), middleY), new Point2D(middleX, graphicInfo.getY()), new Point2D(graphicInfo.getX() + graphicInfo.getWidth(), middleY), new Point2D(middleX, graphicInfo.getY() + graphicInfo.getHeight()), new Point2D(graphicInfo.getX(), middleY)});
        return gatewayRectangle;
    }

    private GraphicInfo createGraphicInfo(double x, double y) {
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX(x);
        graphicInfo.setY(y);
        return graphicInfo;
    }

    static {
        StartEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        EndEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        SequenceFlowJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        BusinessRuleTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        MailTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ManualTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ReceiveTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ScriptTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ServiceTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        UserTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        CallActivityJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ExclusiveGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        InclusiveGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ParallelGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        EventGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        SubProcessJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        EventSubProcessJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        CatchEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ThrowEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        BoundaryEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        DI_CIRCLES = new ArrayList<String>();
        DI_RECTANGLES = new ArrayList<String>();
        DI_GATEWAY = new ArrayList<String>();
        DI_CIRCLES.add("StartErrorEvent");
        DI_CIRCLES.add("StartMessageEvent");
        DI_CIRCLES.add("StartNoneEvent");
        DI_CIRCLES.add("StartTimerEvent");
        DI_CIRCLES.add("BoundaryErrorEvent");
        DI_CIRCLES.add("BoundarySignalEvent");
        DI_CIRCLES.add("BoundaryTimerEvent");
        DI_CIRCLES.add("CatchMessageEvent");
        DI_CIRCLES.add("CatchSignalEvent");
        DI_CIRCLES.add("CatchTimerEvent");
        DI_CIRCLES.add("ThrowNoneEvent");
        DI_CIRCLES.add("ThrowSignalEvent");
        DI_CIRCLES.add("EndNoneEvent");
        DI_CIRCLES.add("EndErrorEvent");
        DI_RECTANGLES.add("CallActivity");
        DI_RECTANGLES.add("SubProcess");
        DI_RECTANGLES.add("EventSubProcess");
        DI_RECTANGLES.add("BusinessRule");
        DI_RECTANGLES.add("MailTask");
        DI_RECTANGLES.add("ManualTask");
        DI_RECTANGLES.add("ReceiveTask");
        DI_RECTANGLES.add("ScriptTask");
        DI_RECTANGLES.add("ServiceTask");
        DI_RECTANGLES.add("UserTask");
        DI_GATEWAY.add("EventGateway");
        DI_GATEWAY.add("ExclusiveGateway");
        DI_GATEWAY.add("InclusiveGateway");
        DI_GATEWAY.add("ParallelGateway");
    }
}

