/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

public class CatchEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        CatchEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        CatchEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("CatchTimerEvent", CatchEventJsonConverter.class);
        convertersToBpmnMap.put("CatchMessageEvent", CatchEventJsonConverter.class);
        convertersToBpmnMap.put("CatchSignalEvent", CatchEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(IntermediateCatchEvent.class, CatchEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(FlowElement flowElement) {
        IntermediateCatchEvent catchEvent = (IntermediateCatchEvent)flowElement;
        List eventDefinitions = catchEvent.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return "CatchTimerEvent";
        }
        EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
        if (eventDefinition instanceof MessageEventDefinition) {
            return "CatchMessageEvent";
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            return "CatchSignalEvent";
        }
        return "CatchTimerEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, FlowElement flowElement) {
        IntermediateCatchEvent catchEvent = (IntermediateCatchEvent)flowElement;
        this.addEventProperties((Event)catchEvent, propertiesNode);
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        IntermediateCatchEvent catchEvent = new IntermediateCatchEvent();
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("CatchTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinition(elementNode, (Event)catchEvent);
        } else if ("CatchMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, (Event)catchEvent);
        } else if ("CatchSignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, (Event)catchEvent);
        }
        return catchEvent;
    }
}

