/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

public class ThrowEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        ThrowEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        ThrowEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("ThrowNoneEvent", ThrowEventJsonConverter.class);
        convertersToBpmnMap.put("ThrowSignalEvent", ThrowEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(ThrowEvent.class, ThrowEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(FlowElement flowElement) {
        ThrowEvent throwEvent = (ThrowEvent)flowElement;
        List eventDefinitions = throwEvent.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return "ThrowNoneEvent";
        }
        EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
        if (eventDefinition instanceof SignalEventDefinition) {
            return "ThrowSignalEvent";
        }
        return "ThrowNoneEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, FlowElement flowElement) {
        ThrowEvent throwEvent = (ThrowEvent)flowElement;
        this.addEventProperties((Event)throwEvent, propertiesNode);
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        ThrowEvent throwEvent = new ThrowEvent();
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("ThrowSignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, (Event)throwEvent);
        }
        return throwEvent;
    }
}

