/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.FormProperty;
import org.activiti.bpmn.model.FormValue;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Lane;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.constants.EditorJsonConstants;
import org.activiti.editor.constants.StencilConstants;
import org.activiti.editor.language.json.converter.ActivityProcessor;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.activiti.editor.language.json.converter.util.JsonConverterUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBpmnJsonConverter
implements EditorJsonConstants,
StencilConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseBpmnJsonConverter.class);
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected ActivityProcessor processor;
    protected BpmnModel model;
    protected ObjectNode flowElementNode;
    protected double subProcessX;
    protected double subProcessY;
    protected ArrayNode shapesArrayNode;

    public void convertToJson(FlowElement flowElement, ActivityProcessor processor, BpmnModel model, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        ServiceTask serviceTask;
        this.model = model;
        this.processor = processor;
        this.subProcessX = subProcessX;
        this.subProcessY = subProcessY;
        this.shapesArrayNode = shapesArrayNode;
        GraphicInfo graphicInfo = model.getGraphicInfo(flowElement.getId());
        String stencilId = null;
        stencilId = flowElement instanceof ServiceTask ? ("mail".equalsIgnoreCase((serviceTask = (ServiceTask)flowElement).getType()) ? "MailTask" : this.getStencilId(flowElement)) : this.getStencilId(flowElement);
        this.flowElementNode = BpmnJsonConverterUtil.createChildShape(flowElement.getId(), stencilId, graphicInfo.getX() - subProcessX + graphicInfo.getWidth(), graphicInfo.getY() - subProcessY + graphicInfo.getHeight(), graphicInfo.getX() - subProcessX, graphicInfo.getY() - subProcessY);
        shapesArrayNode.add((JsonNode)this.flowElementNode);
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("overrideid", flowElement.getId());
        if (StringUtils.isNotEmpty((CharSequence)flowElement.getName())) {
            propertiesNode.put("name", flowElement.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)flowElement.getDocumentation())) {
            propertiesNode.put("documentation", flowElement.getDocumentation());
        }
        this.convertElementToJson(propertiesNode, flowElement);
        this.flowElementNode.put("properties", (JsonNode)propertiesNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        if (flowElement instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)flowElement;
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(sequenceFlow.getId()));
            }
        }
        if (flowElement instanceof Activity) {
            MultiInstanceLoopCharacteristics loopDef;
            Activity activity = (Activity)flowElement;
            for (BoundaryEvent boundaryEvent : activity.getBoundaryEvents()) {
                outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(boundaryEvent.getId()));
            }
            if (activity.isAsynchronous()) {
                propertiesNode.put("asynchronousdefinition", "Yes");
            }
            if (activity.isNotExclusive()) {
                propertiesNode.put("exclusivedefinition", "No");
            }
            if (activity.getLoopCharacteristics() != null && (StringUtils.isNotEmpty((CharSequence)(loopDef = activity.getLoopCharacteristics()).getLoopCardinality()) || StringUtils.isNotEmpty((CharSequence)loopDef.getInputDataItem()) || StringUtils.isNotEmpty((CharSequence)loopDef.getCompletionCondition()))) {
                if (!loopDef.isSequential()) {
                    propertiesNode.put("multiinstance_sequential", "No");
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getLoopCardinality())) {
                    propertiesNode.put("multiinstance_cardinality", loopDef.getLoopCardinality());
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getInputDataItem())) {
                    propertiesNode.put("multiinstance_collection", loopDef.getInputDataItem());
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getElementVariable())) {
                    propertiesNode.put("multiinstance_variable", loopDef.getElementVariable());
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getCompletionCondition())) {
                    propertiesNode.put("multiinstance_condition", loopDef.getCompletionCondition());
                }
            }
            if (activity instanceof UserTask) {
                this.addListeners(((UserTask)activity).getTaskListeners(), false, propertiesNode);
            } else {
                this.addListeners(activity.getExecutionListeners(), true, propertiesNode);
            }
        }
        this.flowElementNode.put("outgoing", (JsonNode)outgoingArrayNode);
    }

    public void convertToBpmnModel(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap) {
        this.processor = processor;
        FlowElement flowElement = this.convertJsonToElement(elementNode, modelNode, shapeMap);
        flowElement.setId(BpmnJsonConverterUtil.getElementId(elementNode));
        flowElement.setName(this.getPropertyValueAsString("name", elementNode));
        flowElement.setDocumentation(this.getPropertyValueAsString("documentation", elementNode));
        this.convertJsonToListeners(elementNode, (BaseElement)flowElement);
        if (flowElement instanceof Activity) {
            Activity activity = (Activity)flowElement;
            activity.setAsynchronous(this.getPropertyValueAsBoolean("asynchronousdefinition", elementNode));
            activity.setNotExclusive(!this.getPropertyValueAsBoolean("exclusivedefinition", elementNode));
            String multiInstanceCardinality = this.getPropertyValueAsString("multiinstance_cardinality", elementNode);
            String multiInstanceCollection = this.getPropertyValueAsString("multiinstance_collection", elementNode);
            String multiInstanceCondition = this.getPropertyValueAsString("multiinstance_condition", elementNode);
            String multiInstanceLoopType = this.getPropertyValueAsString("looptype", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)multiInstanceCardinality) || StringUtils.isNotEmpty((CharSequence)multiInstanceCollection) || StringUtils.isNotEmpty((CharSequence)multiInstanceCondition) || StringUtils.isNotEmpty((CharSequence)multiInstanceLoopType)) {
                String multiInstanceVariable = this.getPropertyValueAsString("multiinstance_variable", elementNode);
                MultiInstanceLoopCharacteristics multiInstanceObject = new MultiInstanceLoopCharacteristics();
                multiInstanceObject.setSequential(this.getPropertyValueAsBoolean("multiinstance_sequential", elementNode));
                if (multiInstanceLoopType != null) {
                    if ("Sequential".equals(multiInstanceLoopType)) {
                        multiInstanceObject.setSequential(true);
                    } else if ("Parallel".equals(multiInstanceLoopType)) {
                        multiInstanceObject.setSequential(false);
                    }
                }
                multiInstanceObject.setLoopCardinality(multiInstanceCardinality);
                multiInstanceObject.setInputDataItem(multiInstanceCollection);
                multiInstanceObject.setElementVariable(multiInstanceVariable);
                multiInstanceObject.setCompletionCondition(multiInstanceCondition);
                activity.setLoopCharacteristics(multiInstanceObject);
            }
        }
        if (parentElement instanceof Process) {
            ((Process)parentElement).addFlowElement(flowElement);
        } else if (parentElement instanceof SubProcess) {
            ((SubProcess)parentElement).addFlowElement(flowElement);
        } else if (parentElement instanceof Lane) {
            Lane lane = (Lane)parentElement;
            lane.getFlowReferences().add(flowElement.getId());
            lane.getParentProcess().addFlowElement(flowElement);
        }
    }

    protected abstract void convertElementToJson(ObjectNode var1, FlowElement var2);

    protected abstract FlowElement convertJsonToElement(JsonNode var1, JsonNode var2, Map<String, JsonNode> var3);

    protected abstract String getStencilId(FlowElement var1);

    protected void setPropertyValue(String name, String value, ObjectNode propertiesNode) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            propertiesNode.put(name, value);
        }
    }

    protected void addFormProperties(List<FormProperty> formProperties, ObjectNode propertiesNode) {
        ObjectNode formPropertiesNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (FormProperty property : formProperties) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put("formproperty_id", property.getId());
            propertyItemNode.put("formproperty_name", property.getName());
            propertyItemNode.put("formproperty_type", property.getType());
            if (StringUtils.isNotEmpty((CharSequence)property.getExpression())) {
                propertyItemNode.put("formproperty_expression", property.getExpression());
            } else {
                propertyItemNode.putNull("formproperty_expression");
            }
            if (StringUtils.isNotEmpty((CharSequence)property.getVariable())) {
                propertyItemNode.put("formproperty_variable", property.getVariable());
            } else {
                propertyItemNode.putNull("formproperty_variable");
            }
            propertyItemNode.put("formproperty_required", property.isRequired() ? "Yes" : "No");
            propertyItemNode.put("formproperty_readable", property.isReadable() ? "Yes" : "No");
            propertyItemNode.put("formproperty_writeable", property.isWriteable() ? "Yes" : "No");
            ObjectNode formValueNode = this.objectMapper.createObjectNode();
            ArrayNode formValueItemNode = this.objectMapper.createArrayNode();
            for (FormValue formValue : property.getFormValues()) {
                ObjectNode propertyFormValueNode = this.objectMapper.createObjectNode();
                propertyFormValueNode.put("formproperty_formvalue_id", formValue.getId());
                propertyFormValueNode.put("formproperty_formvalue_name", formValue.getName());
                formValueItemNode.add((JsonNode)propertyFormValueNode);
            }
            formValueNode.put("totalCount", formValueItemNode.size());
            formValueNode.put("items", (JsonNode)formValueItemNode);
            propertyItemNode.put("formproperty_formvalues", formValueNode.toString());
            itemsNode.add((JsonNode)propertyItemNode);
        }
        formPropertiesNode.put("totalCount", itemsNode.size());
        formPropertiesNode.put("items", (JsonNode)itemsNode);
        propertiesNode.put("formproperties", (JsonNode)formPropertiesNode);
    }

    protected void addListeners(List<ActivitiListener> listeners, boolean isExecutionListener, ObjectNode propertiesNode) {
        String propertyName = null;
        String eventType = null;
        String listenerClass = null;
        String listenerExpression = null;
        String listenerDelegateExpression = null;
        if (isExecutionListener) {
            propertyName = "executionlisteners";
            eventType = "execution_listener_event_type";
            listenerClass = "execution_listener_class";
            listenerExpression = "execution_listener_expression";
            listenerDelegateExpression = "execution_listener_delegate_expression";
        } else {
            propertyName = "tasklisteners";
            eventType = "task_listener_event_type";
            listenerClass = "task_listener_class";
            listenerExpression = "task_listener_expression";
            listenerDelegateExpression = "task_listener_delegate_expression";
        }
        ObjectNode listenersNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (ActivitiListener listener : listeners) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put(eventType, listener.getEvent());
            if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(listener.getImplementationType())) {
                propertyItemNode.put(listenerClass, listener.getImplementation());
                this.addFieldExtensions(listener.getFieldExtensions(), propertyItemNode, isExecutionListener);
            } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(listener.getImplementationType())) {
                propertyItemNode.put(listenerExpression, listener.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(listener.getImplementationType())) {
                propertyItemNode.put(listenerDelegateExpression, listener.getImplementation());
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        listenersNode.put("totalCount", itemsNode.size());
        listenersNode.put("items", (JsonNode)itemsNode);
        propertiesNode.put(propertyName, (JsonNode)listenersNode);
    }

    protected void addFieldExtensions(List<FieldExtension> extensions, ObjectNode propertiesNode, boolean isExecutionListener) {
        String fieldNameProperty = null;
        String fieldValueProperty = null;
        String fieldExpressionProperty = null;
        String fieldProperty = null;
        if (isExecutionListener) {
            fieldNameProperty = "execution_listener_field_name";
            fieldValueProperty = "execution_listener_field_value";
            fieldExpressionProperty = "execution_listener_field_expression";
            fieldProperty = "execution_listener_fields";
        } else {
            fieldNameProperty = "task_listener_field_name";
            fieldValueProperty = "task_listener_field_value";
            fieldExpressionProperty = "task_listener_field_expression";
            fieldProperty = "task_listener_fields";
        }
        ObjectNode fieldExtensionsNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (FieldExtension extension : extensions) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put(fieldNameProperty, extension.getFieldName());
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                propertyItemNode.put(fieldValueProperty, extension.getStringValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)extension.getExpression())) {
                propertyItemNode.put(fieldExpressionProperty, extension.getExpression());
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        fieldExtensionsNode.put("totalCount", itemsNode.size());
        fieldExtensionsNode.put("items", (JsonNode)itemsNode);
        propertiesNode.put(fieldProperty, fieldExtensionsNode.toString());
    }

    protected void addFieldExtensions(List<FieldExtension> extensions, ObjectNode propertiesNode) {
        ObjectNode fieldExtensionsNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (FieldExtension extension : extensions) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put("servicetask_field_name", extension.getFieldName());
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                propertyItemNode.put("servicetask_field_value", extension.getStringValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)extension.getExpression())) {
                propertyItemNode.put("servicetask_field_expression", extension.getExpression());
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        fieldExtensionsNode.put("totalCount", itemsNode.size());
        fieldExtensionsNode.put("items", (JsonNode)itemsNode);
        propertiesNode.put("servicetaskfields", (JsonNode)fieldExtensionsNode);
    }

    protected void addEventProperties(Event event, ObjectNode propertiesNode) {
        List eventDefinitions = event.getEventDefinitions();
        if (eventDefinitions.size() == 1) {
            EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
            if (eventDefinition instanceof ErrorEventDefinition) {
                ErrorEventDefinition errorDefinition = (ErrorEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)errorDefinition.getErrorCode())) {
                    propertiesNode.put("errorref", errorDefinition.getErrorCode());
                }
            } else if (eventDefinition instanceof MessageEventDefinition) {
                MessageEventDefinition messageDefinition = (MessageEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)messageDefinition.getMessageRef())) {
                    String messageRef = messageDefinition.getMessageRef();
                    if (messageRef.startsWith(this.model.getTargetNamespace())) {
                        messageRef = messageRef.replace(this.model.getTargetNamespace(), "");
                        messageRef = messageRef.replaceFirst(":", "");
                    } else {
                        for (String prefix : this.model.getNamespaces().keySet()) {
                            String namespace = this.model.getNamespace(prefix);
                            if (!messageRef.startsWith(namespace)) continue;
                            messageRef = messageRef.replace(this.model.getTargetNamespace(), "");
                            messageRef = prefix + messageRef;
                        }
                    }
                    propertiesNode.put("messageref", messageRef);
                }
            } else if (eventDefinition instanceof SignalEventDefinition) {
                SignalEventDefinition signalDefinition = (SignalEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)signalDefinition.getSignalRef())) {
                    propertiesNode.put("signalref", signalDefinition.getSignalRef());
                }
            } else if (eventDefinition instanceof TimerEventDefinition) {
                TimerEventDefinition timerDefinition = (TimerEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeDuration())) {
                    propertiesNode.put("timerdurationdefinition", timerDefinition.getTimeDuration());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeCycle())) {
                    propertiesNode.put("timercycledefinition", timerDefinition.getTimeCycle());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeDate())) {
                    propertiesNode.put("timerdatedefinition", timerDefinition.getTimeDate());
                }
            }
        }
    }

    protected void convertJsonToFormProperties(JsonNode objectNode, BaseElement element) {
        JsonNode formPropertiesNode = this.getProperty("formproperties", objectNode);
        if (formPropertiesNode != null) {
            if (formPropertiesNode.isValueNode() && StringUtils.isNotEmpty((CharSequence)formPropertiesNode.asText())) {
                try {
                    formPropertiesNode = this.objectMapper.readTree(formPropertiesNode.asText());
                }
                catch (Exception e) {
                    LOGGER.info("Form properties node can not be read", (Throwable)e);
                }
            }
            JsonNode itemsArrayNode = formPropertiesNode.get("items");
            String readWriteReqNode = null;
            JsonNode formValuesNode = null;
            JsonNode formValuesArrayNode = null;
            if (itemsArrayNode != null) {
                for (JsonNode formNode : itemsArrayNode) {
                    JsonNode formIdNode = formNode.get("formproperty_id");
                    if (formIdNode == null || !StringUtils.isNotEmpty((CharSequence)formIdNode.asText())) continue;
                    FormProperty formProperty = new FormProperty();
                    formProperty.setId(formIdNode.asText());
                    formProperty.setName(this.getValueAsString("formproperty_name", formNode));
                    formProperty.setType(this.getValueAsString("formproperty_type", formNode));
                    formProperty.setExpression(this.getValueAsString("formproperty_expression", formNode));
                    formProperty.setVariable(this.getValueAsString("formproperty_variable", formNode));
                    readWriteReqNode = this.getValueAsString("formproperty_required", formNode);
                    if ("Yes".equalsIgnoreCase(readWriteReqNode)) {
                        formProperty.setRequired(true);
                    }
                    if ("No".equalsIgnoreCase(readWriteReqNode = this.getValueAsString("formproperty_readable", formNode))) {
                        formProperty.setReadable(false);
                    }
                    if ("No".equalsIgnoreCase(readWriteReqNode = this.getValueAsString("formproperty_writeable", formNode))) {
                        formProperty.setWriteable(false);
                    }
                    if ((formValuesNode = formNode.get("formproperty_formvalues")) != null && StringUtils.isNotEmpty((CharSequence)formValuesNode.asText()) && !"undefined".equals(formValuesNode.asText())) {
                        if (formValuesNode.isValueNode()) {
                            try {
                                formValuesNode = this.objectMapper.readTree(formValuesNode.asText());
                            }
                            catch (Exception e) {
                                LOGGER.info("Form properties values node can not be read", (Throwable)e);
                            }
                        }
                        formValuesArrayNode = formValuesNode.get("items");
                        ArrayList<FormValue> formValues = new ArrayList<FormValue>();
                        for (JsonNode valueNode : formValuesArrayNode) {
                            JsonNode valueIdNode = valueNode.get("formproperty_formvalue_id");
                            if (valueIdNode == null || !StringUtils.isNotEmpty((CharSequence)valueIdNode.asText())) continue;
                            FormValue formValue = new FormValue();
                            formValue.setId(valueIdNode.asText());
                            formValue.setName(this.getValueAsString("formproperty_formvalue_name", valueNode));
                            formValues.add(formValue);
                        }
                        formProperty.setFormValues(formValues);
                    }
                    if (element instanceof StartEvent) {
                        ((StartEvent)element).getFormProperties().add(formProperty);
                        continue;
                    }
                    if (!(element instanceof UserTask)) continue;
                    ((UserTask)element).getFormProperties().add(formProperty);
                }
            }
        }
    }

    protected void convertJsonToListeners(JsonNode objectNode, BaseElement element) {
        JsonNode listenersNode = null;
        String propertyName = null;
        String eventType = null;
        String listenerClass = null;
        String listenerExpression = null;
        String listenerDelegateExpression = null;
        String listenerFields = null;
        String listenerFieldName = null;
        String listenerFieldValue = null;
        String listenerFieldExpression = null;
        JsonNode listenerFieldsNode = null;
        JsonNode listenerFieldsArrayNode = null;
        if (element instanceof UserTask) {
            propertyName = "tasklisteners";
            eventType = "task_listener_event_type";
            listenerClass = "task_listener_class";
            listenerExpression = "task_listener_expression";
            listenerDelegateExpression = "task_listener_delegate_expression";
            listenerFields = "task_listener_fields";
            listenerFieldName = "task_listener_field_name";
            listenerFieldValue = "task_listener_field_value";
            listenerFieldExpression = "task_listener_expression";
        } else {
            propertyName = "executionlisteners";
            eventType = "execution_listener_event_type";
            listenerClass = "execution_listener_class";
            listenerExpression = "execution_listener_expression";
            listenerDelegateExpression = "execution_listener_delegate_expression";
            listenerFields = "execution_listener_fields";
            listenerFieldName = "execution_listener_field_name";
            listenerFieldValue = "execution_listener_field_value";
            listenerFieldExpression = "execution_listener_expression";
        }
        listenersNode = this.getProperty(propertyName, objectNode);
        if (listenersNode != null) {
            JsonNode itemsArrayNode;
            if (listenersNode.isValueNode() && StringUtils.isNotEmpty((CharSequence)listenersNode.asText())) {
                try {
                    listenersNode = this.objectMapper.readTree(listenersNode.asText());
                }
                catch (Exception e) {
                    LOGGER.info("Listeners node can not be read", (Throwable)e);
                }
            }
            if ((itemsArrayNode = listenersNode.get("items")) != null) {
                for (JsonNode itemNode : itemsArrayNode) {
                    JsonNode typeNode = itemNode.get(eventType);
                    if (typeNode == null || !StringUtils.isNotEmpty((CharSequence)typeNode.asText())) continue;
                    ActivitiListener listener = new ActivitiListener();
                    listener.setEvent(typeNode.asText());
                    if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString(listenerClass, itemNode))) {
                        listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
                        listener.setImplementation(this.getValueAsString(listenerClass, itemNode));
                    } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString(listenerExpression, itemNode))) {
                        listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION);
                        listener.setImplementation(this.getValueAsString(listenerExpression, itemNode));
                    } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString(listenerDelegateExpression, itemNode))) {
                        listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
                        listener.setImplementation(this.getValueAsString(listenerDelegateExpression, itemNode));
                    }
                    listenerFieldsNode = itemNode.get(listenerFields);
                    if (listenerFieldsNode != null && StringUtils.isNotEmpty((CharSequence)listenerFieldsNode.asText()) && !"undefined".equals(listenerFieldsNode.asText()) && listenerFieldsNode.isValueNode()) {
                        try {
                            listenerFieldsNode = this.objectMapper.readTree(listenerFieldsNode.asText());
                        }
                        catch (Exception e) {
                            LOGGER.info("Listener fields node can not be read", (Throwable)e);
                        }
                    }
                    if (listenerFieldsNode != null) {
                        listenerFieldsArrayNode = listenerFieldsNode.get("items");
                        ArrayList<FieldExtension> fields = new ArrayList<FieldExtension>();
                        if (listenerFieldsArrayNode != null) {
                            for (JsonNode fieldNode : listenerFieldsArrayNode) {
                                JsonNode fieldNameNode = fieldNode.get(listenerFieldName);
                                if (fieldNameNode == null || !StringUtils.isNotEmpty((CharSequence)fieldNameNode.asText())) continue;
                                FieldExtension field = new FieldExtension();
                                field.setFieldName(fieldNameNode.asText());
                                field.setStringValue(this.getValueAsString(listenerFieldValue, fieldNode));
                                field.setExpression(this.getValueAsString(listenerFieldExpression, fieldNode));
                                fields.add(field);
                            }
                        }
                        listener.setFieldExtensions(fields);
                    }
                    if (element instanceof Process) {
                        ((Process)element).getExecutionListeners().add(listener);
                        continue;
                    }
                    if (element instanceof SequenceFlow) {
                        ((SequenceFlow)element).getExecutionListeners().add(listener);
                        continue;
                    }
                    if (element instanceof UserTask) {
                        ((UserTask)element).getTaskListeners().add(listener);
                        continue;
                    }
                    if (!(element instanceof Activity)) continue;
                    ((Activity)element).getExecutionListeners().add(listener);
                }
            }
        }
    }

    protected void convertJsonToTimerDefinition(JsonNode objectNode, Event event) {
        String timeDate = this.getPropertyValueAsString("timerdatedefinition", objectNode);
        String timeCycle = this.getPropertyValueAsString("timercycledefinition", objectNode);
        String timeDuration = this.getPropertyValueAsString("timerdurationdefinition", objectNode);
        if (StringUtils.isNotEmpty((CharSequence)timeDate) || StringUtils.isNotEmpty((CharSequence)timeCycle) || StringUtils.isNotEmpty((CharSequence)timeDuration)) {
            TimerEventDefinition eventDefinition = new TimerEventDefinition();
            if (StringUtils.isNotEmpty((CharSequence)timeDate)) {
                eventDefinition.setTimeDate(timeDate);
            } else if (StringUtils.isNotEmpty((CharSequence)timeCycle)) {
                eventDefinition.setTimeCycle(timeCycle);
            } else if (StringUtils.isNotEmpty((CharSequence)timeDuration)) {
                eventDefinition.setTimeDuration(timeDuration);
            }
            event.getEventDefinitions().add(eventDefinition);
        }
    }

    protected void convertJsonToSignalDefinition(JsonNode objectNode, Event event) {
        String signalRef = this.getPropertyValueAsString("signalref", objectNode);
        if (StringUtils.isNotEmpty((CharSequence)signalRef)) {
            SignalEventDefinition eventDefinition = new SignalEventDefinition();
            eventDefinition.setSignalRef(signalRef);
            event.getEventDefinitions().add(eventDefinition);
        }
    }

    protected void convertJsonToMessageDefinition(JsonNode objectNode, Event event) {
        String messageRef = this.getPropertyValueAsString("messageref", objectNode);
        if (StringUtils.isNotEmpty((CharSequence)messageRef)) {
            MessageEventDefinition eventDefinition = new MessageEventDefinition();
            eventDefinition.setMessageRef(messageRef);
            event.getEventDefinitions().add(eventDefinition);
        }
    }

    protected void convertJsonToErrorDefinition(JsonNode objectNode, Event event) {
        String errorRef = this.getPropertyValueAsString("errorref", objectNode);
        if (StringUtils.isNotEmpty((CharSequence)errorRef)) {
            ErrorEventDefinition eventDefinition = new ErrorEventDefinition();
            eventDefinition.setErrorCode(errorRef);
            event.getEventDefinitions().add(eventDefinition);
        }
    }

    protected String getValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = objectNode.get(name);
        if (propertyNode != null && !"null".equalsIgnoreCase(propertyNode.asText())) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    protected List<String> getValueAsList(String name, JsonNode objectNode) {
        ArrayList<String> resultList = new ArrayList<String>();
        String propertyValue = this.getValueAsString(name, objectNode);
        if (propertyValue != null) {
            String[] valueList;
            for (String value : valueList = propertyValue.split(",")) {
                resultList.add(value.trim());
            }
        }
        return resultList;
    }

    protected String getPropertyValueAsString(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsString(name, objectNode);
    }

    protected boolean getPropertyValueAsBoolean(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsBoolean(name, objectNode);
    }

    protected boolean getPropertyValueAsBoolean(String name, JsonNode objectNode, boolean defaultValue) {
        return JsonConverterUtil.getPropertyValueAsBoolean(name, objectNode, defaultValue);
    }

    protected List<String> getPropertyValueAsList(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsList(name, objectNode);
    }

    protected JsonNode getProperty(String name, JsonNode objectNode) {
        return JsonConverterUtil.getProperty(name, objectNode);
    }

    protected String convertListToCommaSeparatedString(List<String> stringList) {
        String resultString = null;
        if (stringList != null && !stringList.isEmpty()) {
            StringBuilder expressionBuilder = new StringBuilder();
            for (String singleItem : stringList) {
                if (expressionBuilder.length() > 0) {
                    expressionBuilder.append(",");
                }
                expressionBuilder.append(singleItem);
            }
            resultString = expressionBuilder.toString();
        }
        return resultString;
    }
}

