/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.editor.language.json.converter.ActivityProcessor;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.apache.commons.lang3.StringUtils;

public class SequenceFlowJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        SequenceFlowJsonConverter.fillJsonTypes(convertersToBpmnMap);
        SequenceFlowJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("SequenceFlow", SequenceFlowJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(SequenceFlow.class, SequenceFlowJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "SequenceFlow";
    }

    @Override
    public void convertToJson(BaseElement baseElement, ActivityProcessor processor, BpmnModel model, FlowElementsContainer container, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        SequenceFlow sequenceFlow = (SequenceFlow)baseElement;
        ObjectNode flowNode = BpmnJsonConverterUtil.createChildShape(sequenceFlow.getId(), "SequenceFlow", 172.0, 212.0, 128.0, 212.0);
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", model.getGraphicInfo(sequenceFlow.getSourceRef()).getWidth() / 2.0);
        dockNode.put("y", model.getGraphicInfo(sequenceFlow.getSourceRef()).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        if (model.getFlowLocationGraphicInfo(sequenceFlow.getId()).size() > 2) {
            for (int i = 1; i < model.getFlowLocationGraphicInfo(sequenceFlow.getId()).size() - 1; ++i) {
                GraphicInfo graphicInfo = (GraphicInfo)model.getFlowLocationGraphicInfo(sequenceFlow.getId()).get(i);
                dockNode = this.objectMapper.createObjectNode();
                dockNode.put("x", graphicInfo.getX());
                dockNode.put("y", graphicInfo.getY());
                dockersArrayNode.add((JsonNode)dockNode);
            }
        }
        dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", model.getGraphicInfo(sequenceFlow.getTargetRef()).getWidth() / 2.0);
        dockNode.put("y", model.getGraphicInfo(sequenceFlow.getTargetRef()).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        flowNode.put("dockers", (JsonNode)dockersArrayNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(sequenceFlow.getTargetRef()));
        flowNode.put("outgoing", (JsonNode)outgoingArrayNode);
        flowNode.put("target", (JsonNode)BpmnJsonConverterUtil.createResourceNode(sequenceFlow.getTargetRef()));
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("overrideid", sequenceFlow.getId());
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getName())) {
            propertiesNode.put("name", sequenceFlow.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getDocumentation())) {
            propertiesNode.put("documentation", sequenceFlow.getDocumentation());
        }
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getConditionExpression())) {
            propertiesNode.put("conditionsequenceflow", sequenceFlow.getConditionExpression());
        }
        if (sequenceFlow.getExecutionListeners().size() > 0) {
            BpmnJsonConverterUtil.convertListenersToJson(sequenceFlow.getExecutionListeners(), true, propertiesNode);
        }
        flowNode.put("properties", (JsonNode)propertiesNode);
        shapesArrayNode.add((JsonNode)flowNode);
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        JsonNode conditionNode;
        SequenceFlow flow = new SequenceFlow();
        String sourceRef = BpmnJsonConverterUtil.lookForSourceRef(elementNode.get("resourceId").asText(), modelNode.get("childShapes"));
        if (sourceRef != null) {
            String targetId;
            flow.setSourceRef(sourceRef);
            JsonNode targetNode = elementNode.get("target");
            if (targetNode != null && !targetNode.isNull() && shapeMap.get(targetId = targetNode.get("resourceId").asText()) != null) {
                flow.setTargetRef(BpmnJsonConverterUtil.getElementId(shapeMap.get(targetId)));
            }
        }
        if ((conditionNode = this.getProperty("conditionsequenceflow", elementNode)) != null) {
            JsonNode expressionNode;
            if (conditionNode.isTextual() && !conditionNode.isNull()) {
                flow.setConditionExpression(conditionNode.asText());
            } else if (conditionNode.get("expression") != null && (expressionNode = conditionNode.get("expression")).get("type") != null) {
                String expressionType = expressionNode.get("type").asText();
                if ("variables".equalsIgnoreCase(expressionType) && expressionNode.get("fieldType") != null) {
                    String fieldType = expressionNode.get("fieldType").asText();
                    if ("field".equalsIgnoreCase(fieldType)) {
                        this.setFieldConditionExpression(flow, expressionNode);
                    } else if ("outcome".equalsIgnoreCase(fieldType)) {
                        this.setOutcomeConditionExpression(flow, expressionNode);
                    }
                } else if (expressionNode.get("staticValue") != null && !expressionNode.get("staticValue").isNull()) {
                    flow.setConditionExpression(expressionNode.get("staticValue").asText());
                }
            }
        }
        return flow;
    }

    protected void setFieldConditionExpression(SequenceFlow flow, JsonNode expressionNode) {
        String fieldId = null;
        if (expressionNode.get("fieldId") != null && !expressionNode.get("fieldId").isNull()) {
            fieldId = expressionNode.get("fieldId").asText();
        }
        String operator = null;
        if (expressionNode.get("operator") != null && !expressionNode.get("operator").isNull()) {
            operator = expressionNode.get("operator").asText();
        }
        String value = null;
        if (expressionNode.get("value") != null && !expressionNode.get("value").isNull()) {
            value = expressionNode.get("value").asText();
        }
        if (fieldId != null && operator != null && value != null) {
            flow.setConditionExpression("${" + fieldId + " " + operator + " " + value + "}");
            this.addExtensionElement("conditionFieldId", fieldId, flow);
            this.addExtensionElement("conditionOperator", operator, flow);
            this.addExtensionElement("conditionValue", value, flow);
        }
    }

    protected void setOutcomeConditionExpression(SequenceFlow flow, JsonNode expressionNode) {
        Long formId = null;
        if (expressionNode.get("outcomeFormId") != null && !expressionNode.get("outcomeFormId").isNull()) {
            formId = expressionNode.get("outcomeFormId").asLong();
        }
        String operator = null;
        if (expressionNode.get("operator") != null && !expressionNode.get("operator").isNull()) {
            operator = expressionNode.get("operator").asText();
        }
        String outcomeName = null;
        if (expressionNode.get("outcomeName") != null && !expressionNode.get("outcomeName").isNull()) {
            outcomeName = expressionNode.get("outcomeName").asText();
        }
        if (formId != null && operator != null && outcomeName != null) {
            flow.setConditionExpression("${form" + formId + "outcome " + operator + " " + outcomeName + "}");
            this.addExtensionElement("conditionFormId", String.valueOf(formId), flow);
            this.addExtensionElement("conditionOperator", operator, flow);
            this.addExtensionElement("conditionOutcomeName", outcomeName, flow);
        }
    }

    protected void addExtensionElement(String name, String value, SequenceFlow flow) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setNamespace("http://activiti.com/modeler");
        extensionElement.setNamespacePrefix("modeler");
        extensionElement.setName(name);
        extensionElement.setElementText(value);
        flow.addExtensionElement(extensionElement);
    }
}

