/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.osgi;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.osgi.HeaderParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Extender
implements BundleTrackerCustomizer,
ServiceTrackerCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Extender.class);
    private static final String META_INF_SERVICES_DIR = "META-INF/services";
    private static final String SCRIPT_ENGINE_SERVICE_FILE = "javax.script.ScriptEngineFactory";
    private static BundleContext context;
    private final BundleTracker bundleTracker;
    private final ServiceTracker engineServiceTracker;
    private long timeout = 5000L;
    private Map<Long, List<BundleScriptEngineResolver>> resolvers = new ConcurrentHashMap<Long, List<BundleScriptEngineResolver>>();

    public Extender(BundleContext context) {
        Extender.context = context;
        this.engineServiceTracker = new ServiceTracker(context, ProcessEngine.class.getName(), (ServiceTrackerCustomizer)this);
        this.bundleTracker = new BundleTracker(context, 44, (BundleTrackerCustomizer)this);
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public void open() {
        this.engineServiceTracker.open();
    }

    public void close() {
        this.engineServiceTracker.close();
    }

    public Object addingService(ServiceReference reference) {
        new Thread(){

            @Override
            public void run() {
                Extender.this.bundleTracker.open();
            }
        }.start();
        return context.getService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        context.ungetService(reference);
        if (this.engineServiceTracker.size() == 0) {
            this.bundleTracker.close();
        }
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (event == null) {
            this.checkInitialBundle(bundle);
        } else {
            this.bundleChanged(event);
        }
        this.checkBundleScriptEngines(bundle);
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object arg2) {
        if (event == null) {
            return;
        }
        this.bundleChanged(event);
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object arg2) {
        List<BundleScriptEngineResolver> r = this.resolvers.remove(bundle.getBundleId());
        if (r != null) {
            for (BundleScriptEngineResolver service : r) {
                service.unregister();
            }
        }
    }

    private void checkInitialBundle(Bundle b) {
        if (b.getState() == 4 || b.getState() == 8 || b.getState() == 32) {
            this.checkBundle(b);
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (event.getType() == 32) {
            this.checkBundle(bundle);
        } else if (event.getType() == 2) {
            this.checkBundleScriptEngines(bundle);
        }
    }

    private void checkBundleScriptEngines(Bundle bundle) {
        ArrayList<BundleScriptEngineResolver> r = new ArrayList<BundleScriptEngineResolver>();
        this.registerScriptEngines(bundle, r);
        for (BundleScriptEngineResolver service : r) {
            service.register();
        }
        this.resolvers.put(bundle.getBundleId(), r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBundle(Bundle bundle) {
        LOGGER.debug("Scanning bundle {} for activiti process", (Object)bundle.getSymbolicName());
        try {
            ArrayList<URL> pathList = new ArrayList<URL>();
            String activitiHeader = (String)bundle.getHeaders().get("Activiti-Bundle");
            if (activitiHeader == null) {
                activitiHeader = "OSGI-INF/activiti/";
            }
            List<HeaderParser.PathElement> paths = HeaderParser.parseHeader(activitiHeader);
            for (HeaderParser.PathElement path : paths) {
                String filePattern;
                String baseName;
                String name = path.getName();
                if (name.endsWith("/")) {
                    this.addEntries(bundle, name, "*.*", pathList);
                    continue;
                }
                int pos = name.lastIndexOf(47);
                if (pos < 0) {
                    baseName = "/";
                    filePattern = name;
                } else {
                    baseName = name.substring(0, pos + 1);
                    filePattern = name.substring(pos + 1);
                }
                if (this.hasWildcards(filePattern)) {
                    this.addEntries(bundle, baseName, filePattern, pathList);
                    continue;
                }
                this.addEntry(bundle, name, pathList);
            }
            if (!pathList.isEmpty()) {
                LOGGER.debug("Found activiti process in bundle {} with paths: {}", (Object)bundle.getSymbolicName(), pathList);
                ProcessEngine engine = (ProcessEngine)this.engineServiceTracker.waitForService(this.timeout);
                if (engine == null) {
                    throw new IllegalStateException("Unable to find a ProcessEngine service");
                }
                RepositoryService service = engine.getRepositoryService();
                DeploymentBuilder builder = service.createDeployment();
                builder.name(bundle.getSymbolicName());
                for (URL url : pathList) {
                    InputStream is = url.openStream();
                    if (is == null) {
                        throw new IOException("Error opening url: " + url);
                    }
                    try {
                        builder.addInputStream(Extender.getPath(url), is);
                    }
                    finally {
                        is.close();
                    }
                }
                builder.enableDuplicateFiltering();
                builder.deploy();
            } else {
                LOGGER.debug("No activiti process found in bundle {}", (Object)bundle.getSymbolicName());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Unable to deploy activiti bundle", t);
        }
    }

    private void addEntry(Bundle bundle, String path, List<URL> pathList) {
        URL override = this.getOverrideURL(bundle, path);
        if (override == null) {
            URL url = bundle.getEntry(path);
            pathList.add(url);
        } else {
            pathList.add(override);
        }
    }

    private void addEntries(Bundle bundle, String path, String filePattern, List<URL> pathList) {
        Enumeration e = bundle.findEntries(path, filePattern, false);
        while (e != null && e.hasMoreElements()) {
            URL u = (URL)e.nextElement();
            URL override = this.getOverrideURL(bundle, u, path);
            if (override == null) {
                pathList.add(u);
                continue;
            }
            pathList.add(override);
        }
    }

    private boolean hasWildcards(String path) {
        return path.indexOf("*") >= 0;
    }

    private String getFilePart(URL url) {
        String path = url.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    private String cachePath(Bundle bundle, String filePath) {
        return Integer.toHexString(bundle.hashCode()) + "/" + filePath;
    }

    private URL getOverrideURLForCachePath(String privatePath) {
        URL override = null;
        File privateDataVersion = context.getDataFile(privatePath);
        if (privateDataVersion != null && privateDataVersion.exists()) {
            try {
                override = privateDataVersion.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.error("Unexpected URL Conversion Issue", (Throwable)e);
            }
        }
        return override;
    }

    private URL getOverrideURL(Bundle bundle, String path) {
        String cachePath = this.cachePath(bundle, path);
        return this.getOverrideURLForCachePath(cachePath);
    }

    private URL getOverrideURL(Bundle bundle, URL path, String basePath) {
        String cachePath = this.cachePath(bundle, basePath + this.getFilePart(path));
        return this.getOverrideURLForCachePath(cachePath);
    }

    private static String getPath(URL url) {
        String path = url.toExternalForm();
        return path.replaceAll("bundle://[^/]*/", "");
    }

    public static ScriptEngine resolveScriptEngine(String scriptEngineName) throws InvalidSyntaxException {
        ServiceReference[] refs = context.getServiceReferences(ScriptEngineResolver.class.getName(), null);
        if (refs == null) {
            LOGGER.info("No OSGi script engine resolvers available!");
            return null;
        }
        LOGGER.debug("Found {} OSGi ScriptEngineResolver services", (Object)refs.length);
        for (ServiceReference ref : refs) {
            ScriptEngineResolver resolver = (ScriptEngineResolver)context.getService(ref);
            ScriptEngine engine = resolver.resolveScriptEngine(scriptEngineName);
            context.ungetService(ref);
            LOGGER.debug("OSGi resolver {} produced {} engine {}", new Object[]{resolver, scriptEngineName, engine});
            if (engine == null) continue;
            return engine;
        }
        return null;
    }

    protected void registerScriptEngines(Bundle bundle, List<BundleScriptEngineResolver> resolvers) {
        URL configURL = null;
        Enumeration e = bundle.findEntries(META_INF_SERVICES_DIR, SCRIPT_ENGINE_SERVICE_FILE, false);
        while (e != null && e.hasMoreElements()) {
            configURL = (URL)e.nextElement();
        }
        if (configURL != null) {
            LOGGER.info("Found ScriptEngineFactory in {}", (Object)bundle.getSymbolicName());
            resolvers.add(new BundleScriptEngineResolver(bundle, configURL));
        }
    }

    protected static class BundleScriptEngineResolver
    implements ScriptEngineResolver {
        protected final Bundle bundle;
        private ServiceRegistration reg;
        private final URL configFile;

        public BundleScriptEngineResolver(Bundle bundle, URL configFile) {
            this.bundle = bundle;
            this.configFile = configFile;
        }

        public void register() {
            if (this.bundle.getBundleContext() != null) {
                this.reg = this.bundle.getBundleContext().registerService(ScriptEngineResolver.class.getName(), (Object)this, null);
            }
        }

        public void unregister() {
            if (this.reg != null) {
                this.reg.unregister();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ScriptEngine resolveScriptEngine(String name) {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(this.configFile.openStream()));
                String className = in.readLine();
                in.close();
                Class cls = this.bundle.loadClass(className);
                if (!ScriptEngineFactory.class.isAssignableFrom(cls)) {
                    throw new IllegalStateException("Invalid ScriptEngineFactory: " + cls.getName());
                }
                ScriptEngineFactory factory = (ScriptEngineFactory)cls.newInstance();
                List<String> names = factory.getNames();
                for (String test : names) {
                    ScriptEngine engine;
                    if (!test.equals(name)) continue;
                    ClassLoader old = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(factory.getClass().getClassLoader());
                        engine = factory.getScriptEngine();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(old);
                    }
                    LOGGER.trace("Resolved ScriptEngineFactory: {} for expected name: {}", (Object)engine, (Object)name);
                    return engine;
                }
                LOGGER.debug("ScriptEngineFactory: {} does not match expected name: {}", (Object)factory.getEngineName(), (Object)name);
                return null;
            }
            catch (Exception e) {
                LOGGER.warn("Cannot create ScriptEngineFactory: {}", (Object)e.getClass().getName(), (Object)e);
                return null;
            }
        }

        public String toString() {
            return "OSGi script engine resolver for " + this.bundle.getSymbolicName();
        }
    }

    public static interface ScriptEngineResolver {
        public ScriptEngine resolveScriptEngine(String var1);
    }
}

