/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.activiti.rest.common.application.ContentTypeResolver;
import org.activiti.rest.common.application.DefaultContentTypeResolver;
import org.activiti.rest.security.BasicAuthenticationProvider;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.spring.boot.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.servlet.configuration.EnableWebMvcSecurity;

@Configuration
@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
@ConditionalOnClass(name={"org.activiti.rest.service.api.RestUrls", "org.springframework.web.servlet.DispatcherServlet"})
public class RestApiAutoConfiguration {
    @Bean
    public RestResponseFactory restResponseFactory() {
        RestResponseFactory restResponseFactory = new RestResponseFactory();
        return restResponseFactory;
    }

    @Bean
    public ContentTypeResolver contentTypeResolver() {
        DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
        return resolver;
    }

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        return mapper;
    }

    @Configuration
    @ConditionalOnClass(name={"org.activiti.rest.service.api.RestUrls", "org.springframework.web.servlet.DispatcherServlet"})
    @EnableWebSecurity
    @EnableWebMvcSecurity
    public static class SecurityConfiguration
    extends WebSecurityConfigurerAdapter {
        @Bean
        public AuthenticationProvider authenticationProvider() {
            return new BasicAuthenticationProvider();
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.authenticationProvider(this.authenticationProvider()).csrf().disable()).authorizeRequests().anyRequest()).authenticated().and()).httpBasic();
        }
    }

    @Configuration
    @ComponentScan(value={"org.activiti.rest.exception", "org.activiti.rest.service.api"})
    public static class ComponentScanRestResourcesConfiguration {
    }
}

