/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.ant.compress.util.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.FileUtils;

public class CommonsCompressArchiveScanner
extends ArchiveScanner {
    private final ArchiveStreamFactory factory;
    private final ResourceBuilder builder;

    public CommonsCompressArchiveScanner(ArchiveStreamFactory factory, ResourceBuilder builder) {
        this.factory = factory;
        this.builder = builder;
    }

    protected void fillMapsFromArchive(Resource src, String encoding, Map fileEntries, Map matchFileEntries, Map dirEntries, Map matchDirEntries) {
        ArchiveEntry entry = null;
        ArchiveInputStream ai = null;
        try {
            try {
                ai = this.factory.getArchiveStream(new BufferedInputStream(src.getInputStream()), encoding);
            }
            catch (IOException ex) {
                throw new BuildException("problem opening " + src, (Throwable)ex);
            }
            while ((entry = ai.getNextEntry()) != null) {
                Resource r = this.builder.buildResource(src, encoding, entry);
                String name = entry.getName();
                if (entry.isDirectory()) {
                    name = CommonsCompressArchiveScanner.trimSeparator((String)name);
                    dirEntries.put(name, r);
                    if (!this.match(name)) continue;
                    matchDirEntries.put(name, r);
                    continue;
                }
                fileEntries.put(name, r);
                if (!this.match(name)) continue;
                matchFileEntries.put(name, r);
            }
        }
        catch (IOException ex) {
            try {
                throw new BuildException("problem reading " + src, (Throwable)ex);
            }
            catch (Throwable throwable) {
                FileUtils.close(ai);
                throw throwable;
            }
        }
        FileUtils.close((InputStream)ai);
    }

    public static interface ResourceBuilder {
        public Resource buildResource(Resource var1, String var2, ArchiveEntry var3);
    }
}

