/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.taskdefs;

import org.apache.ant.compress.resources.ArFileSet;
import org.apache.ant.compress.taskdefs.ArchiveBase;
import org.apache.ant.compress.util.ArStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.Resource;

public class Ar
extends ArchiveBase {
    private static final String NO_DIRS_MESSAGE = "ar archives cannot store directory entries";

    public Ar() {
        this.setFactory(new ArStreamFactory());
        this.setEntryBuilder(new ArchiveBase.EntryBuilder(){

            public ArchiveEntry buildEntry(ArchiveBase.ResourceWithFlags r) {
                boolean isDir = r.getResource().isDirectory();
                if (isDir) {
                    throw new BuildException(Ar.NO_DIRS_MESSAGE);
                }
                int mode = 33188;
                if (!isDir && r.getCollectionFlags().hasModeBeenSet()) {
                    mode = r.getCollectionFlags().getMode();
                } else if (isDir && r.getCollectionFlags().hasDirModeBeenSet()) {
                    mode = r.getCollectionFlags().getDirMode();
                } else if (r.getResourceFlags().hasModeBeenSet()) {
                    mode = r.getResourceFlags().getMode();
                }
                int uid = 0;
                if (r.getResourceFlags().hasUserIdBeenSet()) {
                    uid = r.getResourceFlags().getUserId();
                } else if (r.getCollectionFlags().hasUserIdBeenSet()) {
                    uid = r.getCollectionFlags().getUserId();
                }
                int gid = 0;
                if (r.getResourceFlags().hasGroupIdBeenSet()) {
                    gid = r.getResourceFlags().getGroupId();
                } else if (r.getCollectionFlags().hasGroupIdBeenSet()) {
                    gid = r.getCollectionFlags().getGroupId();
                }
                return new ArArchiveEntry(r.getName(), r.getResource().getSize(), uid, gid, mode, Ar.this.round(r.getResource().getLastModified(), 1000L) / 1000L);
            }
        });
        this.setFileSetBuilder(new ArchiveBase.FileSetBuilder(){

            public ArchiveFileSet buildFileSet(Resource dest) {
                ArFileSet afs = new ArFileSet();
                afs.setSrcResource(dest);
                return afs;
            }
        });
    }

    public void setFilesOnly(boolean b) {
        if (!b) {
            throw new BuildException(NO_DIRS_MESSAGE);
        }
    }
}

