/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ant.compress.util.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public abstract class ExpandBase
extends Expand {
    private final ArchiveStreamFactory factory;

    protected ExpandBase(ArchiveStreamFactory factory) {
        this.factory = factory;
    }

    public void setEncoding(String encoding) {
        throw new BuildException("The " + this.getTaskName() + " task doesn't support the encoding" + " attribute", this.getLocation());
    }

    public void setScanForUnicodeExtraFields(boolean b) {
        throw new BuildException("The " + this.getTaskName() + " task doesn't support the encoding" + " attribute", this.getLocation());
    }

    protected void expandFile(FileUtils fileUtils, File srcF, File dir) {
        if (!srcF.exists()) {
            throw new BuildException("Unable to expand " + srcF + " as the file does not exist", this.getLocation());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(srcF);
            this.expandStream(srcF.getPath(), fis, dir);
        }
        catch (IOException ioe) {
            try {
                throw new BuildException("Error while expanding " + srcF.getPath() + "\n" + ioe.toString(), (Throwable)ioe, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(fis);
                throw throwable;
            }
        }
        FileUtils.close((InputStream)fis);
    }

    protected void expandResource(Resource srcR, File dir) {
        if (!srcR.isExists()) {
            throw new BuildException("Unable to expand " + srcR.getName() + " as the it does not exist", this.getLocation());
        }
        InputStream i = null;
        try {
            i = srcR.getInputStream();
            this.expandStream(srcR.getName(), i, dir);
        }
        catch (IOException ioe) {
            throw new BuildException("Error while expanding " + srcR.getName(), (Throwable)ioe, this.getLocation());
        }
        finally {
            FileUtils.close((InputStream)i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandStream(String name, InputStream stream, File dir) throws IOException {
        ArchiveInputStream is = null;
        try {
            FileNameMapper mapper = this.getMapper();
            this.log("Expanding: " + name + " into " + dir, 2);
            is = this.factory.getArchiveStream(new BufferedInputStream(stream), this.getEncoding());
            boolean empty = true;
            ArchiveEntry ent = null;
            while ((ent = is.getNextEntry()) != null) {
                empty = false;
                this.log("extracting " + ent.getName(), 4);
                this.extractFile(FileUtils.getFileUtils(), null, dir, (InputStream)is, ent.getName(), ent.getLastModifiedDate(), ent.isDirectory(), mapper);
            }
            if (empty && this.getFailOnEmptyArchive()) {
                throw new BuildException("archive '" + name + "' is empty");
            }
            this.log("expand complete", 3);
        }
        catch (Throwable throwable) {
            FileUtils.close(is);
            throw throwable;
        }
        FileUtils.close((InputStream)is);
    }
}

