/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.taskdefs;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.ant.compress.resources.TarFileSet;
import org.apache.ant.compress.taskdefs.ArchiveBase;
import org.apache.ant.compress.util.TarStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;

public class Tar
extends ArchiveBase {
    private Format format = Format.USTAR;

    public Tar() {
        this.setFactory(new TarStreamFactory(){

            public ArchiveOutputStream getArchiveStream(OutputStream stream, String encoding) throws IOException {
                TarArchiveOutputStream o = (TarArchiveOutputStream)super.getArchiveStream(stream, encoding);
                if (Tar.this.format.equals((Object)Format.OLDGNU)) {
                    o.setLongFileMode(2);
                }
                return o;
            }
        });
        this.setEntryBuilder(new ArchiveBase.EntryBuilder(){

            public ArchiveEntry buildEntry(ArchiveBase.ResourceWithFlags r) {
                boolean isDir = r.getResource().isDirectory();
                TarArchiveEntry ent = new TarArchiveEntry(r.getName(), isDir ? (byte)53 : 48);
                ent.setModTime(Tar.this.round(r.getResource().getLastModified(), 1000L));
                ent.setSize(isDir ? 0L : r.getResource().getSize());
                if (!isDir && r.getCollectionFlags().hasModeBeenSet()) {
                    ent.setMode(r.getCollectionFlags().getMode());
                } else if (isDir && r.getCollectionFlags().hasDirModeBeenSet()) {
                    ent.setMode(r.getCollectionFlags().getDirMode());
                } else if (r.getResourceFlags().hasModeBeenSet()) {
                    ent.setMode(r.getResourceFlags().getMode());
                } else {
                    ent.setMode(isDir ? 16877 : 33188);
                }
                if (r.getResourceFlags().hasUserIdBeenSet()) {
                    ent.setUserId(r.getResourceFlags().getUserId());
                } else if (r.getCollectionFlags().hasUserIdBeenSet()) {
                    ent.setUserId(r.getCollectionFlags().getUserId());
                }
                if (r.getResourceFlags().hasGroupIdBeenSet()) {
                    ent.setGroupId(r.getResourceFlags().getGroupId());
                } else if (r.getCollectionFlags().hasGroupIdBeenSet()) {
                    ent.setGroupId(r.getCollectionFlags().getGroupId());
                }
                if (r.getResourceFlags().hasUserNameBeenSet()) {
                    ent.setUserName(r.getResourceFlags().getUserName());
                } else if (r.getCollectionFlags().hasUserNameBeenSet()) {
                    ent.setUserName(r.getCollectionFlags().getUserName());
                }
                if (r.getResourceFlags().hasGroupNameBeenSet()) {
                    ent.setGroupName(r.getResourceFlags().getGroupName());
                } else if (r.getCollectionFlags().hasGroupNameBeenSet()) {
                    ent.setGroupName(r.getCollectionFlags().getGroupName());
                }
                return ent;
            }
        });
        this.setFileSetBuilder(new ArchiveBase.FileSetBuilder(){

            public ArchiveFileSet buildFileSet(Resource dest) {
                TarFileSet afs = new TarFileSet();
                afs.setSrcResource(dest);
                return afs;
            }
        });
    }

    public void setFormat(Format f) {
        this.format = f;
    }

    public static final class Format
    extends EnumeratedAttribute {
        private static final String USTAR_NAME = "ustar";
        private static final String OLDGNU_NAME = "oldgnu";
        public static final Format USTAR = new Format("ustar");
        public static final Format OLDGNU = new Format("oldgnu");

        public Format(String v) {
            this.setValue(v);
        }

        public Format() {
            this.setValue(USTAR_NAME);
        }

        public String[] getValues() {
            return new String[]{USTAR_NAME, OLDGNU_NAME};
        }

        public boolean equals(Object other) {
            return other instanceof Format && ((Format)((Object)other)).getValue().equals(this.getValue());
        }
    }
}

