/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.taskdefs;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ant.compress.util.CompressorStreamFactory;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Unpack;
import org.apache.tools.ant.util.FileUtils;

public abstract class UnpackBase
extends Unpack {
    private static final int BUFFER_SIZE = 8192;
    private final String defaultExtension;
    private final CompressorStreamFactory factory;

    protected UnpackBase(String defaultExtension, CompressorStreamFactory factory) {
        this.defaultExtension = defaultExtension;
        this.factory = factory;
    }

    protected final String getDefaultExtension() {
        return this.defaultExtension;
    }

    protected void extract() {
        if (this.source.lastModified() > this.dest.lastModified()) {
            this.log("Expanding " + this.source.getAbsolutePath() + " to " + this.dest.getAbsolutePath());
            FileOutputStream out = null;
            CompressorInputStream zIn = null;
            InputStream fis = null;
            try {
                out = new FileOutputStream(this.dest);
                fis = this.srcResource.getInputStream();
                zIn = this.factory.getCompressorStream(new BufferedInputStream(fis));
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = zIn.read(buffer, 0, buffer.length)) != -1);
            }
            catch (IOException ioe) {
                try {
                    String msg = "Problem expanding " + ioe.getMessage();
                    throw new BuildException(msg, (Throwable)ioe, this.getLocation());
                }
                catch (Throwable throwable) {
                    FileUtils.close(fis);
                    FileUtils.close((OutputStream)out);
                    FileUtils.close(zIn);
                    throw throwable;
                }
            }
            FileUtils.close((InputStream)fis);
            FileUtils.close((OutputStream)out);
            FileUtils.close((InputStream)zIn);
        }
    }

    protected final boolean supportsNonFileResources() {
        return true;
    }
}

