/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.taskdefs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.ant.compress.resources.ZipFileSet;
import org.apache.ant.compress.taskdefs.ArchiveBase;
import org.apache.ant.compress.util.ZipStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;

public class Zip
extends ArchiveBase {
    private int level = -1;
    private String comment = "";
    private boolean keepCompression = false;
    private boolean fallBackToUTF8 = false;
    private boolean useLanguageEncodingFlag = true;
    private UnicodeExtraField createUnicodeExtraFields = UnicodeExtraField.NEVER;

    public Zip() {
        this.setFactory(new ZipStreamFactory(){

            public ArchiveOutputStream getArchiveStream(OutputStream stream, String encoding) throws IOException {
                ZipArchiveOutputStream o = (ZipArchiveOutputStream)super.getArchiveStream(stream, encoding);
                o.setLevel(Zip.this.level);
                o.setComment(Zip.this.comment);
                o.setFallbackToUTF8(Zip.this.fallBackToUTF8);
                o.setUseLanguageEncodingFlag(Zip.this.useLanguageEncodingFlag);
                o.setCreateUnicodeExtraFields(Zip.this.createUnicodeExtraFields.getPolicy());
                return o;
            }
        });
        this.setEntryBuilder(new ArchiveBase.EntryBuilder(){

            public ArchiveEntry buildEntry(ArchiveBase.ResourceWithFlags r) {
                boolean isDir = r.getResource().isDirectory();
                ZipArchiveEntry ent = new ZipArchiveEntry(r.getName());
                ent.setTime(Zip.this.round(r.getResource().getLastModified(), 2000L));
                ent.setSize(isDir ? 0L : r.getResource().getSize());
                if (!isDir && r.getCollectionFlags().hasModeBeenSet()) {
                    ent.setUnixMode(r.getCollectionFlags().getMode());
                } else if (isDir && r.getCollectionFlags().hasDirModeBeenSet()) {
                    ent.setUnixMode(r.getCollectionFlags().getDirMode());
                } else if (r.getResourceFlags().hasModeBeenSet()) {
                    ent.setUnixMode(r.getResourceFlags().getMode());
                } else {
                    ent.setUnixMode(isDir ? 16877 : 33188);
                }
                if (r.getResourceFlags().getZipExtraFields() != null) {
                    ent.setExtraFields(r.getResourceFlags().getZipExtraFields());
                }
                if (Zip.this.keepCompression && r.getResourceFlags().hasCompressionMethod()) {
                    ent.setMethod(r.getResourceFlags().getCompressionMethod());
                }
                return ent;
            }
        });
        this.setFileSetBuilder(new ArchiveBase.FileSetBuilder(){

            public ArchiveFileSet buildFileSet(Resource dest) {
                ZipFileSet afs = new ZipFileSet();
                afs.setSrcResource(dest);
                return afs;
            }
        });
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setKeepCompression(boolean keep) {
        this.keepCompression = keep;
    }

    public void setFallBackToUTF8(boolean b) {
        this.fallBackToUTF8 = b;
    }

    public void setUseLanguageEncodingFlag(boolean b) {
        this.useLanguageEncodingFlag = b;
    }

    public void setCreateUnicodeExtraFields(UnicodeExtraField b) {
        this.createUnicodeExtraFields = b;
    }

    public static final class UnicodeExtraField
    extends EnumeratedAttribute {
        private static final Map POLICIES = new HashMap();
        private static final String NEVER_KEY = "never";
        private static final String ALWAYS_KEY = "always";
        private static final String N_E_KEY = "not-encodeable";
        public static final UnicodeExtraField NEVER;

        public String[] getValues() {
            return new String[]{NEVER_KEY, ALWAYS_KEY, N_E_KEY};
        }

        private UnicodeExtraField(String name) {
            this.setValue(name);
        }

        public UnicodeExtraField() {
        }

        public ZipArchiveOutputStream.UnicodeExtraFieldPolicy getPolicy() {
            return (ZipArchiveOutputStream.UnicodeExtraFieldPolicy)POLICIES.get(this.getValue());
        }

        static {
            POLICIES.put(NEVER_KEY, ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NEVER);
            POLICIES.put(ALWAYS_KEY, ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
            POLICIES.put(N_E_KEY, ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
            NEVER = new UnicodeExtraField(NEVER_KEY);
        }
    }
}

