/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.taskdefs;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.ant.compress.resources.ArFileSet;
import org.apache.ant.compress.taskdefs.ArchiveBase;
import org.apache.ant.compress.util.ArStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;

public class Ar
extends ArchiveBase {
    private static final String NO_DIRS_MESSAGE = "ar archives cannot store directory entries";
    private Format format = Format.AR;

    public Ar() {
        this.setFactory(new ArStreamFactory(){

            public ArchiveOutputStream getArchiveStream(OutputStream stream, String encoding) throws IOException {
                ArArchiveOutputStream o = (ArArchiveOutputStream)super.getArchiveStream(stream, encoding);
                if (Ar.this.format.equals((Object)Format.BSD)) {
                    o.setLongFileMode(1);
                }
                return o;
            }
        });
        this.setEntryBuilder(new ArchiveBase.EntryBuilder(){

            public ArchiveEntry buildEntry(ArchiveBase.ResourceWithFlags r) {
                boolean isDir = r.getResource().isDirectory();
                if (isDir) {
                    throw new BuildException(Ar.NO_DIRS_MESSAGE);
                }
                int mode = 33188;
                if (r.getCollectionFlags().hasModeBeenSet()) {
                    mode = r.getCollectionFlags().getMode();
                } else if (r.getResourceFlags().hasModeBeenSet()) {
                    mode = r.getResourceFlags().getMode();
                }
                int uid = 0;
                if (r.getResourceFlags().hasUserIdBeenSet()) {
                    uid = r.getResourceFlags().getUserId();
                } else if (r.getCollectionFlags().hasUserIdBeenSet()) {
                    uid = r.getCollectionFlags().getUserId();
                }
                int gid = 0;
                if (r.getResourceFlags().hasGroupIdBeenSet()) {
                    gid = r.getResourceFlags().getGroupId();
                } else if (r.getCollectionFlags().hasGroupIdBeenSet()) {
                    gid = r.getCollectionFlags().getGroupId();
                }
                return new ArArchiveEntry(r.getName(), r.getResource().getSize(), uid, gid, mode, Ar.this.round(r.getResource().getLastModified(), 1000L) / 1000L);
            }
        });
        this.setFileSetBuilder(new ArchiveBase.FileSetBuilder(){

            public ArchiveFileSet buildFileSet(Resource dest) {
                ArFileSet afs = new ArFileSet();
                afs.setSrcResource(dest);
                return afs;
            }
        });
    }

    public void setFilesOnly(boolean b) {
        if (!b) {
            throw new BuildException(NO_DIRS_MESSAGE);
        }
    }

    public void setFormat(Format f) {
        this.format = f;
    }

    public static final class Format
    extends EnumeratedAttribute {
        private static final String AR_NAME = "ar";
        private static final String BSD_NAME = "bsd";
        public static final Format AR = new Format("ar");
        public static final Format BSD = new Format("bsd");

        public Format(String v) {
            this.setValue(v);
        }

        public Format() {
            this.setValue(AR_NAME);
        }

        public String[] getValues() {
            return new String[]{AR_NAME, BSD_NAME};
        }

        public boolean equals(Object other) {
            return other instanceof Format && ((Format)((Object)other)).getValue().equals(this.getValue());
        }
    }
}

