/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Attachment;
import org.apache.camel.BytesSource;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.StringSource;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.AttachmentConverter;
import org.apache.camel.converter.CamelConverter;
import org.apache.camel.converter.CollectionConverter;
import org.apache.camel.converter.DateTimeConverter;
import org.apache.camel.converter.DurationConverter;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.NIOConverter;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.converter.SQLConverter;
import org.apache.camel.converter.TimePatternConverter;
import org.apache.camel.converter.jaxp.DomConverter;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.converter.jaxp.StreamSourceConverter;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.converter.UriTypeConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CoreStaticTypeConverterLoader
implements TypeConverterLoader {
    public static final CoreStaticTypeConverterLoader INSTANCE = new CoreStaticTypeConverterLoader();
    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap(183);
    private volatile XmlConverter xmlConverter;
    private volatile DomConverter domConverter;
    private volatile StaxConverter staxConverter;

    private CoreStaticTypeConverterLoader() {
    }

    private void registerConverters() {
        this.converters.put(Boolean.TYPE, Object.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toBool(value);
            }
        });
        this.converters.put(byte[].class, BufferedReader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toByteArray((BufferedReader)value, exchange);
            }
        });
        this.converters.put(byte[].class, ByteArrayOutputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toByteArray((ByteArrayOutputStream)value);
            }
        });
        this.converters.put(byte[].class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toByteArray((File)value);
            }
        });
        this.converters.put(byte[].class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toBytes((InputStream)value);
            }
        });
        this.converters.put(byte[].class, Reader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toByteArray((Reader)value, exchange);
            }
        });
        this.converters.put(byte[].class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toByteArray((String)value, exchange);
            }
        });
        this.converters.put(byte[].class, ByteBuffer.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteArray((ByteBuffer)value);
            }
        });
        this.converters.put(byte[].class, Source.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toByteArray((Source)value, exchange);
            }
        });
        this.converters.put(byte[].class, NodeList.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getDomConverter().toByteArray((NodeList)value, exchange);
            }
        });
        this.converters.put(Character.TYPE, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return Character.valueOf(ObjectConverter.toChar((String)value));
            }
        });
        this.converters.put(char[].class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toCharArray((String)value);
            }
        });
        this.converters.put(BufferedReader.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toReader((File)value, exchange);
            }
        });
        this.converters.put(BufferedWriter.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toWriter((File)value, exchange);
            }
        });
        this.converters.put(File.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toFile((String)value);
            }
        });
        this.converters.put(InputStream.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((byte[])value);
            }
        });
        this.converters.put(InputStream.class, BufferedReader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((BufferedReader)value, exchange);
            }
        });
        this.converters.put(InputStream.class, ByteArrayOutputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((ByteArrayOutputStream)value);
            }
        });
        this.converters.put(InputStream.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((File)value);
            }
        });
        this.converters.put(InputStream.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((String)value, exchange);
            }
        });
        this.converters.put(InputStream.class, StringBuffer.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((StringBuffer)value, exchange);
            }
        });
        this.converters.put(InputStream.class, StringBuilder.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((StringBuilder)value, exchange);
            }
        });
        this.converters.put(InputStream.class, URL.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((URL)value);
            }
        });
        this.converters.put(InputStream.class, ByteBuffer.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toInputStream((ByteBuffer)value);
            }
        });
        this.converters.put(InputStream.class, XMLStreamReader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createInputStream((XMLStreamReader)value, exchange);
            }
        });
        this.converters.put(InputStream.class, DOMSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toInputStream((DOMSource)value, exchange);
            }
        });
        this.converters.put(InputStream.class, StreamSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamSourceConverter.toInputStream((StreamSource)value);
            }
        });
        this.converters.put(InputStream.class, Document.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toInputStream((Document)value, exchange);
            }
        });
        this.converters.put(InputStream.class, NodeList.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getDomConverter().toInputStream((NodeList)value, exchange);
            }
        });
        this.converters.put(ObjectInput.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toObjectInput((InputStream)value, exchange);
            }
        });
        this.converters.put(ObjectOutput.class, OutputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toObjectOutput((OutputStream)value);
            }
        });
        this.converters.put(OutputStream.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toOutputStream((File)value);
            }
        });
        this.converters.put(Reader.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toReader((byte[])value, exchange);
            }
        });
        this.converters.put(Reader.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toReader((InputStream)value, exchange);
            }
        });
        this.converters.put(Reader.class, XMLStreamReader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createReader((XMLStreamReader)value, exchange);
            }
        });
        this.converters.put(Reader.class, StreamSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamSourceConverter.toReader((StreamSource)value);
            }
        });
        this.converters.put(Reader.class, Source.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toReaderFromSource((Source)value, exchange);
            }
        });
        this.converters.put(StringReader.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toReader((String)value);
            }
        });
        this.converters.put(Writer.class, OutputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toWriter((OutputStream)value, exchange);
            }
        });
        this.converters.put(Boolean.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toBoolean((String)value);
            }
        });
        this.converters.put(Boolean.class, NodeList.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toBoolean((NodeList)value);
            }
        });
        this.converters.put(Boolean.class, Object.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toBoolean(value);
            }
        });
        this.converters.put(Byte.class, Number.class, (Object)new BaseTypeConverter(true){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toByte((Number)value);
            }
        });
        this.converters.put(Byte.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toByte((String)value);
            }
        });
        this.converters.put(CharSequence.class, URI.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return UriTypeConverter.toCharSequence((URI)value);
            }
        });
        this.converters.put(Character.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toCharacter((String)value);
            }
        });
        this.converters.put(Class.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toClass((String)value, exchange);
            }
        });
        this.converters.put(Double.class, Number.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toDouble((Number)value);
            }
        });
        this.converters.put(Double.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toDouble((String)value);
            }
        });
        this.converters.put(Float.class, Number.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toFloat((Number)value);
            }
        });
        this.converters.put(Float.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toFloat((String)value);
            }
        });
        this.converters.put(Integer.class, Number.class, (Object)new BaseTypeConverter(true){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toInteger((Number)value);
            }
        });
        this.converters.put(Integer.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toInteger((String)value);
            }
        });
        this.converters.put(Integer.class, NodeList.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DomConverter.toInteger((NodeList)value);
            }
        });
        this.converters.put(Iterable.class, Object.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.iterable(value);
            }
        });
        this.converters.put(Long.class, Number.class, (Object)new BaseTypeConverter(true){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toLong((Number)value);
            }
        });
        this.converters.put(Long.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toLong((String)value);
            }
        });
        this.converters.put(Long.class, Timestamp.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return SQLConverter.toLong((Timestamp)value);
            }
        });
        this.converters.put(Long.class, Date.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DateTimeConverter.toLong((Date)value);
            }
        });
        this.converters.put(Long.class, NodeList.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DomConverter.toLong((NodeList)value);
            }
        });
        this.converters.put(Object[].class, Collection.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toArray((Collection)value);
            }
        });
        this.converters.put(Short.class, Number.class, (Object)new BaseTypeConverter(true){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toShort((Number)value);
            }
        });
        this.converters.put(Short.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toShort((String)value);
            }
        });
        this.converters.put(String.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((byte[])value, exchange);
            }
        });
        this.converters.put(String.class, char[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.fromCharArray((char[])value);
            }
        });
        this.converters.put(String.class, BufferedReader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((BufferedReader)value);
            }
        });
        this.converters.put(String.class, ByteArrayOutputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((ByteArrayOutputStream)value, exchange);
            }
        });
        this.converters.put(String.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((File)value, exchange);
            }
        });
        this.converters.put(String.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((InputStream)value, exchange);
            }
        });
        this.converters.put(String.class, Reader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((Reader)value);
            }
        });
        this.converters.put(String.class, Boolean.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toString((Boolean)value);
            }
        });
        this.converters.put(String.class, Integer.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toString((Integer)value);
            }
        });
        this.converters.put(String.class, Long.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toString((Long)value);
            }
        });
        this.converters.put(String.class, StringBuffer.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toString((StringBuffer)value);
            }
        });
        this.converters.put(String.class, StringBuilder.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toString((StringBuilder)value);
            }
        });
        this.converters.put(String.class, URL.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((URL)value, exchange);
            }
        });
        this.converters.put(String.class, ByteBuffer.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toString((ByteBuffer)value, exchange);
            }
        });
        this.converters.put(String.class, Duration.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DurationConverter.toString((Duration)value);
            }
        });
        this.converters.put(String.class, Source.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toString((Source)value, exchange);
            }
        });
        this.converters.put(String.class, Node.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toString((Node)value, exchange);
            }
        });
        this.converters.put(String.class, NodeList.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getDomConverter().toString((NodeList)value, exchange);
            }
        });
        this.converters.put(BigInteger.class, Object.class, (Object)new BaseTypeConverter(true){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toBigInteger(value);
            }
        });
        this.converters.put(URI.class, CharSequence.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return UriTypeConverter.toUri((CharSequence)value);
            }
        });
        this.converters.put(ByteBuffer.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((byte[])value);
            }
        });
        this.converters.put(ByteBuffer.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((File)value);
            }
        });
        this.converters.put(ByteBuffer.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.covertToByteBuffer((InputStream)value);
            }
        });
        this.converters.put(ByteBuffer.class, Double.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((Double)value);
            }
        });
        this.converters.put(ByteBuffer.class, Float.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((Float)value);
            }
        });
        this.converters.put(ByteBuffer.class, Integer.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((Integer)value);
            }
        });
        this.converters.put(ByteBuffer.class, Long.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((Long)value);
            }
        });
        this.converters.put(ByteBuffer.class, Short.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((Short)value);
            }
        });
        this.converters.put(ByteBuffer.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((String)value, exchange);
            }
        });
        this.converters.put(Timestamp.class, Long.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return SQLConverter.toTimestamp((Long)value);
            }
        });
        this.converters.put(Duration.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DurationConverter.toDuration((String)value);
            }
        });
        this.converters.put(ArrayList.class, Iterator.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toArrayList((Iterator)value);
            }
        });
        this.converters.put(Date.class, Long.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DateTimeConverter.toDate((Long)value);
            }
        });
        this.converters.put(HashMap.class, Map.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toHashMap((Map)value);
            }
        });
        this.converters.put(Hashtable.class, Map.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toHashtable((Map)value);
            }
        });
        this.converters.put(Iterator.class, Object.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.iterator(value);
            }
        });
        this.converters.put(List.class, Iterable.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toList((Iterable)value);
            }
        });
        this.converters.put(List.class, Object[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toList((Object[])value);
            }
        });
        this.converters.put(List.class, Collection.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toList((Collection)value);
            }
        });
        this.converters.put(List.class, NodeList.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DomConverter.toList((NodeList)value);
            }
        });
        this.converters.put(Properties.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toProperties((File)value);
            }
        });
        this.converters.put(Properties.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toProperties((InputStream)value);
            }
        });
        this.converters.put(Properties.class, Reader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toProperties((Reader)value);
            }
        });
        this.converters.put(Properties.class, Map.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toProperties((Map)value);
            }
        });
        this.converters.put(Set.class, Object[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toSet((Object[])value);
            }
        });
        this.converters.put(Set.class, Collection.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toSet((Collection)value);
            }
        });
        this.converters.put(Set.class, Map.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toSet((Map)value);
            }
        });
        this.converters.put(TimeZone.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DateTimeConverter.toTimeZone((String)value);
            }
        });
        this.converters.put(DataHandler.class, Attachment.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return AttachmentConverter.toDataHandler((Attachment)value);
            }
        });
        this.converters.put(XMLEventReader.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventReader((File)value, exchange);
            }
        });
        this.converters.put(XMLEventReader.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventReader((InputStream)value, exchange);
            }
        });
        this.converters.put(XMLEventReader.class, Reader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventReader((Reader)value);
            }
        });
        this.converters.put(XMLEventReader.class, XMLStreamReader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventReader((XMLStreamReader)value);
            }
        });
        this.converters.put(XMLEventReader.class, Source.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventReader((Source)value);
            }
        });
        this.converters.put(XMLEventWriter.class, OutputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventWriter((OutputStream)value, exchange);
            }
        });
        this.converters.put(XMLEventWriter.class, Writer.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventWriter((Writer)value);
            }
        });
        this.converters.put(XMLEventWriter.class, Result.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventWriter((Result)value);
            }
        });
        this.converters.put(XMLStreamReader.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamReader((File)value, exchange);
            }
        });
        this.converters.put(XMLStreamReader.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamReader((InputStream)value, exchange);
            }
        });
        this.converters.put(XMLStreamReader.class, Reader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamReader((Reader)value);
            }
        });
        this.converters.put(XMLStreamReader.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamReader((String)value);
            }
        });
        this.converters.put(XMLStreamReader.class, Source.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamReader((Source)value);
            }
        });
        this.converters.put(XMLStreamWriter.class, OutputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamWriter((OutputStream)value, exchange);
            }
        });
        this.converters.put(XMLStreamWriter.class, Writer.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamWriter((Writer)value);
            }
        });
        this.converters.put(XMLStreamWriter.class, Result.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamWriter((Result)value);
            }
        });
        this.converters.put(Source.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSource((String)value);
            }
        });
        this.converters.put(DOMSource.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((byte[])value);
            }
        });
        this.converters.put(DOMSource.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((File)value, exchange);
            }
        });
        this.converters.put(DOMSource.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((InputStream)value, exchange);
            }
        });
        this.converters.put(DOMSource.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((String)value);
            }
        });
        this.converters.put(DOMSource.class, SAXSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSourceFromSAX((SAXSource)value);
            }
        });
        this.converters.put(DOMSource.class, StAXSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSourceFromStAX((StAXSource)value);
            }
        });
        this.converters.put(DOMSource.class, StreamSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSourceFromStream((StreamSource)value, exchange);
            }
        });
        this.converters.put(DOMSource.class, Source.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((Source)value, exchange);
            }
        });
        this.converters.put(DOMSource.class, Document.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((Document)value);
            }
        });
        this.converters.put(DOMSource.class, Node.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((Node)value);
            }
        });
        this.converters.put(SAXSource.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSource((byte[])value, exchange);
            }
        });
        this.converters.put(SAXSource.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSource((File)value, exchange);
            }
        });
        this.converters.put(SAXSource.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSource((InputStream)value, exchange);
            }
        });
        this.converters.put(SAXSource.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSource((String)value, exchange);
            }
        });
        this.converters.put(SAXSource.class, DOMSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSourceFromDOM((DOMSource)value, exchange);
            }
        });
        this.converters.put(SAXSource.class, StAXSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSourceFromStAX((StAXSource)value, exchange);
            }
        });
        this.converters.put(SAXSource.class, StreamSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSourceFromStream((StreamSource)value, exchange);
            }
        });
        this.converters.put(SAXSource.class, Source.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSource((Source)value, exchange);
            }
        });
        this.converters.put(StAXSource.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStAXSource((byte[])value, exchange);
            }
        });
        this.converters.put(StAXSource.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStAXSource((File)value, exchange);
            }
        });
        this.converters.put(StAXSource.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStAXSource((InputStream)value, exchange);
            }
        });
        this.converters.put(StAXSource.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStAXSource((String)value, exchange);
            }
        });
        this.converters.put(StreamSource.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSource((byte[])value, exchange);
            }
        });
        this.converters.put(StreamSource.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSource((File)value);
            }
        });
        this.converters.put(StreamSource.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSource((InputStream)value);
            }
        });
        this.converters.put(StreamSource.class, Reader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSource((Reader)value);
            }
        });
        this.converters.put(StreamSource.class, ByteBuffer.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSource((ByteBuffer)value, exchange);
            }
        });
        this.converters.put(StreamSource.class, DOMSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSourceFromDOM((DOMSource)value, exchange);
            }
        });
        this.converters.put(StreamSource.class, SAXSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSourceFromSAX((SAXSource)value, exchange);
            }
        });
        this.converters.put(StreamSource.class, StAXSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSourceFromStAX((StAXSource)value, exchange);
            }
        });
        this.converters.put(StreamSource.class, Source.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSource((Source)value, exchange);
            }
        });
        this.converters.put(Long.TYPE, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return TimePatternConverter.toMilliSeconds((String)value);
            }
        });
        this.converters.put(Long.TYPE, Duration.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DurationConverter.toMilliSeconds((Duration)value);
            }
        });
        this.converters.put(BytesSource.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toBytesSource((byte[])value);
            }
        });
        this.converters.put(Processor.class, Expression.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CamelConverter.toProcessor((Expression)value);
            }
        });
        this.converters.put(Processor.class, Predicate.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CamelConverter.toProcessor((Predicate)value);
            }
        });
        this.converters.put(StringSource.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStringSource((String)value);
            }
        });
        this.converters.put(Document.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((byte[])value, exchange);
            }
        });
        this.converters.put(Document.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((File)value, exchange);
            }
        });
        this.converters.put(Document.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((InputStream)value, exchange);
            }
        });
        this.converters.put(Document.class, Reader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((Reader)value, exchange);
            }
        });
        this.converters.put(Document.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((String)value, exchange);
            }
        });
        this.converters.put(Document.class, Source.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((Source)value);
            }
        });
        this.converters.put(Document.class, Node.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((Node)value);
            }
        });
        this.converters.put(Document.class, NodeList.class, (Object)new BaseTypeConverter(true){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocumentFromSingleNodeList((NodeList)value);
            }
        });
        this.converters.put(Document.class, InputSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((InputSource)value, exchange);
            }
        });
        this.converters.put(Element.class, Source.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMElement((Source)value);
            }
        });
        this.converters.put(Element.class, Node.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMElement((Node)value);
            }
        });
        this.converters.put(Node.class, SAXSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMNodeFromSAX((SAXSource)value);
            }
        });
        this.converters.put(Node.class, StAXSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMNodeFromStAX((StAXSource)value);
            }
        });
        this.converters.put(Node.class, Source.class, (Object)new BaseTypeConverter(true){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMNode((Source)value);
            }
        });
        this.converters.put(Node.class, NodeList.class, (Object)new BaseTypeConverter(true){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMNodeFromSingleNodeList((NodeList)value);
            }
        });
        this.converters.put(InputSource.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toInputSource((File)value, exchange);
            }
        });
        this.converters.put(InputSource.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toInputSource((InputStream)value, exchange);
            }
        });
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters();
        this.converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, (TypeConverter)c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlConverter getXmlConverter() {
        if (this.xmlConverter == null) {
            CoreStaticTypeConverterLoader coreStaticTypeConverterLoader = this;
            synchronized (coreStaticTypeConverterLoader) {
                if (this.xmlConverter == null) {
                    this.xmlConverter = new XmlConverter();
                }
            }
        }
        return this.xmlConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomConverter getDomConverter() {
        if (this.domConverter == null) {
            CoreStaticTypeConverterLoader coreStaticTypeConverterLoader = this;
            synchronized (coreStaticTypeConverterLoader) {
                if (this.domConverter == null) {
                    this.domConverter = new DomConverter();
                }
            }
        }
        return this.domConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StaxConverter getStaxConverter() {
        if (this.staxConverter == null) {
            CoreStaticTypeConverterLoader coreStaticTypeConverterLoader = this;
            synchronized (coreStaticTypeConverterLoader) {
                if (this.staxConverter == null) {
                    this.staxConverter = new StaxConverter();
                }
            }
        }
        return this.staxConverter;
    }

    static abstract class BaseTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        public boolean allowNull() {
            return this.allowNull;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

