package org.apache.camel.converter;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

@SuppressWarnings("unchecked")
public class NIOConverterLoader implements TypeConverterLoader {

    public NIOConverterLoader() {
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        addTypeConverter(registry, byte[].class, java.nio.ByteBuffer.class, false,
            (type, exchange, value) -> org.apache.camel.converter.NIOConverter.toByteArray((java.nio.ByteBuffer) value));
        addTypeConverter(registry, java.io.InputStream.class, java.nio.ByteBuffer.class, false,
            (type, exchange, value) -> org.apache.camel.converter.NIOConverter.toInputStream((java.nio.ByteBuffer) value));
        addTypeConverter(registry, java.lang.String.class, java.nio.ByteBuffer.class, false,
            (type, exchange, value) -> org.apache.camel.converter.NIOConverter.toString((java.nio.ByteBuffer) value, exchange));
        addTypeConverter(registry, java.nio.ByteBuffer.class, byte[].class, false,
            (type, exchange, value) -> org.apache.camel.converter.NIOConverter.toByteBuffer((byte[]) value));
        addTypeConverter(registry, java.nio.ByteBuffer.class, java.io.File.class, false,
            (type, exchange, value) -> org.apache.camel.converter.NIOConverter.toByteBuffer((java.io.File) value));
        addTypeConverter(registry, java.nio.ByteBuffer.class, java.lang.Double.class, false,
            (type, exchange, value) -> org.apache.camel.converter.NIOConverter.toByteBuffer((java.lang.Double) value));
        addTypeConverter(registry, java.nio.ByteBuffer.class, java.lang.Float.class, false,
            (type, exchange, value) -> org.apache.camel.converter.NIOConverter.toByteBuffer((java.lang.Float) value));
        addTypeConverter(registry, java.nio.ByteBuffer.class, java.lang.Integer.class, false,
            (type, exchange, value) -> org.apache.camel.converter.NIOConverter.toByteBuffer((java.lang.Integer) value));
        addTypeConverter(registry, java.nio.ByteBuffer.class, java.lang.Long.class, false,
            (type, exchange, value) -> org.apache.camel.converter.NIOConverter.toByteBuffer((java.lang.Long) value));
        addTypeConverter(registry, java.nio.ByteBuffer.class, java.lang.Short.class, false,
            (type, exchange, value) -> org.apache.camel.converter.NIOConverter.toByteBuffer((java.lang.Short) value));
        addTypeConverter(registry, java.nio.ByteBuffer.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.converter.NIOConverter.toByteBuffer((java.lang.String) value, exchange));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) { 
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }

}
