package org.apache.camel.converter;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

@SuppressWarnings("unchecked")
public class ObjectConverterLoader implements TypeConverterLoader {

    public ObjectConverterLoader() {
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        addTypeConverter(registry, boolean.class, java.lang.Object.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toBool(value));
        addTypeConverter(registry, char.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toChar((java.lang.String) value));
        addTypeConverter(registry, char[].class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toCharArray((java.lang.String) value));
        addTypeConverter(registry, java.lang.Boolean.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toBoolean((java.lang.String) value));
        addTypeConverter(registry, java.lang.Boolean.class, java.lang.Object.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toBoolean(value));
        addTypeConverter(registry, java.lang.Byte.class, java.lang.Number.class, true,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toByte((java.lang.Number) value));
        addTypeConverter(registry, java.lang.Byte.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toByte((java.lang.String) value));
        addTypeConverter(registry, java.lang.Character.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toCharacter((java.lang.String) value));
        addTypeConverter(registry, java.lang.Class.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toClass((java.lang.String) value, exchange));
        addTypeConverter(registry, java.lang.Double.class, java.lang.Number.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toDouble((java.lang.Number) value));
        addTypeConverter(registry, java.lang.Double.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toDouble((java.lang.String) value));
        addTypeConverter(registry, java.lang.Float.class, java.lang.Number.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toFloat((java.lang.Number) value));
        addTypeConverter(registry, java.lang.Float.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toFloat((java.lang.String) value));
        addTypeConverter(registry, java.lang.Integer.class, java.lang.Number.class, true,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toInteger((java.lang.Number) value));
        addTypeConverter(registry, java.lang.Integer.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toInteger((java.lang.String) value));
        addTypeConverter(registry, java.lang.Iterable.class, java.lang.Object.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.iterable(value));
        addTypeConverter(registry, java.lang.Long.class, java.lang.Number.class, true,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toLong((java.lang.Number) value));
        addTypeConverter(registry, java.lang.Long.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toLong((java.lang.String) value));
        addTypeConverter(registry, java.lang.Short.class, java.lang.Number.class, true,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toShort((java.lang.Number) value));
        addTypeConverter(registry, java.lang.Short.class, java.lang.String.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toShort((java.lang.String) value));
        addTypeConverter(registry, java.lang.String.class, char[].class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.fromCharArray((char[]) value));
        addTypeConverter(registry, java.lang.String.class, java.lang.Boolean.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toString((java.lang.Boolean) value));
        addTypeConverter(registry, java.lang.String.class, java.lang.Integer.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toString((java.lang.Integer) value));
        addTypeConverter(registry, java.lang.String.class, java.lang.Long.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toString((java.lang.Long) value));
        addTypeConverter(registry, java.lang.String.class, java.lang.StringBuffer.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toString((java.lang.StringBuffer) value));
        addTypeConverter(registry, java.lang.String.class, java.lang.StringBuilder.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toString((java.lang.StringBuilder) value));
        addTypeConverter(registry, java.math.BigInteger.class, java.lang.Object.class, true,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.toBigInteger(value));
        addTypeConverter(registry, java.util.Iterator.class, java.lang.Object.class, false,
            (type, exchange, value) -> org.apache.camel.converter.ObjectConverter.iterator(value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) { 
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }

}
