/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public class IOConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, byte[].class, BufferedReader.class, false, (type, exchange, value) -> IOConverter.toByteArray((BufferedReader)value, exchange));
        this.addTypeConverter(registry, byte[].class, ByteArrayOutputStream.class, false, (type, exchange, value) -> IOConverter.toByteArray((ByteArrayOutputStream)value));
        this.addTypeConverter(registry, byte[].class, File.class, false, (type, exchange, value) -> IOConverter.toByteArray((File)value));
        this.addTypeConverter(registry, byte[].class, InputStream.class, false, (type, exchange, value) -> IOConverter.toBytes((InputStream)value));
        this.addTypeConverter(registry, byte[].class, Reader.class, false, (type, exchange, value) -> IOConverter.toByteArray((Reader)value, exchange));
        this.addTypeConverter(registry, byte[].class, String.class, false, (type, exchange, value) -> IOConverter.toByteArray((String)value, exchange));
        this.addTypeConverter(registry, BufferedReader.class, File.class, false, (type, exchange, value) -> IOConverter.toReader((File)value, exchange));
        this.addTypeConverter(registry, BufferedWriter.class, File.class, false, (type, exchange, value) -> IOConverter.toWriter((File)value, exchange));
        this.addTypeConverter(registry, File.class, String.class, false, (type, exchange, value) -> IOConverter.toFile((String)value));
        this.addTypeConverter(registry, InputStream.class, byte[].class, false, (type, exchange, value) -> IOConverter.toInputStream((byte[])value));
        this.addTypeConverter(registry, InputStream.class, BufferedReader.class, false, (type, exchange, value) -> IOConverter.toInputStream((BufferedReader)value, exchange));
        this.addTypeConverter(registry, InputStream.class, ByteArrayOutputStream.class, false, (type, exchange, value) -> IOConverter.toInputStream((ByteArrayOutputStream)value));
        this.addTypeConverter(registry, InputStream.class, File.class, false, (type, exchange, value) -> IOConverter.toInputStream((File)value));
        this.addTypeConverter(registry, InputStream.class, String.class, false, (type, exchange, value) -> IOConverter.toInputStream((String)value, exchange));
        this.addTypeConverter(registry, InputStream.class, StringBuffer.class, false, (type, exchange, value) -> IOConverter.toInputStream((StringBuffer)value, exchange));
        this.addTypeConverter(registry, InputStream.class, StringBuilder.class, false, (type, exchange, value) -> IOConverter.toInputStream((StringBuilder)value, exchange));
        this.addTypeConverter(registry, InputStream.class, URL.class, false, (type, exchange, value) -> IOConverter.toInputStream((URL)value));
        this.addTypeConverter(registry, ObjectInput.class, InputStream.class, false, (type, exchange, value) -> IOConverter.toObjectInput((InputStream)value, exchange));
        this.addTypeConverter(registry, ObjectOutput.class, OutputStream.class, false, (type, exchange, value) -> IOConverter.toObjectOutput((OutputStream)value));
        this.addTypeConverter(registry, OutputStream.class, File.class, false, (type, exchange, value) -> IOConverter.toOutputStream((File)value));
        this.addTypeConverter(registry, Reader.class, byte[].class, false, (type, exchange, value) -> IOConverter.toReader((byte[])value, exchange));
        this.addTypeConverter(registry, Reader.class, InputStream.class, false, (type, exchange, value) -> IOConverter.toReader((InputStream)value, exchange));
        this.addTypeConverter(registry, StringReader.class, String.class, false, (type, exchange, value) -> IOConverter.toReader((String)value));
        this.addTypeConverter(registry, Writer.class, OutputStream.class, false, (type, exchange, value) -> IOConverter.toWriter((OutputStream)value, exchange));
        this.addTypeConverter(registry, String.class, byte[].class, false, (type, exchange, value) -> IOConverter.toString((byte[])value, exchange));
        this.addTypeConverter(registry, String.class, BufferedReader.class, false, (type, exchange, value) -> IOConverter.toString((BufferedReader)value));
        this.addTypeConverter(registry, String.class, ByteArrayOutputStream.class, false, (type, exchange, value) -> IOConverter.toString((ByteArrayOutputStream)value, exchange));
        this.addTypeConverter(registry, String.class, File.class, false, (type, exchange, value) -> IOConverter.toString((File)value, exchange));
        this.addTypeConverter(registry, String.class, InputStream.class, false, (type, exchange, value) -> IOConverter.toString((InputStream)value, exchange));
        this.addTypeConverter(registry, String.class, Reader.class, false, (type, exchange, value) -> IOConverter.toString((Reader)value));
        this.addTypeConverter(registry, String.class, URL.class, false, (type, exchange, value) -> IOConverter.toString((URL)value, exchange));
        this.addTypeConverter(registry, ByteBuffer.class, InputStream.class, false, (type, exchange, value) -> IOConverter.covertToByteBuffer((InputStream)value));
        this.addTypeConverter(registry, Properties.class, File.class, false, (type, exchange, value) -> IOConverter.toProperties((File)value));
        this.addTypeConverter(registry, Properties.class, InputStream.class, false, (type, exchange, value) -> IOConverter.toProperties((InputStream)value));
        this.addTypeConverter(registry, Properties.class, Reader.class, false, (type, exchange, value) -> IOConverter.toProperties((Reader)value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

