/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.engine.BaseRouteService;
import org.apache.camel.spi.RouteStartupOrder;

public class DefaultRouteStartupOrder
implements RouteStartupOrder {
    private final int startupOrder;
    private final Route route;
    private final BaseRouteService routeService;

    public DefaultRouteStartupOrder(int startupOrder, Route route, BaseRouteService routeService) {
        this.startupOrder = startupOrder;
        this.route = route;
        this.routeService = routeService;
    }

    public int getStartupOrder() {
        return this.startupOrder;
    }

    public Route getRoute() {
        return this.route;
    }

    public List<Consumer> getInputs() {
        Map<Route, Consumer> inputs = this.routeService.getInputs();
        return new ArrayList<Consumer>(inputs.values());
    }

    public List<Service> getServices() {
        List services = this.routeService.getRoute().getServices();
        return new ArrayList<Service>(services);
    }

    public BaseRouteService getRouteService() {
        return this.routeService;
    }

    public String toString() {
        return "Route " + this.route.getId() + " starts in order " + this.startupOrder;
    }
}

