/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Arrays;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.engine.DefaultInterceptSendToEndpoint;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.service.ServiceHelper;

public class InterceptSendToEndpointProcessor
extends DefaultAsyncProducer {
    private final DefaultInterceptSendToEndpoint endpoint;
    private final Endpoint delegate;
    private final AsyncProducer producer;
    private final boolean skip;

    public InterceptSendToEndpointProcessor(DefaultInterceptSendToEndpoint endpoint, Endpoint delegate, AsyncProducer producer, boolean skip) throws Exception {
        super(delegate);
        this.endpoint = endpoint;
        this.delegate = delegate;
        this.producer = producer;
        this.skip = skip;
    }

    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending to endpoint: {} is intercepted and detoured to: {} for exchange: {}", new Object[]{this.getEndpoint(), this.endpoint.getDetour(), exchange});
        }
        exchange.getIn().setHeader("CamelInterceptedEndpoint", (Object)this.delegate.getEndpointUri());
        if (this.endpoint.getDetour() != null) {
            AsyncProcessor detour = AsyncProcessorConverterHelper.convert((Processor)this.endpoint.getDetour());
            AsyncProcessorSupport ascb = new AsyncProcessorSupport(){

                public boolean process(Exchange exchange, AsyncCallback callback) {
                    return InterceptSendToEndpointProcessor.this.callback(exchange, callback, true);
                }
            };
            return new Pipeline(exchange.getContext(), Arrays.asList(detour, ascb)).process(exchange, callback);
        }
        return this.callback(exchange, callback, true);
    }

    private boolean callback(Exchange exchange, AsyncCallback callback, boolean doneSync) {
        if (!PipelineHelper.continueProcessing(exchange, "skip sending to original intended destination: " + this.getEndpoint(), this.log)) {
            callback.done(doneSync);
            return doneSync;
        }
        boolean shouldSkip = this.skip;
        Boolean whenMatches = (Boolean)exchange.removeProperty("CamelInterceptSendToEndpointWhenMatched");
        if (whenMatches != null) {
            boolean bl = shouldSkip = this.skip && whenMatches != false;
        }
        if (!shouldSkip) {
            if (exchange.hasOut()) {
                exchange.setIn(exchange.getOut());
                exchange.setOut(null);
            }
            boolean s = this.producer.process(exchange, ds -> callback.done(doneSync && ds));
            return doneSync && s;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stop() means skip sending exchange to original intended destination: {} for exchange: {}", (Object)this.getEndpoint(), (Object)exchange);
        }
        callback.done(doneSync);
        return doneSync;
    }

    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    public void start() {
        ServiceHelper.startService((Object)this.endpoint.getDetour());
        ServiceHelper.startService((Object)this.producer);
    }

    public void stop() {
        ServiceHelper.stopService((Object)this.producer);
    }
}

