/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.engine.DefaultUnitOfWork;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCUnitOfWork
extends DefaultUnitOfWork {
    private static final Logger LOG = LoggerFactory.getLogger(MDCUnitOfWork.class);
    private final String originalBreadcrumbId;
    private final String originalExchangeId = MDC.get((String)"camel.exchangeId");
    private final String originalMessageId = MDC.get((String)"camel.messageId");
    private final String originalCorrelationId;
    private final String originalRouteId;
    private final String originalStepId;
    private final String originalCamelContextId;
    private final String originalTransactionKey;

    public MDCUnitOfWork(Exchange exchange) {
        super(exchange, LOG);
        String breadcrumbId;
        this.originalBreadcrumbId = MDC.get((String)"camel.breadcrumbId");
        this.originalCorrelationId = MDC.get((String)"camel.correlationId");
        this.originalRouteId = MDC.get((String)"camel.routeId");
        this.originalStepId = MDC.get((String)"camel.stepId");
        this.originalCamelContextId = MDC.get((String)"camel.contextId");
        this.originalTransactionKey = MDC.get((String)"camel.transactionKey");
        MDC.put((String)"camel.exchangeId", (String)exchange.getExchangeId());
        String msgId = exchange.hasOut() ? exchange.getOut().getMessageId() : exchange.getIn().getMessageId();
        MDC.put((String)"camel.messageId", (String)msgId);
        MDC.put((String)"camel.contextId", (String)exchange.getContext().getName());
        String corrId = (String)exchange.getProperty("CamelCorrelationId", String.class);
        if (corrId != null) {
            MDC.put((String)"camel.correlationId", (String)corrId);
        }
        if ((breadcrumbId = (String)exchange.getIn().getHeader("breadcrumbId", String.class)) != null) {
            MDC.put((String)"camel.breadcrumbId", (String)breadcrumbId);
        }
    }

    @Override
    public UnitOfWork newInstance(Exchange exchange) {
        return new MDCUnitOfWork(exchange);
    }

    @Override
    public void stop() {
        super.stop();
        this.clear();
    }

    @Override
    public void pushRouteContext(RouteContext routeContext) {
        super.pushRouteContext(routeContext);
        MDC.put((String)"camel.routeId", (String)routeContext.getRouteId());
    }

    @Override
    public RouteContext popRouteContext() {
        RouteContext answer = super.popRouteContext();
        RouteContext previous = this.getRouteContext();
        if (previous != null) {
            MDC.put((String)"camel.routeId", (String)previous.getRouteId());
        } else {
            MDC.remove((String)"camel.routeId");
        }
        return answer;
    }

    @Override
    public void beginTransactedBy(Object key) {
        MDC.put((String)"camel.transactionKey", (String)key.toString());
        super.beginTransactedBy(key);
    }

    @Override
    public void endTransactedBy(Object key) {
        MDC.remove((String)"camel.transactionKey");
        super.endTransactedBy(key);
    }

    @Override
    public AsyncCallback beforeProcess(Processor processor, Exchange exchange, AsyncCallback callback) {
        String stepId = (String)exchange.getProperty("CamelStepId", String.class);
        if (stepId != null) {
            MDC.put((String)"camel.stepId", (String)stepId);
        }
        return new MDCCallback(callback);
    }

    @Override
    public void afterProcess(Processor processor, Exchange exchange, AsyncCallback callback, boolean doneSync) {
        String stepId = (String)exchange.getProperty("CamelStepId", String.class);
        if (stepId == null) {
            MDC.remove((String)"camel.stepId");
        }
    }

    public void clear() {
        if (this.originalBreadcrumbId != null) {
            MDC.put((String)"camel.breadcrumbId", (String)this.originalBreadcrumbId);
        } else {
            MDC.remove((String)"camel.breadcrumbId");
        }
        if (this.originalExchangeId != null) {
            MDC.put((String)"camel.exchangeId", (String)this.originalExchangeId);
        } else {
            MDC.remove((String)"camel.exchangeId");
        }
        if (this.originalMessageId != null) {
            MDC.put((String)"camel.messageId", (String)this.originalMessageId);
        } else {
            MDC.remove((String)"camel.messageId");
        }
        if (this.originalCorrelationId != null) {
            MDC.put((String)"camel.correlationId", (String)this.originalCorrelationId);
        } else {
            MDC.remove((String)"camel.correlationId");
        }
        if (this.originalRouteId != null) {
            MDC.put((String)"camel.routeId", (String)this.originalRouteId);
        } else {
            MDC.remove((String)"camel.routeId");
        }
        if (this.originalStepId != null) {
            MDC.put((String)"camel.stepId", (String)this.originalStepId);
        } else {
            MDC.remove((String)"camel.stepId");
        }
        if (this.originalCamelContextId != null) {
            MDC.put((String)"camel.contextId", (String)this.originalCamelContextId);
        } else {
            MDC.remove((String)"camel.contextId");
        }
        if (this.originalTransactionKey != null) {
            MDC.put((String)"camel.transactionKey", (String)this.originalTransactionKey);
        } else {
            MDC.remove((String)"camel.transactionKey");
        }
    }

    @Override
    public String toString() {
        return "MDCUnitOfWork";
    }

    private static final class MDCCallback
    implements AsyncCallback {
        private final AsyncCallback delegate;
        private final String breadcrumbId;
        private final String exchangeId;
        private final String messageId;
        private final String correlationId;
        private final String routeId;
        private final String stepId;
        private final String camelContextId;

        private MDCCallback(AsyncCallback delegate) {
            this.delegate = delegate;
            this.exchangeId = MDC.get((String)"camel.exchangeId");
            this.messageId = MDC.get((String)"camel.messageId");
            this.breadcrumbId = MDC.get((String)"camel.breadcrumbId");
            this.correlationId = MDC.get((String)"camel.correlationId");
            this.camelContextId = MDC.get((String)"camel.contextId");
            this.routeId = MDC.get((String)"camel.routeId");
            this.stepId = MDC.get((String)"camel.stepId");
        }

        public void done(boolean doneSync) {
            try {
                if (!doneSync) {
                    if (this.breadcrumbId != null) {
                        MDC.put((String)"camel.breadcrumbId", (String)this.breadcrumbId);
                    }
                    if (this.exchangeId != null) {
                        MDC.put((String)"camel.exchangeId", (String)this.exchangeId);
                    }
                    if (this.messageId != null) {
                        MDC.put((String)"camel.messageId", (String)this.messageId);
                    }
                    if (this.correlationId != null) {
                        MDC.put((String)"camel.correlationId", (String)this.correlationId);
                    }
                    if (this.camelContextId != null) {
                        MDC.put((String)"camel.contextId", (String)this.camelContextId);
                    }
                }
                if (this.routeId != null) {
                    MDC.put((String)"camel.routeId", (String)this.routeId);
                }
            }
            finally {
                this.delegate.done(doneSync);
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

