/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.RestRegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRegistryFactoryResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/";
    private static final Logger LOG = LoggerFactory.getLogger(RestRegistryFactoryResolver.class);
    private FactoryFinder factoryFinder;

    public RestRegistryFactory resolve(CamelContext context) {
        Class<?> type = null;
        try {
            type = this.findFactory("rest-registry-factory", context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found RestRegistryFactory: {} via: {}{}", new Object[]{type.getName(), this.factoryFinder.getResourcePath(), "rest-registry-factory"});
            }
            if (RestRegistryFactory.class.isAssignableFrom(type)) {
                RestRegistryFactory answer = (RestRegistryFactory)context.getInjector().newInstance(type, false);
                LOG.debug("Detected and using RestRegistryFactory: {}", (Object)answer);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a RestRegistryFactory implementation. Found: " + type.getName());
        }
        LOG.debug("Cannot find RestRegistryFactory. Make sure camel-rest is on the classpath.");
        return null;
    }

    private Class<?> findFactory(String name, CamelContext context) throws ClassNotFoundException, IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name);
    }
}

