/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.SkipIterator;
import org.apache.camel.util.StringHelper;

public final class SimpleExpressionBuilder {
    private static final Pattern OFFSET_PATTERN = Pattern.compile("([+-])([^+-]+)");

    private SimpleExpressionBuilder() {
    }

    public static Expression headersOgnlExpression(String ognl) {
        return new KeyedOgnlExpressionAdapter(ognl, "headerOgnl(" + ognl + ")", new KeyedOgnlExpressionAdapter.KeyedEntityRetrievalStrategy(){

            @Override
            public Object getKeyedEntity(Exchange exchange, String key) {
                String text = (String)ExpressionBuilder.simpleExpression((String)key).evaluate(exchange, String.class);
                return exchange.getIn().getHeader(text);
            }
        });
    }

    public static Expression messageHistoryExpression(final boolean detailed) {
        return new ExpressionAdapter(){
            private ExchangeFormatter formatter;

            public Object evaluate(Exchange exchange) {
                ExchangeFormatter ef = null;
                if (detailed) {
                    ef = this.getOrCreateExchangeFormatter(exchange.getContext());
                }
                return MessageHelper.dumpMessageHistoryStacktrace((Exchange)exchange, ef, (boolean)false);
            }

            private ExchangeFormatter getOrCreateExchangeFormatter(CamelContext camelContext) {
                if (this.formatter == null) {
                    Set formatters = camelContext.getRegistry().findByType(ExchangeFormatter.class);
                    if (formatters != null && formatters.size() == 1) {
                        this.formatter = (ExchangeFormatter)formatters.iterator().next();
                    } else {
                        DefaultExchangeFormatter def = new DefaultExchangeFormatter();
                        def.setShowExchangeId(true);
                        def.setMultiline(true);
                        def.setShowHeaders(true);
                        def.setStyle(DefaultExchangeFormatter.OutputStyle.Fixed);
                        try {
                            Integer maxChars = CamelContextHelper.parseInteger((CamelContext)camelContext, (String)camelContext.getGlobalOption("CamelLogDebugBodyMaxChars"));
                            if (maxChars != null) {
                                def.setMaxChars(maxChars.intValue());
                            }
                        }
                        catch (Exception e) {
                            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                        }
                        this.formatter = def;
                    }
                }
                return this.formatter;
            }

            public String toString() {
                return "messageHistory(" + detailed + ")";
            }
        };
    }

    public static Expression collateExpression(final String expression, final int group) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Expression exp = exchange.getContext().resolveLanguage("simple").createExpression(expression);
                return ExpressionBuilder.groupIteratorExpression((Expression)exp, null, (String)("" + group), (boolean)false).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "collate(" + expression + "," + group + ")";
            }
        };
    }

    public static Expression skipExpression(final String expression, final int number) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Expression exp = exchange.getContext().resolveLanguage("simple").createExpression(expression);
                return SimpleExpressionBuilder.skipIteratorExpression(exp, number).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "skip(" + expression + "," + number + ")";
            }
        };
    }

    public static Expression randomExpression(final String min, final String max) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                int num1 = (Integer)ExpressionBuilder.simpleExpression((String)min).evaluate(exchange, Integer.class);
                int num2 = (Integer)ExpressionBuilder.simpleExpression((String)max).evaluate(exchange, Integer.class);
                Random random = new Random();
                int randomNum = random.nextInt(num2 - num1) + num1;
                return randomNum;
            }

            public String toString() {
                return "random(" + min + "," + max + ")";
            }
        };
    }

    public static Expression randomExpression(int max) {
        return SimpleExpressionBuilder.randomExpression(0, max);
    }

    public static Expression randomExpression(final int min, final int max) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Random random = new Random();
                int randomNum = random.nextInt(max - min) + min;
                return randomNum;
            }

            public String toString() {
                return "random(" + min + "," + max + ")";
            }
        };
    }

    public static Expression fileNameExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileName", String.class);
            }

            public String toString() {
                return "file:name";
            }
        };
    }

    public static Expression fileOnlyNameExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String answer = (String)exchange.getIn().getHeader("CamelFileNameOnly", String.class);
                if (answer == null) {
                    answer = (String)exchange.getIn().getHeader("CamelFileName", String.class);
                    answer = FileUtil.stripPath((String)answer);
                }
                return answer;
            }

            public String toString() {
                return "file:onlyname";
            }
        };
    }

    public static Expression fileNameNoExtensionExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String name = (String)exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.stripExt((String)name);
            }

            public String toString() {
                return "file:name.noext";
            }
        };
    }

    public static Expression fileNameNoExtensionSingleExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String name = (String)exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.stripExt((String)name, (boolean)true);
            }

            public String toString() {
                return "file:name.noext.single";
            }
        };
    }

    public static Expression fileOnlyNameNoExtensionExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String name = (String)SimpleExpressionBuilder.fileOnlyNameExpression().evaluate(exchange, String.class);
                return FileUtil.stripExt((String)name);
            }

            public String toString() {
                return "file:onlyname.noext";
            }
        };
    }

    public static Expression fileOnlyNameNoExtensionSingleExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String name = (String)SimpleExpressionBuilder.fileOnlyNameExpression().evaluate(exchange, String.class);
                return FileUtil.stripExt((String)name, (boolean)true);
            }

            public String toString() {
                return "file:onlyname.noext.single";
            }
        };
    }

    public static Expression fileExtensionExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String name = (String)exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.onlyExt((String)name);
            }

            public String toString() {
                return "file:ext";
            }
        };
    }

    public static Expression fileExtensionSingleExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String name = (String)exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.onlyExt((String)name, (boolean)true);
            }

            public String toString() {
                return "file:ext.single";
            }
        };
    }

    public static Expression fileParentExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileParent", String.class);
            }

            public String toString() {
                return "file:parent";
            }
        };
    }

    public static Expression filePathExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFilePath", String.class);
            }

            public String toString() {
                return "file:path";
            }
        };
    }

    public static Expression fileAbsolutePathExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileAbsolutePath", String.class);
            }

            public String toString() {
                return "file:absolute.path";
            }
        };
    }

    public static Expression fileAbsoluteExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileAbsolute", Boolean.class);
            }

            public String toString() {
                return "file:absolute";
            }
        };
    }

    public static Expression fileSizeExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileLength", Long.class);
            }

            public String toString() {
                return "file:length";
            }
        };
    }

    public static Expression fileLastModifiedExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileLastModified", Long.class);
            }

            public String toString() {
                return "file:modified";
            }
        };
    }

    public static Expression dateExpression(String command) {
        return SimpleExpressionBuilder.dateExpression(command, null, null);
    }

    public static Expression dateExpression(String command, String pattern) {
        return SimpleExpressionBuilder.dateExpression(command, null, pattern);
    }

    public static Expression dateExpression(final String commandWithOffsets, final String timezone, final String pattern) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String key;
                Date date;
                String command = commandWithOffsets.split("[+-]", 2)[0].trim();
                ArrayList<Long> offsets = new ArrayList<Long>();
                Matcher offsetMatcher = OFFSET_PATTERN.matcher(commandWithOffsets);
                while (offsetMatcher.find()) {
                    try {
                        long value = (Long)exchange.getContext().getTypeConverter().mandatoryConvertTo(Long.TYPE, exchange, (Object)offsetMatcher.group(2).trim());
                        offsets.add(offsetMatcher.group(1).equals("+") ? value : -value);
                    }
                    catch (NoTypeConversionAvailableException e) {
                        throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
                    }
                }
                if ("now".equals(command)) {
                    date = new Date();
                } else if (command.startsWith("header.") || command.startsWith("in.header.")) {
                    key = command.substring(command.lastIndexOf(46) + 1);
                    date = (Date)exchange.getIn().getHeader(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Cannot find java.util.Date object at command: " + command);
                    }
                } else if (command.startsWith("out.header.")) {
                    key = command.substring(command.lastIndexOf(46) + 1);
                    date = (Date)exchange.getOut().getHeader(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Cannot find java.util.Date object at command: " + command);
                    }
                } else if (command.startsWith("exchangeProperty.")) {
                    key = command.substring(command.lastIndexOf(46) + 1);
                    date = (Date)exchange.getProperty(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Cannot find java.util.Date object at command: " + command);
                    }
                } else if ("file".equals(command)) {
                    Long num = (Long)exchange.getIn().getHeader("CamelFileLastModified", Long.class);
                    if (num != null && num > 0L) {
                        date = new Date(num);
                    } else {
                        date = (Date)exchange.getIn().getHeader("CamelFileLastModified", Date.class);
                        if (date == null) {
                            throw new IllegalArgumentException("Cannot find CamelFileLastModified header at command: " + command);
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Command not supported for dateExpression: " + command);
                }
                long dateAsLong = date.getTime();
                Iterator iterator = offsets.iterator();
                while (iterator.hasNext()) {
                    long offset = (Long)iterator.next();
                    dateAsLong += offset;
                }
                date = new Date(dateAsLong);
                if (pattern != null && !pattern.isEmpty()) {
                    SimpleDateFormat df = new SimpleDateFormat(pattern);
                    if (timezone != null && !timezone.isEmpty()) {
                        df.setTimeZone(TimeZone.getTimeZone(timezone));
                    }
                    return df.format(date);
                }
                return date;
            }

            public String toString() {
                return "date(" + commandWithOffsets + ":" + pattern + ":" + timezone + ")";
            }
        };
    }

    public static Expression skipIteratorExpression(final Expression expression, final int skip) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Iterator it = (Iterator)expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull((Object)it, (String)("expression: " + expression + " evaluated on " + exchange + " must return an java.util.Iterator"));
                return new SkipIterator(it, skip);
            }

            public String toString() {
                return "skip " + expression + " " + skip + " times";
            }
        };
    }

    public static Expression nullExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return null;
            }

            public String toString() {
                return "null";
            }
        };
    }

    public static Expression mandatoryBodyOgnlExpression(final String name, final String ognl) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Object body;
                Class type;
                String text = (String)ExpressionBuilder.simpleExpression((String)name).evaluate(exchange, String.class);
                try {
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
                }
                try {
                    body = exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
                }
                Expression exp = ExpressionBuilder.beanExpression((Object)body, (String)ognl);
                return exp.evaluate(exchange, Object.class);
            }

            public String toString() {
                return "mandatoryBodyAs[" + name + "](" + ognl + ")";
            }
        };
    }

    public static Expression mandatoryBodyExpression(final String name) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Class type;
                String text = (String)ExpressionBuilder.simpleExpression((String)name).evaluate(exchange, String.class);
                try {
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
                }
                try {
                    return exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
                }
            }

            public String toString() {
                return "mandatoryBodyAs[" + name + "]";
            }
        };
    }

    public static Expression bodyOgnlExpression(final String name, final String ognl) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Class type;
                String text = (String)ExpressionBuilder.simpleExpression((String)name).evaluate(exchange, String.class);
                try {
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
                }
                Object body = exchange.getIn().getBody(type);
                if (body != null) {
                    return ExpressionBuilder.beanExpression((Object)body, (String)ognl).evaluate(exchange, Object.class);
                }
                return null;
            }

            public String toString() {
                return "bodyOgnlAs[" + name + "](" + ognl + ")";
            }
        };
    }

    public static Expression exchangeOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return ExpressionBuilder.beanExpression((Object)exchange, (String)ognl).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "exchangeOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression camelContextOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                CamelContext context = exchange.getContext();
                if (context == null) {
                    return null;
                }
                return ExpressionBuilder.beanExpression((Object)context, (String)ognl).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "camelContextOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression bodyOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Object body = exchange.getIn().getBody();
                if (body == null) {
                    return null;
                }
                return ExpressionBuilder.beanExpression((Object)body, (String)ognl).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "bodyOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression cacheExpression(final Expression expression) {
        return new ExpressionAdapter(){
            private final AtomicReference<Object> cache = new AtomicReference();

            public Object evaluate(Exchange exchange) {
                Object answer = this.cache.get();
                if (answer == null) {
                    answer = expression.evaluate(exchange, Object.class);
                    this.cache.set(answer);
                }
                return answer;
            }

            public String toString() {
                return expression.toString();
            }
        };
    }

    public static Expression typeExpression(final String name) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String text = (String)ExpressionBuilder.simpleExpression((String)name).evaluate(exchange, String.class);
                Class type = exchange.getContext().getClassResolver().resolveClass(text);
                if (type != null) {
                    return type;
                }
                int pos = text.lastIndexOf(".");
                if (pos > 0) {
                    String before = text.substring(0, pos);
                    String after = text.substring(pos + 1);
                    type = exchange.getContext().getClassResolver().resolveClass(before);
                    if (type != null) {
                        return ObjectHelper.lookupConstantFieldValue((Class)type, (String)after);
                    }
                }
                throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)new ClassNotFoundException("Cannot find type " + text));
            }

            public String toString() {
                return "type:" + name;
            }
        };
    }

    public static Expression propertyOgnlExpression(String ognl) {
        return new KeyedOgnlExpressionAdapter(ognl, "propertyOgnl(" + ognl + ")", new KeyedOgnlExpressionAdapter.KeyedEntityRetrievalStrategy(){

            @Override
            public Object getKeyedEntity(Exchange exchange, String key) {
                String text = (String)ExpressionBuilder.simpleExpression((String)key).evaluate(exchange, String.class);
                return exchange.getProperty(text);
            }
        });
    }

    public static Expression exchangeExceptionOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Object exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                if (exception == null) {
                    return null;
                }
                return ExpressionBuilder.beanExpression((Object)exception, (String)ognl).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "exchangeExceptionOgnl(" + ognl + ")";
            }
        };
    }

    public static class KeyedOgnlExpressionAdapter
    extends ExpressionAdapter {
        private final String ognl;
        private final String toStringValue;
        private final KeyedEntityRetrievalStrategy keyedEntityRetrievalStrategy;

        KeyedOgnlExpressionAdapter(String ognl, String toStringValue, KeyedEntityRetrievalStrategy keyedEntityRetrievalStrategy) {
            this.ognl = ognl;
            this.toStringValue = toStringValue;
            this.keyedEntityRetrievalStrategy = keyedEntityRetrievalStrategy;
        }

        public Object evaluate(Exchange exchange) {
            Object property = this.keyedEntityRetrievalStrategy.getKeyedEntity(exchange, this.ognl);
            if (property != null) {
                return property;
            }
            List methods = OgnlHelper.splitOgnl((String)this.ognl);
            String key = (String)methods.get(0);
            String keySuffix = "";
            if (key.startsWith("[") && key.endsWith("]")) {
                key = StringHelper.removeLeadingAndEndingQuotes((String)key.substring(1, key.length() - 1));
                keySuffix = StringHelper.after((String)((String)methods.get(0)), (String)key);
            }
            if ((property = this.keyedEntityRetrievalStrategy.getKeyedEntity(exchange, key = OgnlHelper.removeOperators((String)key))) == null) {
                return null;
            }
            String remainder = StringHelper.after((String)this.ognl, (String)(key + keySuffix));
            return ExpressionBuilder.beanExpression((Object)property, (String)remainder).evaluate(exchange, Object.class);
        }

        public String toString() {
            return this.toStringValue;
        }

        public static interface KeyedEntityRetrievalStrategy {
            public Object getKeyedEntity(Exchange var1, String var2);
        }
    }
}

