/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.language.simple.SimpleExpressionBuilder;
import org.apache.camel.language.simple.ast.LiteralExpression;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.StringHelper;

public class SimpleFunctionExpression
extends LiteralExpression {
    private Map<String, Expression> cacheExpression;

    public SimpleFunctionExpression(SimpleToken token, Map<String, Expression> cacheExpression) {
        super(token);
        this.cacheExpression = cacheExpression;
    }

    @Override
    public Expression createExpression(String expression) {
        Expression answer;
        String function = this.text.toString();
        Expression expression2 = answer = this.cacheExpression != null ? this.cacheExpression.get(function) : null;
        if (answer == null) {
            answer = this.createSimpleExpression(function, true);
            if (this.cacheExpression != null && answer != null) {
                this.cacheExpression.put(function, answer);
            }
        }
        return answer;
    }

    public Expression createExpression(String expression, boolean strict) {
        Expression answer;
        String function = this.text.toString();
        Expression expression2 = answer = this.cacheExpression != null ? this.cacheExpression.get(function) : null;
        if (answer == null) {
            answer = this.createSimpleExpression(function, strict);
            if (this.cacheExpression != null && answer != null) {
                this.cacheExpression.put(function, answer);
            }
        }
        return answer;
    }

    private Expression createSimpleExpression(String function, boolean strict) {
        String[] parts;
        Expression fileExpression;
        Expression answer = this.createSimpleExpressionDirectly(function);
        if (answer != null) {
            return answer;
        }
        answer = this.createSimpleExpressionBodyOrHeader(function, strict);
        if (answer != null) {
            return answer;
        }
        String remainder = this.ifStartsWithReturnRemainder("camelContext", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${camelContext.OGNL} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.camelContextOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("exception", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exception.OGNL} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.exchangeExceptionOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("exchangeProperty", function);
        if (remainder != null) {
            boolean invalid;
            if (remainder.startsWith(".") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            if (invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder)) {
                throw new SimpleParserException("Valid syntax: ${exchangeProperty.OGNL} was: " + function, this.token.getIndex());
            }
            if (OgnlHelper.isValidOgnlExpression((String)remainder)) {
                return SimpleExpressionBuilder.propertyOgnlExpression(remainder);
            }
            return ExpressionBuilder.exchangePropertyExpression((String)remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sys.", function);
        if (remainder != null) {
            return ExpressionBuilder.systemPropertyExpression((String)remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sysenv.", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("sysenv:", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("env.", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("env:", function);
        }
        if (remainder != null) {
            return ExpressionBuilder.systemEnvironmentExpression((String)remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("exchange", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exchange.OGNL} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.exchangeOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("file:", function);
        if (remainder != null && (fileExpression = this.createSimpleFileExpression(remainder, strict)) != null) {
            return fileExpression;
        }
        remainder = this.ifStartsWithReturnRemainder("date:", function);
        if (remainder != null) {
            parts = remainder.split(":", 2);
            if (parts.length == 1) {
                return SimpleExpressionBuilder.dateExpression(parts[0]);
            }
            if (parts.length == 2) {
                return SimpleExpressionBuilder.dateExpression(parts[0], parts[1]);
            }
        }
        if ((remainder = this.ifStartsWithReturnRemainder("date-with-timezone:", function)) != null) {
            parts = remainder.split(":", 3);
            if (parts.length < 3) {
                throw new SimpleParserException("Valid syntax: ${date-with-timezone:command:timezone:pattern} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.dateExpression(parts[0], parts[1], parts[2]);
        }
        remainder = this.ifStartsWithReturnRemainder("bean:", function);
        if (remainder != null) {
            return ExpressionBuilder.beanExpression((String)remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("properties:", function);
        if (remainder != null) {
            parts = remainder.split(":");
            if (parts.length > 2) {
                throw new SimpleParserException("Valid syntax: ${properties:key[:default]} was: " + function, this.token.getIndex());
            }
            String defaultValue = null;
            if (parts.length >= 2) {
                defaultValue = parts[1];
            }
            String key = parts[0];
            return ExpressionBuilder.propertiesComponentExpression((String)key, null, (String)defaultValue);
        }
        remainder = this.ifStartsWithReturnRemainder("properties-location:", function);
        if (remainder != null) {
            parts = remainder.split(":");
            if (parts.length > 3) {
                throw new SimpleParserException("Valid syntax: ${properties-location:location:key[:default]} was: " + function, this.token.getIndex());
            }
            String defaultValue = null;
            if (parts.length >= 3) {
                defaultValue = parts[2];
            }
            String key = null;
            if (parts.length >= 2) {
                key = parts[1];
            }
            String locations = parts[0];
            return ExpressionBuilder.propertiesComponentExpression((String)key, (String)locations, null);
        }
        remainder = this.ifStartsWithReturnRemainder("ref:", function);
        if (remainder != null) {
            return ExpressionBuilder.refExpression((String)remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("type:", function);
        if (remainder != null) {
            Expression exp = SimpleExpressionBuilder.typeExpression(remainder);
            return SimpleExpressionBuilder.cacheExpression(exp);
        }
        Expression misc = this.createSimpleExpressionMisc(function);
        if (misc != null) {
            return misc;
        }
        if (strict) {
            throw new SimpleParserException("Unknown function: " + function, this.token.getIndex());
        }
        return null;
    }

    private Expression createSimpleExpressionBodyOrHeader(String function, boolean strict) {
        String remainder = this.ifStartsWithReturnRemainder("bodyAs(", function);
        if (remainder != null) {
            String type = StringHelper.before((String)remainder, (String)")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${bodyAs(type)} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes((String)type);
            if (ObjectHelper.isNotEmpty((Object)(remainder = StringHelper.after((String)remainder, (String)")")))) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${bodyAs(type).OGNL} was: " + function, this.token.getIndex());
                }
                return SimpleExpressionBuilder.bodyOgnlExpression(type, remainder);
            }
            return ExpressionBuilder.bodyExpression((String)type);
        }
        remainder = this.ifStartsWithReturnRemainder("mandatoryBodyAs(", function);
        if (remainder != null) {
            String type = StringHelper.before((String)remainder, (String)")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type)} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes((String)type);
            if (ObjectHelper.isNotEmpty((Object)(remainder = StringHelper.after((String)remainder, (String)")")))) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type).OGNL} was: " + function, this.token.getIndex());
                }
                return SimpleExpressionBuilder.mandatoryBodyOgnlExpression(type, remainder);
            }
            return SimpleExpressionBuilder.mandatoryBodyExpression(type);
        }
        remainder = this.ifStartsWithReturnRemainder("body", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.body", function);
        }
        if (remainder != null) {
            boolean invalid;
            boolean ognlStart = remainder.startsWith(".") || remainder.startsWith("?") || remainder.startsWith("[");
            boolean bl = invalid = !ognlStart || OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${body.OGNL} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.bodyOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("headerAs(", function);
        if (remainder != null) {
            String keyAndType = StringHelper.before((String)remainder, (String)")");
            if (keyAndType == null) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            String key = StringHelper.before((String)keyAndType, (String)",");
            String type = StringHelper.after((String)keyAndType, (String)",");
            remainder = StringHelper.after((String)remainder, (String)")");
            if (ObjectHelper.isEmpty((Object)key) || ObjectHelper.isEmpty((Object)type) || ObjectHelper.isNotEmpty((Object)remainder)) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes((String)key);
            type = StringHelper.removeQuotes((String)type);
            return ExpressionBuilder.headerExpression((String)key, (String)type);
        }
        if ("in.headers".equals(function) || "headers".equals(function)) {
            return ExpressionBuilder.headersExpression();
        }
        remainder = this.ifStartsWithReturnRemainder("in.headers", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.header", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("headers", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("header", function);
        }
        if (remainder != null) {
            String key;
            boolean invalid;
            if (remainder.startsWith(".") || remainder.startsWith(":") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            if (invalid = OgnlHelper.isInvalidValidOgnlExpression((String)(key = StringHelper.removeLeadingAndEndingQuotes((String)remainder)))) {
                throw new SimpleParserException("Valid syntax: ${header.name[key]} was: " + function, this.token.getIndex());
            }
            if (OgnlHelper.isValidOgnlExpression((String)key)) {
                return SimpleExpressionBuilder.headersOgnlExpression(key);
            }
            return ExpressionBuilder.headerExpression((String)key);
        }
        remainder = this.ifStartsWithReturnRemainder("out.header.", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("out.header:", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("out.headers.", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("out.headers:", function);
        }
        if (remainder != null) {
            return ExpressionBuilder.outHeaderExpression((String)remainder);
        }
        return null;
    }

    private Expression createSimpleExpressionDirectly(String expression) {
        if (ObjectHelper.isEqualToAny((Object)expression, (Object[])new Object[]{"body", "in.body"})) {
            return ExpressionBuilder.bodyExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"out.body")) {
            return ExpressionBuilder.outBodyExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"id")) {
            return ExpressionBuilder.messageIdExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exchangeId")) {
            return ExpressionBuilder.exchangeIdExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exchange")) {
            return ExpressionBuilder.exchangeExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exception")) {
            return ExpressionBuilder.exchangeExceptionExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exception.message")) {
            return ExpressionBuilder.exchangeExceptionMessageExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exception.stacktrace")) {
            return ExpressionBuilder.exchangeExceptionStackTraceExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"threadName")) {
            return ExpressionBuilder.threadNameExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"camelId")) {
            return ExpressionBuilder.camelContextNameExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"routeId")) {
            return ExpressionBuilder.routeIdExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"stepId")) {
            return ExpressionBuilder.stepIdExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"null")) {
            return SimpleExpressionBuilder.nullExpression();
        }
        return null;
    }

    private Expression createSimpleFileExpression(String remainder, boolean strict) {
        if (ObjectHelper.equal((Object)remainder, (Object)"name")) {
            return SimpleExpressionBuilder.fileNameExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"name.noext")) {
            return SimpleExpressionBuilder.fileNameNoExtensionExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"name.noext.single")) {
            return SimpleExpressionBuilder.fileNameNoExtensionSingleExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"name.ext") || ObjectHelper.equal((Object)remainder, (Object)"ext")) {
            return SimpleExpressionBuilder.fileExtensionExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"name.ext.single")) {
            return SimpleExpressionBuilder.fileExtensionSingleExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"onlyname")) {
            return SimpleExpressionBuilder.fileOnlyNameExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"onlyname.noext")) {
            return SimpleExpressionBuilder.fileOnlyNameNoExtensionExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"onlyname.noext.single")) {
            return SimpleExpressionBuilder.fileOnlyNameNoExtensionSingleExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"parent")) {
            return SimpleExpressionBuilder.fileParentExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"path")) {
            return SimpleExpressionBuilder.filePathExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"absolute")) {
            return SimpleExpressionBuilder.fileAbsoluteExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"absolute.path")) {
            return SimpleExpressionBuilder.fileAbsolutePathExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"length") || ObjectHelper.equal((Object)remainder, (Object)"size")) {
            return SimpleExpressionBuilder.fileSizeExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"modified")) {
            return SimpleExpressionBuilder.fileLastModifiedExpression();
        }
        if (strict) {
            throw new SimpleParserException("Unknown file language syntax: " + remainder, this.token.getIndex());
        }
        return null;
    }

    private Expression createSimpleExpressionMisc(String function) {
        String remainder = this.ifStartsWithReturnRemainder("random(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((Object)values)) {
                throw new SimpleParserException("Valid syntax: ${random(min,max)} or ${random(max)} was: " + function, this.token.getIndex());
            }
            if (values.contains(",")) {
                String[] tokens = values.split(",", -1);
                if (tokens.length > 2) {
                    throw new SimpleParserException("Valid syntax: ${random(min,max)} or ${random(max)} was: " + function, this.token.getIndex());
                }
                return SimpleExpressionBuilder.randomExpression(tokens[0].trim(), tokens[1].trim());
            }
            return SimpleExpressionBuilder.randomExpression("0", values.trim());
        }
        remainder = this.ifStartsWithReturnRemainder("skip(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((Object)values)) {
                throw new SimpleParserException("Valid syntax: ${skip(number)} was: " + function, this.token.getIndex());
            }
            String exp = "${body}";
            int num = Integer.parseInt(values.trim());
            return SimpleExpressionBuilder.skipExpression(exp, num);
        }
        remainder = this.ifStartsWithReturnRemainder("collate(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((Object)values)) {
                throw new SimpleParserException("Valid syntax: ${collate(group)} was: " + function, this.token.getIndex());
            }
            String exp = "${body}";
            int num = Integer.parseInt(values.trim());
            return SimpleExpressionBuilder.collateExpression(exp, num);
        }
        remainder = this.ifStartsWithReturnRemainder("messageHistory", function);
        if (remainder != null) {
            String values = StringHelper.between((String)remainder, (String)"(", (String)")");
            boolean detailed = values == null || ObjectHelper.isEmpty((Object)values) ? true : Boolean.valueOf(values);
            return SimpleExpressionBuilder.messageHistoryExpression(detailed);
        }
        if (ObjectHelper.equal((Object)function, (Object)"messageHistory")) {
            return SimpleExpressionBuilder.messageHistoryExpression(true);
        }
        return null;
    }

    private String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }
}

