/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class ConvertBodyProcessor
extends ServiceSupport
implements AsyncProcessor,
IdAware {
    private String id;
    private final Class<?> type;
    private final String charset;

    public ConvertBodyProcessor(Class<?> type) {
        ObjectHelper.notNull(type, (String)"type", (Object)((Object)this));
        this.type = type;
        this.charset = null;
    }

    public ConvertBodyProcessor(Class<?> type, String charset) {
        ObjectHelper.notNull(type, (String)"type", (Object)((Object)this));
        this.type = type;
        this.charset = IOHelper.normalizeCharset((String)charset);
    }

    public String toString() {
        return "convertBodyTo[" + this.type.getCanonicalName() + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void process(Exchange exchange) throws Exception {
        boolean copyNeeded;
        Message old;
        boolean out = exchange.hasOut();
        Message message = old = out ? exchange.getOut() : exchange.getIn();
        if (old.getBody() == null) {
            return;
        }
        if (exchange.getException() != null) {
            return;
        }
        String originalCharsetName = null;
        if (this.charset != null) {
            originalCharsetName = (String)exchange.getProperty("CamelCharsetName", String.class);
            exchange.setProperty("CamelCharsetName", (Object)this.charset);
        }
        Object value = old.getMandatoryBody(this.type);
        boolean bl = copyNeeded = !old.getClass().equals(DefaultMessage.class);
        if (copyNeeded) {
            DefaultMessage msg = new DefaultMessage(exchange.getContext());
            msg.copyFromWithNewBody(old, value);
            ExchangeHelper.replaceMessage((Exchange)exchange, (Message)msg, (boolean)false);
        } else {
            old.setBody(value);
        }
        if (this.charset != null) {
            if (originalCharsetName != null && !originalCharsetName.isEmpty()) {
                exchange.setProperty("CamelCharsetName", (Object)originalCharsetName);
            } else {
                exchange.removeProperty("CamelCharsetName");
            }
        }
    }

    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter callback = new AsyncCallbackToCompletableFutureAdapter((Object)exchange);
        this.process(exchange, (AsyncCallback)callback);
        return callback.getFuture();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getCharset() {
        return this.charset;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

