/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;

public class FinallyProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware {
    private String id;

    public FinallyProcessor(Processor processor) {
        super(processor);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean fault;
        if (exchange.hasOut()) {
            fault = exchange.getOut().isFault();
            exchange.getOut().setFault(false);
        } else {
            fault = exchange.getIn().isFault();
            exchange.getIn().setFault(false);
        }
        Exception exception = exchange.getException();
        exchange.setException(null);
        if (exception != null) {
            exchange.setProperty("CamelExceptionCaught", (Object)exception);
        }
        if (exchange.getProperty("CamelFailureEndpoint") == null) {
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
        }
        return this.processor.process(exchange, (AsyncCallback)new FinallyAsyncCallback(exchange, callback, exception, fault));
    }

    public String toString() {
        return "Finally{" + this.getProcessor() + "}";
    }

    public String getTraceLabel() {
        return "finally";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    private final class FinallyAsyncCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final Exception exception;
        private final boolean fault;

        FinallyAsyncCallback(Exchange exchange, AsyncCallback callback, Exception exception, boolean fault) {
            this.exchange = exchange;
            this.callback = callback;
            this.exception = exception;
            this.fault = fault;
        }

        public void done(boolean doneSync) {
            try {
                if (this.exception == null) {
                    this.exchange.removeProperty("CamelFailureEndpoint");
                } else {
                    this.exchange.setException((Throwable)this.exception);
                    this.exchange.setProperty("CamelExceptionCaught", (Object)this.exception);
                }
                if (this.fault) {
                    if (this.exchange.hasOut()) {
                        this.exchange.getOut().setFault(true);
                    } else {
                        this.exchange.getIn().setFault(true);
                    }
                }
                if (!doneSync) {
                    ExchangeHelper.prepareOutToIn((Exchange)this.exchange);
                    FinallyProcessor.this.log.trace("Processing complete for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
                }
            }
            finally {
                this.callback.done(doneSync);
            }
        }

        public String toString() {
            return "FinallyAsyncCallback";
        }
    }
}

