/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.Traceable;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ReactiveHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.concurrent.AsyncCompletionService;
import org.slf4j.Logger;

public class MulticastProcessor
extends AsyncProcessorSupport
implements Navigate<Processor>,
Traceable,
IdAware {
    protected final Processor onPrepare;
    private final CamelContext camelContext;
    private String id;
    private Collection<Processor> processors;
    private final AggregationStrategy aggregationStrategy;
    private final boolean parallelProcessing;
    private final boolean streaming;
    private final boolean parallelAggregate;
    private final boolean stopOnAggregateException;
    private final boolean stopOnException;
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private ExecutorService aggregateExecutorService;
    private final long timeout;
    private final ConcurrentMap<PreparedErrorHandler, Processor> errorHandlers = new ConcurrentHashMap<PreparedErrorHandler, Processor>();
    private final boolean shareUnitOfWork;

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors) {
        this(camelContext, processors, null);
    }

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors, AggregationStrategy aggregationStrategy) {
        this(camelContext, processors, aggregationStrategy, false, null, false, false, false, 0L, null, false, false);
    }

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean shareUnitOfWork, boolean parallelAggregate) {
        this(camelContext, processors, aggregationStrategy, parallelProcessing, executorService, shutdownExecutorService, streaming, stopOnException, timeout, onPrepare, shareUnitOfWork, parallelAggregate, false);
    }

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean shareUnitOfWork, boolean parallelAggregate, boolean stopOnAggregateException) {
        ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        this.camelContext = camelContext;
        this.processors = processors;
        this.aggregationStrategy = aggregationStrategy;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.streaming = streaming;
        this.stopOnException = stopOnException;
        this.parallelProcessing = parallelProcessing || executorService != null;
        this.timeout = timeout;
        this.onPrepare = onPrepare;
        this.shareUnitOfWork = shareUnitOfWork;
        this.parallelAggregate = parallelAggregate;
        this.stopOnAggregateException = stopOnAggregateException;
    }

    public String toString() {
        return "Multicast[" + this.getProcessors() + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTraceLabel() {
        return "multicast";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Iterable<ProcessorExchangePair> pairs;
        try {
            pairs = this.createProcessorExchangePairs(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
            this.doDone(exchange, null, null, callback, true, false);
            return true;
        }
        MulticastState state = new MulticastState(exchange, pairs, callback);
        if (this.isParallelProcessing()) {
            this.executorService.submit(() -> ReactiveHelper.schedule((Runnable)state));
        } else if (exchange.isTransacted()) {
            ReactiveHelper.scheduleSync((Runnable)state);
        } else {
            ReactiveHelper.scheduleMain((Runnable)state);
        }
        return false;
    }

    protected void schedule(Runnable runnable) {
        if (this.isParallelProcessing()) {
            this.executorService.submit(() -> ReactiveHelper.schedule((Runnable)runnable));
        } else {
            ReactiveHelper.schedule((Runnable)runnable, (String)"Multicast next step");
        }
    }

    protected void schedule(Executor executor, Runnable runnable, long delay, TimeUnit unit) {
        if (executor instanceof ScheduledExecutorService) {
            ((ScheduledExecutorService)executor).schedule(runnable, delay, unit);
        } else {
            executor.execute(() -> {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                runnable.run();
            });
        }
    }

    protected StopWatch beforeSend(ProcessorExchangePair pair) {
        boolean sending;
        Exchange e = pair.getExchange();
        Producer p = pair.getProducer();
        StopWatch watch = p != null ? ((sending = EventHelper.notifyExchangeSending((CamelContext)e.getContext(), (Exchange)e, (Endpoint)p.getEndpoint())) ? new StopWatch() : null) : null;
        pair.begin();
        return watch;
    }

    protected void afterSend(ProcessorExchangePair pair, StopWatch watch) {
        pair.done();
        Producer producer = pair.getProducer();
        if (producer != null && watch != null) {
            long timeTaken = watch.taken();
            Exchange e = pair.getExchange();
            Endpoint endpoint = producer.getEndpoint();
            EventHelper.notifyExchangeSent((CamelContext)e.getContext(), (Exchange)e, (Endpoint)endpoint, (long)timeTaken);
        }
    }

    protected void doDone(Exchange original, Exchange subExchange, Iterable<ProcessorExchangePair> pairs, AsyncCallback callback, boolean doneSync, boolean forceExhaust) {
        boolean exhaust;
        AggregationStrategy strategy;
        if (pairs instanceof Closeable) {
            IOHelper.close((Closeable)((Closeable)((Object)pairs)), (String)"pairs", (Logger)this.log);
        }
        if ((strategy = this.getAggregationStrategy(subExchange)) != null) {
            strategy.onCompletion(subExchange);
        }
        this.removeAggregationStrategyFromExchange(original);
        boolean stoppedOnException = false;
        boolean exception = false;
        boolean bl = exhaust = forceExhaust || subExchange != null && (subExchange.getException() != null || ExchangeHelper.isRedeliveryExhausted((Exchange)subExchange));
        if (original.getException() != null || subExchange != null && subExchange.getException() != null) {
            stoppedOnException = this.isStopOnException();
            exception = true;
        }
        if (subExchange != null) {
            if (stoppedOnException) {
                original.setException((Throwable)subExchange.getException());
            } else {
                ExchangeHelper.copyResults((Exchange)original, (Exchange)subExchange);
            }
        }
        if (exception) {
            original.setProperty("CamelRedeliveryExhausted", (Object)exhaust);
        }
        ReactiveHelper.callback((AsyncCallback)callback);
    }

    protected void doAggregate(AtomicReference<Exchange> result, Exchange exchange) {
        if (this.parallelAggregate) {
            this.doAggregateInternal(this.getAggregationStrategy(exchange), result, exchange);
        } else {
            this.doAggregateSync(this.getAggregationStrategy(exchange), result, exchange);
        }
    }

    protected synchronized void doAggregateSync(AggregationStrategy strategy, AtomicReference<Exchange> result, Exchange exchange) {
        this.doAggregateInternal(strategy, result, exchange);
    }

    protected void doAggregateInternal(AggregationStrategy strategy, AtomicReference<Exchange> result, Exchange exchange) {
        if (strategy != null) {
            Exchange oldExchange = result.get();
            ExchangeHelper.prepareAggregation((Exchange)oldExchange, (Exchange)exchange);
            result.set(strategy.aggregate(oldExchange, exchange));
        }
    }

    protected void updateNewExchange(Exchange exchange, int index, Iterable<ProcessorExchangePair> allPairs, boolean hasNext) {
        exchange.setProperty("CamelMulticastIndex", (Object)index);
        if (hasNext) {
            exchange.setProperty("CamelMulticastComplete", (Object)Boolean.FALSE);
        } else {
            exchange.setProperty("CamelMulticastComplete", (Object)Boolean.TRUE);
        }
    }

    protected Integer getExchangeIndex(Exchange exchange) {
        return (Integer)exchange.getProperty("CamelMulticastIndex", Integer.class);
    }

    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>(this.processors.size());
        StreamCache streamCache = null;
        if (this.isParallelProcessing() && exchange.getIn().getBody() instanceof StreamCache) {
            streamCache = (StreamCache)exchange.getIn().getBody();
        }
        int index = 0;
        for (Processor processor : this.processors) {
            StreamCache copiedStreamCache;
            Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)false);
            if (streamCache != null && index > 0 && (copiedStreamCache = streamCache.copy(copy)) != null) {
                copy.getIn().setBody((Object)copiedStreamCache);
            }
            if (copy.getProperty("CamelStreamCacheUnitOfWork") == null) {
                copy.setProperty("CamelStreamCacheUnitOfWork", (Object)exchange.getUnitOfWork());
            }
            if (this.isShareUnitOfWork()) {
                this.prepareSharedUnitOfWork(copy, exchange);
            }
            RouteContext routeContext = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getRouteContext() : null;
            result.add(this.createProcessorExchangePair(index++, processor, copy, routeContext));
        }
        if (exchange.getException() != null) {
            throw exchange.getException();
        }
        return result;
    }

    protected ProcessorExchangePair createProcessorExchangePair(int index, Processor processor, Exchange exchange, RouteContext routeContext) {
        Processor prepared = processor;
        MulticastProcessor.setToEndpoint(exchange, prepared);
        prepared = this.createErrorHandler(routeContext, exchange, prepared);
        if (this.onPrepare != null) {
            try {
                this.onPrepare.process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
        }
        return new DefaultProcessorExchangePair(index, processor, prepared, exchange);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Processor createErrorHandler(RouteContext routeContext, Exchange exchange, Processor processor) {
        boolean tryBlock = (Boolean)exchange.getProperty("TryRouteBlock", (Object)false, Boolean.TYPE);
        if (tryBlock) return this.createUnitOfWorkProcessor(routeContext, processor, exchange);
        if (routeContext == null) return this.createUnitOfWorkProcessor(routeContext, processor, exchange);
        PreparedErrorHandler key = new PreparedErrorHandler(routeContext, processor);
        Processor answer = (Processor)this.errorHandlers.get((Object)key);
        if (answer != null) {
            this.log.trace("Using existing error handler for: {}", (Object)processor);
            return answer;
        }
        this.log.trace("Creating error handler for: {}", (Object)processor);
        ErrorHandlerFactory builder = routeContext.getErrorHandlerFactory();
        try {
            processor = builder.createErrorHandler(routeContext, processor);
            answer = this.createUnitOfWorkProcessor(routeContext, processor, exchange);
            boolean child = exchange.getProperty("CamelParentUnitOfWork", UnitOfWork.class) != null;
            ServiceHelper.startService((Object)answer);
            if (child) return answer;
            this.errorHandlers.putIfAbsent(key, answer);
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected Processor createUnitOfWorkProcessor(RouteContext routeContext, Processor processor, Exchange exchange) {
        CamelInternalProcessor internal = new CamelInternalProcessor(processor);
        UnitOfWork parent = (UnitOfWork)exchange.getProperty("CamelParentUnitOfWork", UnitOfWork.class);
        if (parent != null) {
            internal.addAdvice(new CamelInternalProcessor.ChildUnitOfWorkProcessorAdvice(routeContext, parent));
        } else {
            internal.addAdvice(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(routeContext));
        }
        return internal;
    }

    protected void prepareSharedUnitOfWork(Exchange childExchange, Exchange parentExchange) {
        childExchange.setProperty("CamelParentUnitOfWork", (Object)parentExchange.getUnitOfWork());
    }

    protected void doStart() throws Exception {
        if (this.isParallelProcessing() && this.executorService == null) {
            throw new IllegalArgumentException("ParallelProcessing is enabled but ExecutorService has not been set");
        }
        if (this.aggregateExecutorService == null) {
            String name = ((Object)((Object)this)).getClass().getSimpleName() + "-AggregateTask";
            this.aggregateExecutorService = this.createAggregateExecutorService(name);
        }
        if (this.aggregationStrategy instanceof CamelContextAware) {
            ((CamelContextAware)this.aggregationStrategy).setCamelContext(this.camelContext);
        }
        ServiceHelper.startService((Object[])new Object[]{this.aggregationStrategy, this.processors});
    }

    protected synchronized ExecutorService createAggregateExecutorService(String name) {
        return this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, name, 0);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.processors, this.errorHandlers, this.aggregationStrategy});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.processors, this.errorHandlers, this.aggregationStrategy});
        this.errorHandlers.clear();
        if (this.shutdownExecutorService && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
        if (this.aggregateExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.aggregateExecutorService);
        }
    }

    protected static void setToEndpoint(Exchange exchange, Processor processor) {
        if (processor instanceof Producer) {
            Producer producer = (Producer)processor;
            exchange.setProperty("CamelToEndpoint", (Object)producer.getEndpoint().getEndpointUri());
        }
    }

    protected AggregationStrategy getAggregationStrategy(Exchange exchange) {
        Map property;
        Map map;
        AggregationStrategy answer = null;
        if (exchange != null && (map = CastUtils.cast((Map)(property = (Map)exchange.getProperty("CamelAggregationStrategy", Map.class)))) != null) {
            answer = (AggregationStrategy)map.get((Object)this);
        }
        if (answer == null) {
            answer = this.getAggregationStrategy();
        }
        return answer;
    }

    protected void setAggregationStrategyOnExchange(Exchange exchange, AggregationStrategy aggregationStrategy) {
        Map property = (Map)exchange.getProperty("CamelAggregationStrategy", Map.class);
        ConcurrentHashMap<MulticastProcessor, Object> map = CastUtils.cast((Map)property);
        map = map == null ? new ConcurrentHashMap<MulticastProcessor, AggregationStrategy>() : new ConcurrentHashMap(map);
        map.put(this, aggregationStrategy);
        exchange.setProperty("CamelAggregationStrategy", map);
    }

    protected void removeAggregationStrategyFromExchange(Exchange exchange) {
        Map property = (Map)exchange.getProperty("CamelAggregationStrategy", Map.class);
        Map map = CastUtils.cast((Map)property);
        if (map == null) {
            return;
        }
        map.remove((Object)this);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isStopOnException() {
        return this.stopOnException;
    }

    public Collection<Processor> getProcessors() {
        return this.processors;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    public boolean isParallelAggregate() {
        return this.parallelAggregate;
    }

    public boolean isStopOnAggregateException() {
        return this.stopOnAggregateException;
    }

    public boolean isShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        return new ArrayList<Processor>(this.processors);
    }

    public boolean hasNext() {
        return this.processors != null && !this.processors.isEmpty();
    }

    protected class MulticastState
    implements Runnable {
        final Exchange original;
        final Iterable<ProcessorExchangePair> pairs;
        final AsyncCallback callback;
        final Iterator<ProcessorExchangePair> iterator;
        final ReentrantLock lock;
        final AsyncCompletionService<Exchange> completion;
        final AtomicReference<Exchange> result;
        final AtomicInteger nbExchangeSent = new AtomicInteger();
        final AtomicInteger nbAggregated = new AtomicInteger();
        final AtomicBoolean allSent = new AtomicBoolean();
        final AtomicBoolean done = new AtomicBoolean();

        MulticastState(Exchange original, Iterable<ProcessorExchangePair> pairs, AsyncCallback callback) {
            this.original = original;
            this.pairs = pairs;
            this.callback = callback;
            this.iterator = pairs.iterator();
            this.lock = new ReentrantLock();
            this.completion = new AsyncCompletionService(MulticastProcessor.this::schedule, !MulticastProcessor.this.isStreaming(), this.lock);
            this.result = new AtomicReference();
            if (MulticastProcessor.this.timeout > 0L) {
                MulticastProcessor.this.schedule(MulticastProcessor.this.aggregateExecutorService, this::timeout, MulticastProcessor.this.timeout, TimeUnit.MILLISECONDS);
            }
        }

        public String toString() {
            return "Step[" + this.original.getExchangeId() + "," + (Object)((Object)MulticastProcessor.this) + "]";
        }

        @Override
        public void run() {
            try {
                if (this.done.get()) {
                    return;
                }
                if (!this.iterator.hasNext()) {
                    this.doDone(this.result.get(), true);
                    return;
                }
                ProcessorExchangePair pair = this.iterator.next();
                boolean hasNext = this.iterator.hasNext();
                if (pair == null && !hasNext) {
                    this.doDone(this.result.get(), true);
                    return;
                }
                Exchange exchange = pair.getExchange();
                int index = this.nbExchangeSent.getAndIncrement();
                MulticastProcessor.this.updateNewExchange(exchange, index, this.pairs, hasNext);
                if (hasNext) {
                    if (MulticastProcessor.this.isParallelProcessing()) {
                        MulticastProcessor.this.schedule(this);
                    }
                } else {
                    this.allSent.set(true);
                }
                this.completion.submit(exchangeResult -> {
                    StopWatch watch = MulticastProcessor.this.beforeSend(pair);
                    AsyncProcessor async = AsyncProcessorConverterHelper.convert((Processor)pair.getProcessor());
                    async.process(exchange, doneSync -> {
                        MulticastProcessor.this.afterSend(pair, watch);
                        boolean continueProcessing = PipelineHelper.continueProcessing(exchange, "Multicast processing failed for number " + index, MulticastProcessor.this.log);
                        if (MulticastProcessor.this.stopOnException && !continueProcessing) {
                            if (exchange.getException() != null) {
                                exchange.setException((Throwable)new CamelExchangeException("Multicast processing failed for number " + index, exchange, (Throwable)exchange.getException()));
                            } else {
                                this.result.set(exchange);
                            }
                            this.doDone(exchange, true);
                            return;
                        }
                        exchangeResult.accept(exchange);
                        this.aggregate();
                        if (hasNext && !MulticastProcessor.this.isParallelProcessing()) {
                            MulticastProcessor.this.schedule(this);
                        }
                    });
                });
            }
            catch (Exception e) {
                this.original.setException((Throwable)e);
                this.doDone(null, false);
            }
        }

        protected void aggregate() {
            ReentrantLock lock = this.lock;
            if (lock.tryLock()) {
                try {
                    Exchange exchange;
                    while (!this.done.get() && (exchange = (Exchange)this.completion.poll()) != null) {
                        MulticastProcessor.this.doAggregate(this.result, exchange);
                        if (this.nbAggregated.incrementAndGet() < this.nbExchangeSent.get() || !this.allSent.get()) continue;
                        this.doDone(this.result.get(), true);
                    }
                }
                catch (Throwable e) {
                    this.original.setException(e);
                    this.doDone(null, false);
                }
                finally {
                    lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void timeout() {
            ReentrantLock lock = this.lock;
            if (lock.tryLock()) {
                try {
                    while (this.nbAggregated.get() < this.nbExchangeSent.get()) {
                        int index;
                        Exchange exchange = (Exchange)this.completion.pollUnordered();
                        int n = index = exchange != null ? MulticastProcessor.this.getExchangeIndex(exchange).intValue() : this.nbExchangeSent.get();
                        while (this.nbAggregated.get() < index) {
                            AggregationStrategy strategy = MulticastProcessor.this.getAggregationStrategy(null);
                            strategy.timeout(this.result.get() != null ? this.result.get() : this.original, this.nbAggregated.getAndIncrement(), this.nbExchangeSent.get(), MulticastProcessor.this.timeout);
                        }
                        if (exchange == null) continue;
                        MulticastProcessor.this.doAggregate(this.result, exchange);
                        this.nbAggregated.incrementAndGet();
                    }
                    this.doDone(this.result.get(), true);
                }
                catch (Throwable e) {
                    this.original.setException(e);
                    this.doDone(null, false);
                }
                finally {
                    lock.unlock();
                }
            }
        }

        protected void doDone(Exchange exchange, boolean forceExhaust) {
            if (this.done.compareAndSet(false, true)) {
                MulticastProcessor.this.doDone(this.original, exchange, this.pairs, this.callback, false, forceExhaust);
            }
        }
    }

    static final class PreparedErrorHandler
    extends KeyValueHolder<RouteContext, Processor> {
        PreparedErrorHandler(RouteContext key, Processor value) {
            super((Object)key, (Object)value);
        }
    }

    static final class DefaultProcessorExchangePair
    implements ProcessorExchangePair {
        private final int index;
        private final Processor processor;
        private final Processor prepared;
        private final Exchange exchange;

        private DefaultProcessorExchangePair(int index, Processor processor, Processor prepared, Exchange exchange) {
            this.index = index;
            this.processor = processor;
            this.prepared = prepared;
            this.exchange = exchange;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Exchange getExchange() {
            return this.exchange;
        }

        @Override
        public Producer getProducer() {
            if (this.processor instanceof Producer) {
                return (Producer)this.processor;
            }
            return null;
        }

        @Override
        public Processor getProcessor() {
            return this.prepared;
        }

        @Override
        public void begin() {
        }

        @Override
        public void done() {
        }
    }
}

