/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;

public final class PipelineHelper {
    private PipelineHelper() {
    }

    public static boolean continueProcessing(Exchange exchange, String message, Logger log) {
        boolean doStop;
        boolean exceptionHandled = ExchangeHelper.hasExceptionBeenHandledByErrorHandler((Exchange)exchange);
        if (exchange.isFailed() || exchange.isRollbackOnly() || exceptionHandled) {
            StringBuilder sb;
            Message msg;
            Message message2 = msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
            if (msg.isFault() && exchange.getException() != null) {
                sb = new StringBuilder();
                sb.append("Message exchange has failed: " + message + " for exchange: ").append(exchange);
                sb.append(" Warning: Both fault and exception exists on the exchange, its best practice to only set one of them.");
                sb.append(" Exception: ").append(exchange.getException());
                sb.append(" Fault: ").append(msg);
                if (exceptionHandled) {
                    sb.append(" Handled by the error handler.");
                }
                log.warn(sb.toString());
            }
            if (log.isDebugEnabled()) {
                sb = new StringBuilder();
                sb.append("Message exchange has failed: " + message + " for exchange: ").append(exchange);
                if (exchange.isRollbackOnly()) {
                    sb.append(" Marked as rollback only.");
                }
                if (exchange.getException() != null) {
                    sb.append(" Exception: ").append(exchange.getException());
                }
                if (msg.isFault()) {
                    sb.append(" Fault: ").append(msg);
                }
                if (exceptionHandled) {
                    sb.append(" Handled by the error handler.");
                }
                log.debug(sb.toString());
            }
            return false;
        }
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = ((Boolean)exchange.getContext().getTypeConverter().convertTo(Boolean.class, exchange, stop)).booleanValue())) {
            log.debug("ExchangeId: {} is marked to stop routing: {}", (Object)exchange.getExchangeId(), (Object)exchange);
            return false;
        }
        return true;
    }

    public static Exchange createNextExchange(Exchange previousExchange) {
        Exchange answer = previousExchange;
        if (answer.hasOut()) {
            answer.setIn(answer.getOut());
            answer.setOut(null);
        }
        return answer;
    }
}

