/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.PollingConsumer;
import org.apache.camel.impl.engine.DefaultConsumerCache;
import org.apache.camel.spi.ConsumerCache;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.BridgeExceptionHandlerToErrorHandler;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.EventDrivenPollingConsumer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;

public class PollEnricher
extends AsyncProcessorSupport
implements IdAware,
CamelContextAware {
    private CamelContext camelContext;
    private ConsumerCache consumerCache;
    private String id;
    private AggregationStrategy aggregationStrategy;
    private final Expression expression;
    private long timeout;
    private boolean aggregateOnException;
    private int cacheSize;
    private boolean ignoreInvalidEndpoint;

    public PollEnricher(Expression expression, long timeout) {
        this.expression = expression;
        this.timeout = timeout;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.consumerCache.getEndpointUtilizationStatistics();
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isAggregateOnException() {
        return this.aggregateOnException;
    }

    public void setAggregateOnException(boolean aggregateOnException) {
        this.aggregateOnException = aggregateOnException;
    }

    public void setDefaultAggregationStrategy() {
        this.aggregationStrategy = PollEnricher.defaultAggregationStrategy();
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exchange resourceExchange;
        ExceptionHandler handler;
        PollingConsumer consumer;
        Endpoint endpoint;
        try {
            this.preCheckPoll(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)new CamelExchangeException("Error during pre poll check", exchange, (Throwable)e));
            callback.done(true);
            return true;
        }
        Object recipient = null;
        try {
            recipient = this.expression.evaluate(exchange, Object.class);
            endpoint = this.resolveEndpoint(exchange, recipient);
            consumer = this.consumerCache.acquirePollingConsumer(endpoint);
        }
        catch (Throwable e) {
            if (this.isIgnoreInvalidEndpoint()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Endpoint uri is invalid: " + recipient + ". This exception will be ignored.", e);
                }
            } else {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        PollingConsumer delegate = consumer;
        if (consumer instanceof EventDrivenPollingConsumer) {
            delegate = ((EventDrivenPollingConsumer)consumer).getDelegateConsumer();
        }
        boolean bridgeErrorHandler = false;
        if (delegate instanceof DefaultConsumer && (handler = ((DefaultConsumer)delegate).getExceptionHandler()) instanceof BridgeExceptionHandlerToErrorHandler) {
            bridgeErrorHandler = true;
        }
        try {
            if (this.timeout < 0L) {
                this.log.debug("Consumer receive: {}", (Object)consumer);
                resourceExchange = consumer.receive();
            } else if (this.timeout == 0L) {
                this.log.debug("Consumer receiveNoWait: {}", (Object)consumer);
                resourceExchange = consumer.receiveNoWait();
            } else {
                this.log.debug("Consumer receive with timeout: {} ms. {}", (Object)this.timeout, (Object)consumer);
                resourceExchange = consumer.receive(this.timeout);
            }
            if (resourceExchange == null) {
                this.log.debug("Consumer received no exchange");
            } else {
                this.log.debug("Consumer received: {}", (Object)resourceExchange);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)new CamelExchangeException("Error during poll", exchange, (Throwable)e));
            callback.done(true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.consumerCache.releasePollingConsumer(endpoint, consumer);
        }
        Object redeliveried = exchange.getIn().getHeader("CamelRedelivered");
        Object redeliveryCounter = exchange.getIn().getHeader("CamelRedeliveryCounter");
        Object redeliveryMaxCounter = exchange.getIn().getHeader("CamelRedeliveryMaxCounter");
        Exception cause = null;
        if (resourceExchange != null && bridgeErrorHandler) {
            cause = resourceExchange.getException();
        }
        try {
            if (!this.isAggregateOnException() && resourceExchange != null && resourceExchange.isFailed()) {
                ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)resourceExchange);
            } else {
                PollEnricher.prepareResult(exchange);
                ExchangeHelper.prepareAggregation((Exchange)exchange, (Exchange)resourceExchange);
                Exchange aggregatedExchange = this.aggregationStrategy.aggregate(exchange, resourceExchange);
                if (aggregatedExchange != null) {
                    ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)aggregatedExchange);
                    if (resourceExchange != null) {
                        resourceExchange.handoverCompletions(exchange);
                    }
                }
            }
            if (cause != null) {
                exchange.setException((Throwable)cause);
                exchange.removeProperties("CamelRedeliveryExhausted");
                if (redeliveried != null) {
                    if (exchange.hasOut()) {
                        exchange.getOut().setHeader("CamelRedelivered", redeliveried);
                    } else {
                        exchange.getIn().setHeader("CamelRedelivered", redeliveried);
                    }
                }
                if (redeliveryCounter != null) {
                    if (exchange.hasOut()) {
                        exchange.getOut().setHeader("CamelRedeliveryCounter", redeliveryCounter);
                    } else {
                        exchange.getIn().setHeader("CamelRedeliveryCounter", redeliveryCounter);
                    }
                }
                if (redeliveryMaxCounter != null) {
                    if (exchange.hasOut()) {
                        exchange.getOut().setHeader("CamelRedeliveryMaxCounter", redeliveryMaxCounter);
                    } else {
                        exchange.getIn().setHeader("CamelRedeliveryMaxCounter", redeliveryMaxCounter);
                    }
                }
            }
            if (exchange.hasOut()) {
                exchange.getOut().setHeader("CamelToEndpoint", (Object)consumer.getEndpoint().getEndpointUri());
            } else {
                exchange.getIn().setHeader("CamelToEndpoint", (Object)consumer.getEndpoint().getEndpointUri());
            }
        }
        catch (Throwable e) {
            exchange.setException((Throwable)new CamelExchangeException("Error occurred during aggregation", exchange, e));
            callback.done(true);
            return true;
        }
        callback.done(true);
        return true;
    }

    protected Endpoint resolveEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        return ExchangeHelper.resolveEndpoint((Exchange)exchange, (Object)recipient);
    }

    protected void preCheckPoll(Exchange exchange) throws Exception {
    }

    private static void prepareResult(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
        }
    }

    private static AggregationStrategy defaultAggregationStrategy() {
        return new CopyAggregationStrategy();
    }

    public String toString() {
        return "PollEnrich[" + this.expression + "]";
    }

    protected void doStart() throws Exception {
        if (this.consumerCache == null) {
            this.consumerCache = new DefaultConsumerCache((Object)this, this.camelContext, this.cacheSize);
            this.log.debug("PollEnrich {} using ConsumerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
        }
        if (this.aggregationStrategy instanceof CamelContextAware) {
            ((CamelContextAware)this.aggregationStrategy).setCamelContext(this.camelContext);
        }
        ServiceHelper.startService((Object[])new Object[]{this.consumerCache, this.aggregationStrategy});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.aggregationStrategy, this.consumerCache});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.aggregationStrategy, this.consumerCache});
    }

    private static class CopyAggregationStrategy
    implements AggregationStrategy {
        private CopyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange != null) {
                ExchangeHelper.copyResultsPreservePattern((Exchange)oldExchange, (Exchange)newExchange);
            } else {
                oldExchange.getIn().setBody(null);
                oldExchange.setOut(null);
            }
            return oldExchange;
        }
    }
}

