/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.util.StopWatch;

public class Debug
implements InterceptStrategy {
    private final Debugger debugger;

    public Debug(Debugger debugger) {
        this.debugger = debugger;
    }

    public Processor wrapProcessorInInterceptors(CamelContext context, final NamedNode definition, final Processor target, Processor nextTarget) throws Exception {
        return new DelegateAsyncProcessor(target){

            public boolean process(final Exchange exchange, final AsyncCallback callback) {
                try {
                    Debug.this.debugger.beforeProcess(exchange, target, definition);
                }
                catch (Throwable e) {
                    exchange.setException(e);
                    callback.done(true);
                    return true;
                }
                final StopWatch watch = new StopWatch();
                return this.processor.process(exchange, new AsyncCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void done(boolean doneSync) {
                        long diff = watch.taken();
                        try {
                            Debug.this.debugger.afterProcess(exchange, (Processor)processor, definition, diff);
                        }
                        finally {
                            callback.done(doneSync);
                        }
                    }
                });
            }

            public String toString() {
                return "Debug[" + target + "]";
            }
        };
    }
}

