/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.spi.SubUnitOfWork;
import org.apache.camel.spi.SubUnitOfWorkCallback;

public class DefaultSubUnitOfWork
implements SubUnitOfWork,
SubUnitOfWorkCallback {
    private List<Exception> failedExceptions;
    private boolean failed;

    public void onExhausted(Exchange exchange) {
        if (exchange.getException() != null) {
            this.addFailedException(exchange.getException());
            this.failed = true;
        }
    }

    public void onDone(Exchange exchange) {
        if (exchange.getException() != null) {
            this.addFailedException(exchange.getException());
            this.failed = true;
        }
    }

    public boolean isFailed() {
        return this.failed;
    }

    public List<Exception> getExceptions() {
        return this.failedExceptions;
    }

    private void addFailedException(Exception exception) {
        if (this.failedExceptions == null) {
            this.failedExceptions = new ArrayList<Exception>();
        }
        if (!this.failedExceptions.contains(exception)) {
            this.failedExceptions.add(exception);
        }
    }
}

