/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public final class ShareUnitOfWorkAggregationStrategy
extends ServiceSupport
implements AggregationStrategy,
CamelContextAware {
    private final AggregationStrategy strategy;
    private CamelContext camelContext;

    public ShareUnitOfWorkAggregationStrategy(AggregationStrategy strategy) {
        this.strategy = strategy;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        if (this.strategy instanceof CamelContextAware) {
            ((CamelContextAware)this.strategy).setCamelContext(camelContext);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public AggregationStrategy getDelegate() {
        return this.strategy;
    }

    public boolean canPreComplete() {
        return this.strategy.canPreComplete();
    }

    public boolean preComplete(Exchange oldExchange, Exchange newExchange) {
        return this.strategy.preComplete(oldExchange, newExchange);
    }

    public void onCompletion(Exchange exchange) {
        this.strategy.onCompletion(exchange);
    }

    public void timeout(Exchange exchange, int index, int total, long timeout) {
        this.strategy.timeout(exchange, index, total, timeout);
    }

    public void onOptimisticLockFailure(Exchange oldExchange, Exchange newExchange) {
        this.strategy.onOptimisticLockFailure(oldExchange, newExchange);
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        Exchange answer = this.strategy.aggregate(oldExchange, newExchange);
        this.propagateFailure(answer, newExchange);
        return answer;
    }

    protected void propagateFailure(Exchange answer, Exchange newExchange) {
        boolean exceptionHandled = ExchangeHelper.hasExceptionBeenHandledByErrorHandler((Exchange)newExchange);
        if (newExchange.isFailed() || newExchange.isRollbackOnly() || exceptionHandled) {
            if (newExchange.getException() != null) {
                answer.setException((Throwable)newExchange.getException());
            }
            if (newExchange.getProperty("CamelExceptionCaught") != null) {
                answer.setProperty("CamelExceptionCaught", newExchange.getProperty("CamelExceptionCaught"));
            }
            if (newExchange.getProperty("CamelFailureEndpoint") != null) {
                answer.setProperty("CamelFailureEndpoint", newExchange.getProperty("CamelFailureEndpoint"));
            }
            if (newExchange.getProperty("CamelFailureRouteId") != null) {
                answer.setProperty("CamelFailureRouteId", newExchange.getProperty("CamelFailureRouteId"));
            }
            if (newExchange.getProperty("CamelErrorHandlerHandled") != null) {
                answer.setProperty("CamelErrorHandlerHandled", newExchange.getProperty("CamelErrorHandlerHandled"));
            }
            if (newExchange.getProperty("CamelFailureHandled") != null) {
                answer.setProperty("CamelFailureHandled", newExchange.getProperty("CamelFailureHandled"));
            }
        }
    }

    public String toString() {
        return "ShareUnitOfWorkAggregationStrategy";
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.strategy);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.strategy});
    }
}

