/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.Ordered;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.StatefulService;
import org.apache.camel.StreamCache;
import org.apache.camel.processor.interceptor.BacklogDebugger;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.processor.interceptor.DefaultBacklogTracerEventMessage;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelInternalProcessor
extends DelegateAsyncProcessor {
    private final List<CamelInternalProcessorAdvice<?>> advices = new ArrayList();

    public CamelInternalProcessor() {
    }

    public CamelInternalProcessor(Processor processor) {
        super(processor);
    }

    public void addAdvice(CamelInternalProcessorAdvice<?> advice) {
        this.advices.add(advice);
        this.advices.sort((Comparator<CamelInternalProcessorAdvice<?>>)OrderedComparator.get());
    }

    public <T> T getAdvice(Class<T> type) {
        for (CamelInternalProcessorAdvice<?> task : this.advices) {
            Object advice = CamelInternalProcessor.unwrap(task);
            if (!type.isInstance(advice)) continue;
            return type.cast(advice);
        }
        return null;
    }

    public boolean process(Exchange exchange, AsyncCallback originalCallback) {
        if (this.processor == null || !this.continueProcessing(exchange)) {
            originalCallback.done(true);
            return true;
        }
        Object[] states = new Object[this.advices.size()];
        for (int i = 0; i < this.advices.size(); ++i) {
            CamelInternalProcessorAdvice<?> task = this.advices.get(i);
            try {
                Object state;
                states[i] = state = task.before(exchange);
                continue;
            }
            catch (Throwable e) {
                exchange.setException(e);
                originalCallback.done(true);
                return true;
            }
        }
        AsyncCallback callback = doneSync -> {
            try {
                for (int i = this.advices.size() - 1; i >= 0; --i) {
                    CamelInternalProcessorAdvice<?> task = this.advices.get(i);
                    Object state = states[i];
                    try {
                        task.after(exchange, state);
                        continue;
                    }
                    catch (Throwable e) {
                        exchange.setException(e);
                    }
                }
            }
            finally {
                exchange.getContext().getReactiveExecutor().callback(originalCallback);
            }
        };
        if (exchange.isTransacted()) {
            if (this.log.isTraceEnabled()) {
                if (exchange.isTransacted()) {
                    this.log.trace("Transacted Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                } else {
                    this.log.trace("Synchronous UnitOfWork Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                }
            }
            try {
                this.processor.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        UnitOfWork uow = exchange.getUnitOfWork();
        AsyncCallback async = callback;
        if (uow != null) {
            async = uow.beforeProcess((Processor)this.processor, exchange, callback);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Processing exchange for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        this.processor.process(exchange, async);
        exchange.getContext().getReactiveExecutor().schedule(() -> {
            if (uow != null) {
                uow.afterProcess((Processor)this.processor, exchange, callback, false);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Exchange processed and is continued routed asynchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
            }
        }, "CamelInternalProcessor - UnitOfWork - afterProcess - " + this.processor + " - " + exchange.getExchangeId());
        return false;
    }

    public String toString() {
        return this.processor != null ? this.processor.toString() : super.toString();
    }

    private boolean continueProcessing(Exchange exchange) {
        boolean doStop;
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = ((Boolean)exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop)).booleanValue())) {
            this.log.debug("Exchange is marked to stop routing: {}", (Object)exchange);
            return false;
        }
        boolean forceShutdown = exchange.getContext().getShutdownStrategy().forceShutdown((Service)this);
        if (forceShutdown) {
            String msg = "Run not allowed as ShutdownStrategy is forcing shutting down, will reject executing exchange: " + exchange;
            this.log.debug(msg);
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException(msg));
            }
            return false;
        }
        return true;
    }

    public static <T> CamelInternalProcessorAdvice<T> wrap(ManagementInterceptStrategy.InstrumentationProcessor<T> instrumentationProcessor) {
        if (instrumentationProcessor instanceof CamelInternalProcessor) {
            return (CamelInternalProcessorAdvice)instrumentationProcessor;
        }
        return new CamelInternalProcessorAdviceWrapper<T>(instrumentationProcessor);
    }

    public static Object unwrap(CamelInternalProcessorAdvice<?> advice) {
        if (advice instanceof CamelInternalProcessorAdviceWrapper) {
            return ((CamelInternalProcessorAdviceWrapper)advice).unwrap();
        }
        return advice;
    }

    static class CamelInternalProcessorAdviceWrapper<T>
    implements CamelInternalProcessorAdvice<T>,
    Ordered {
        final ManagementInterceptStrategy.InstrumentationProcessor<T> instrumentationProcessor;

        public CamelInternalProcessorAdviceWrapper(ManagementInterceptStrategy.InstrumentationProcessor<T> instrumentationProcessor) {
            this.instrumentationProcessor = instrumentationProcessor;
        }

        ManagementInterceptStrategy.InstrumentationProcessor<T> unwrap() {
            return this.instrumentationProcessor;
        }

        public int getOrder() {
            return this.instrumentationProcessor.getOrder();
        }

        public T before(Exchange exchange) throws Exception {
            return (T)this.instrumentationProcessor.before(exchange);
        }

        public void after(Exchange exchange, T data) throws Exception {
            this.instrumentationProcessor.after(exchange, data);
        }
    }

    public static class TracingAdvice
    implements CamelInternalProcessorAdvice {
        private final Tracer tracer;
        private final NamedNode processorDefinition;
        private final NamedRoute routeDefinition;
        private final Synchronization tracingAfterRoute;
        private boolean added;

        public TracingAdvice(Tracer tracer, NamedNode processorDefinition, NamedRoute routeDefinition, boolean first) {
            this.tracer = tracer;
            this.processorDefinition = processorDefinition;
            this.routeDefinition = routeDefinition;
            this.tracingAfterRoute = routeDefinition != null ? new TracingAfterRoute(tracer, routeDefinition.getRouteId()) : null;
        }

        public Object before(Exchange exchange) throws Exception {
            boolean contains;
            if (!this.added && this.tracingAfterRoute != null && !(contains = exchange.getUnitOfWork().containsSynchronization(this.tracingAfterRoute))) {
                this.added = true;
                this.tracer.traceBeforeRoute(this.routeDefinition, exchange);
                exchange.addOnCompletion(this.tracingAfterRoute);
            }
            this.tracer.traceBeforeNode(this.processorDefinition, exchange);
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
            this.tracer.traceAfterNode(this.processorDefinition, exchange);
        }

        private static final class TracingAfterRoute
        extends SynchronizationAdapter {
            private final Tracer tracer;
            private final String routeId;

            private TracingAfterRoute(Tracer tracer, String routeId) {
                this.tracer = tracer;
                this.routeId = routeId;
            }

            public void onAfterRoute(Route route, Exchange exchange) {
                if (this.routeId.equals(route.getId())) {
                    this.tracer.traceAfterRoute(route, exchange);
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                    return false;
                }
                TracingAfterRoute that = (TracingAfterRoute)((Object)o);
                return this.routeId.equals(that.routeId);
            }

            public int hashCode() {
                return Objects.hash(this.routeId);
            }
        }
    }

    public static class DelayerAdvice
    implements CamelInternalProcessorAdvice {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final long delay;

        public DelayerAdvice(long delay) {
            this.delay = delay;
        }

        public Object before(Exchange exchange) throws Exception {
            try {
                this.log.trace("Sleeping for: {} millis", (Object)this.delay);
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                this.log.debug("Sleep interrupted");
                Thread.currentThread().interrupt();
                throw e;
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
        }
    }

    public static class StreamCachingAdvice
    implements CamelInternalProcessorAdvice<StreamCache>,
    Ordered {
        private final StreamCachingStrategy strategy;

        public StreamCachingAdvice(StreamCachingStrategy strategy) {
            this.strategy = strategy;
        }

        public StreamCache before(Exchange exchange) throws Exception {
            Object body = exchange.getIn().getBody();
            if (body == null) {
                return null;
            }
            if (body instanceof StreamCache) {
                StreamCache sc = (StreamCache)body;
                sc.reset();
                return sc;
            }
            StreamCache sc = this.strategy.cache(exchange);
            if (sc != null) {
                exchange.getIn().setBody((Object)sc);
            }
            return sc;
        }

        public void after(Exchange exchange, StreamCache sc) throws Exception {
            Object body = exchange.getMessage().getBody();
            if (body instanceof StreamCache) {
                ((StreamCache)body).reset();
            }
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }
    }

    public static class MessageHistoryAdvice
    implements CamelInternalProcessorAdvice<MessageHistory> {
        private final MessageHistoryFactory factory;
        private final NamedNode definition;
        private final String routeId;

        public MessageHistoryAdvice(MessageHistoryFactory factory, NamedNode definition) {
            this.factory = factory;
            this.definition = definition;
            this.routeId = CamelContextHelper.getRouteId((NamedNode)definition);
        }

        public MessageHistory before(Exchange exchange) throws Exception {
            MessageHistory history;
            UnitOfWork uow;
            String targetRouteId;
            LinkedList<MessageHistory> list = (LinkedList<MessageHistory>)exchange.getProperty("CamelMessageHistory", List.class);
            if (list == null) {
                list = new LinkedList<MessageHistory>();
                exchange.setProperty("CamelMessageHistory", list);
            }
            if ((targetRouteId = this.routeId) == null && (uow = exchange.getUnitOfWork()) != null && uow.getRouteContext() != null) {
                targetRouteId = uow.getRouteContext().getRouteId();
            }
            if ((history = this.factory.newMessageHistory(targetRouteId, this.definition, System.currentTimeMillis(), exchange)) != null) {
                list.add(history);
            }
            return history;
        }

        public void after(Exchange exchange, MessageHistory history) throws Exception {
            if (history != null) {
                history.nodeProcessingDone();
            }
        }
    }

    public static class ChildUnitOfWorkProcessorAdvice
    extends UnitOfWorkProcessorAdvice {
        private final UnitOfWork parent;

        public ChildUnitOfWorkProcessorAdvice(RouteContext routeContext, UnitOfWork parent) {
            super(routeContext);
            this.parent = parent;
        }

        @Override
        protected UnitOfWork createUnitOfWork(Exchange exchange) {
            return this.parent.createChildUnitOfWork(exchange);
        }
    }

    public static class UnitOfWorkProcessorAdvice
    implements CamelInternalProcessorAdvice<UnitOfWork> {
        private final RouteContext routeContext;
        private String routeId;

        public UnitOfWorkProcessorAdvice(RouteContext routeContext) {
            this.routeContext = routeContext;
            if (routeContext != null) {
                this.routeId = routeContext.getRouteId();
            }
        }

        public UnitOfWork before(Exchange exchange) throws Exception {
            UnitOfWork existing;
            if (this.routeContext != null && exchange.getFromRouteId() == null) {
                if (this.routeId == null) {
                    this.routeId = this.routeContext.getRouteId();
                }
                exchange.setFromRouteId(this.routeId);
            }
            UnitOfWork created = null;
            if (exchange.getUnitOfWork() == null) {
                created = this.createUnitOfWork(exchange);
                exchange.setUnitOfWork(created);
                created.start();
            }
            if (this.routeContext != null && (existing = exchange.getUnitOfWork()) != null) {
                existing.pushRouteContext(this.routeContext);
            }
            return created;
        }

        public void after(Exchange exchange, UnitOfWork uow) throws Exception {
            UnitOfWork existing = exchange.getUnitOfWork();
            if (uow != null) {
                UnitOfWorkHelper.doneUow((UnitOfWork)uow, (Exchange)exchange);
            }
            if (this.routeContext != null && existing != null) {
                existing.popRouteContext();
            }
        }

        protected UnitOfWork createUnitOfWork(Exchange exchange) {
            return ((ExtendedCamelContext)exchange.getContext().adapt(ExtendedCamelContext.class)).getUnitOfWorkFactory().createUnitOfWork(exchange);
        }
    }

    public static final class DebuggerAdvice
    implements CamelInternalProcessorAdvice<StopWatch>,
    Ordered {
        private final Debugger debugger;
        private final Processor target;
        private final NamedNode definition;

        public DebuggerAdvice(Debugger debugger, Processor target, NamedNode definition) {
            this.debugger = debugger;
            this.target = target;
            this.definition = definition;
        }

        public StopWatch before(Exchange exchange) throws Exception {
            this.debugger.beforeProcess(exchange, this.target, this.definition);
            return new StopWatch();
        }

        public void after(Exchange exchange, StopWatch stopWatch) throws Exception {
            this.debugger.afterProcess(exchange, this.target, this.definition, stopWatch.taken());
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }
    }

    public static final class BacklogDebuggerAdvice
    implements CamelInternalProcessorAdvice<StopWatch>,
    Ordered {
        private final BacklogDebugger backlogDebugger;
        private final Processor target;
        private final NamedNode definition;
        private final String nodeId;

        public BacklogDebuggerAdvice(BacklogDebugger backlogDebugger, Processor target, NamedNode definition) {
            this.backlogDebugger = backlogDebugger;
            this.target = target;
            this.definition = definition;
            this.nodeId = definition.getId();
        }

        public StopWatch before(Exchange exchange) throws Exception {
            if (this.backlogDebugger.isEnabled() && (this.backlogDebugger.hasBreakpoint(this.nodeId) || this.backlogDebugger.isSingleStepMode())) {
                StopWatch watch = new StopWatch();
                this.backlogDebugger.beforeProcess(exchange, this.target, this.definition);
                return watch;
            }
            return null;
        }

        public void after(Exchange exchange, StopWatch stopWatch) throws Exception {
            if (stopWatch != null) {
                this.backlogDebugger.afterProcess(exchange, this.target, this.definition, stopWatch.taken());
            }
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }
    }

    public static final class BacklogTracerAdvice
    implements CamelInternalProcessorAdvice,
    Ordered {
        private final BacklogTracer backlogTracer;
        private final NamedNode processorDefinition;
        private final NamedRoute routeDefinition;
        private final boolean first;

        public BacklogTracerAdvice(BacklogTracer backlogTracer, NamedNode processorDefinition, NamedRoute routeDefinition, boolean first) {
            this.backlogTracer = backlogTracer;
            this.processorDefinition = processorDefinition;
            this.routeDefinition = routeDefinition;
            this.first = first;
        }

        public Object before(Exchange exchange) throws Exception {
            if (this.backlogTracer.shouldTrace(this.processorDefinition, exchange)) {
                String routeId;
                Date timestamp = new Date();
                String toNode = this.processorDefinition.getId();
                String exchangeId = exchange.getExchangeId();
                String messageAsXml = MessageHelper.dumpAsXml((Message)exchange.getIn(), (boolean)true, (int)4, (boolean)this.backlogTracer.isBodyIncludeStreams(), (boolean)this.backlogTracer.isBodyIncludeFiles(), (int)this.backlogTracer.getBodyMaxChars());
                String string = routeId = this.routeDefinition != null ? this.routeDefinition.getRouteId() : null;
                if (this.first) {
                    Date created = (Date)exchange.getProperty("CamelCreatedTimestamp", (Object)timestamp, Date.class);
                    DefaultBacklogTracerEventMessage pseudo = new DefaultBacklogTracerEventMessage(this.backlogTracer.incrementTraceCounter(), created, routeId, null, exchangeId, messageAsXml);
                    this.backlogTracer.traceEvent(pseudo);
                }
                DefaultBacklogTracerEventMessage event = new DefaultBacklogTracerEventMessage(this.backlogTracer.incrementTraceCounter(), timestamp, routeId, toNode, exchangeId, messageAsXml);
                this.backlogTracer.traceEvent(event);
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
        }

        public int getOrder() {
            return 0x7FFFFFFE;
        }
    }

    public static class RoutePolicyAdvice
    implements CamelInternalProcessorAdvice {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final List<RoutePolicy> routePolicies;
        private Route route;

        public RoutePolicyAdvice(List<RoutePolicy> routePolicies) {
            this.routePolicies = routePolicies;
        }

        public void setRoute(Route route) {
            this.route = route;
        }

        boolean isRoutePolicyRunAllowed(RoutePolicy policy) {
            if (policy instanceof StatefulService) {
                StatefulService ss = (StatefulService)policy;
                return ss.isRunAllowed();
            }
            return true;
        }

        public Object before(Exchange exchange) throws Exception {
            for (RoutePolicy policy : this.routePolicies) {
                try {
                    if (!this.isRoutePolicyRunAllowed(policy)) continue;
                    policy.onExchangeBegin(this.route, exchange);
                }
                catch (Exception e) {
                    this.log.warn("Error occurred during onExchangeBegin on RoutePolicy: " + policy + ". This exception will be ignored", (Throwable)e);
                }
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
            if (RoutePolicyAdvice.isCamelStopping(exchange.getContext())) {
                return;
            }
            for (RoutePolicy policy : this.routePolicies) {
                try {
                    if (!this.isRoutePolicyRunAllowed(policy)) continue;
                    policy.onExchangeDone(this.route, exchange);
                }
                catch (Exception e) {
                    this.log.warn("Error occurred during onExchangeDone on RoutePolicy: " + policy + ". This exception will be ignored", (Throwable)e);
                }
            }
        }

        private static boolean isCamelStopping(CamelContext context) {
            if (context != null) {
                return context.isStopping() || context.isStopped();
            }
            return false;
        }
    }

    public static class RouteInflightRepositoryAdvice
    implements CamelInternalProcessorAdvice {
        private final InflightRepository inflightRepository;
        private final String id;

        public RouteInflightRepositoryAdvice(InflightRepository inflightRepository, String id) {
            this.inflightRepository = inflightRepository;
            this.id = id;
        }

        public Object before(Exchange exchange) throws Exception {
            this.inflightRepository.add(exchange, this.id);
            return null;
        }

        public void after(Exchange exchange, Object state) throws Exception {
            this.inflightRepository.remove(exchange, this.id);
        }
    }

    public static class RouteLifecycleAdvice
    implements CamelInternalProcessorAdvice<Object> {
        private Route route;

        public void setRoute(Route route) {
            this.route = route;
        }

        public Object before(Exchange exchange) throws Exception {
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow != null) {
                uow.beforeRoute(exchange, this.route);
            }
            return null;
        }

        public void after(Exchange exchange, Object object) throws Exception {
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow != null) {
                uow.afterRoute(exchange, this.route);
            }
        }
    }
}

