/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cmis;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.component.cmis.CMISConsumer;
import org.apache.camel.component.cmis.CMISHelper;
import org.apache.camel.component.cmis.RecursiveTreeWalker;
import org.apache.camel.component.cmis.SessionFactoryLocator;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.DocumentType;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class CMISSessionFacade {
    private static final Logger LOG = LoggerFactory.getLogger(CMISSessionFacade.class);
    private transient Session session;
    private final String url;
    @UriParam(defaultValue="100")
    private int pageSize = 100;
    @UriParam
    private int readCount;
    @UriParam
    private boolean readContent;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam
    private String repositoryId;
    @UriParam(label="consumer")
    private String query;

    public CMISSessionFacade(String url) {
        this.url = url;
    }

    void initSession() {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        parameter.put("org.apache.chemistry.opencmis.binding.atompub.url", this.url);
        parameter.put("org.apache.chemistry.opencmis.user", this.username);
        parameter.put("org.apache.chemistry.opencmis.password", this.password);
        if (this.repositoryId != null) {
            parameter.put("org.apache.chemistry.opencmis.session.repository.id", this.repositoryId);
            this.session = SessionFactoryLocator.getSessionFactory().createSession(parameter);
        } else {
            this.session = ((Repository)SessionFactoryLocator.getSessionFactory().getRepositories(parameter).get(0)).createSession();
        }
    }

    public int poll(CMISConsumer cmisConsumer) throws Exception {
        if (this.query != null) {
            return this.pollWithQuery(cmisConsumer);
        }
        return this.pollTree(cmisConsumer);
    }

    private int pollTree(CMISConsumer cmisConsumer) throws Exception {
        Folder rootFolder = this.session.getRootFolder();
        RecursiveTreeWalker treeWalker = new RecursiveTreeWalker(cmisConsumer, this.readContent, this.readCount, this.pageSize);
        return treeWalker.processFolderRecursively(rootFolder);
    }

    private int pollWithQuery(CMISConsumer cmisConsumer) throws Exception {
        int count = 0;
        int pageNumber = 0;
        boolean finished = false;
        ItemIterable<QueryResult> itemIterable = this.executeQuery(this.query);
        while (!finished) {
            ItemIterable currentPage = itemIterable.skipTo((long)count).getPage();
            LOG.debug("Processing page {}", (Object)pageNumber);
            for (QueryResult item : currentPage) {
                Map<String, Object> properties = CMISHelper.propertyDataToMap(item.getProperties());
                Object objectTypeId = item.getPropertyValueById("cmis:objectTypeId");
                InputStream inputStream = null;
                if (this.readContent && "cmis:document".equals(objectTypeId)) {
                    inputStream = this.getContentStreamFor(item);
                }
                cmisConsumer.sendExchangeWithPropsAndBody(properties, inputStream);
                if (++count != this.readCount) continue;
                finished = true;
                break;
            }
            ++pageNumber;
            if (currentPage.getHasMoreItems()) continue;
            finished = true;
        }
        return count;
    }

    public List<Map<String, Object>> retrieveResult(Boolean retrieveContent, Integer readSize, ItemIterable<QueryResult> itemIterable) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        boolean queryForContent = retrieveContent != null ? retrieveContent : this.readContent;
        int documentsToRead = readSize != null ? readSize : this.readCount;
        int count = 0;
        int pageNumber = 0;
        boolean finished = false;
        while (!finished) {
            ItemIterable currentPage = itemIterable.skipTo((long)count).getPage();
            LOG.debug("Processing page {}", (Object)pageNumber);
            for (QueryResult item : currentPage) {
                Map<String, Object> properties = CMISHelper.propertyDataToMap(item.getProperties());
                if (queryForContent) {
                    InputStream inputStream = this.getContentStreamFor(item);
                    properties.put("CamelCMISContent", inputStream);
                }
                result.add(properties);
                if (++count != documentsToRead) continue;
                finished = true;
                break;
            }
            ++pageNumber;
            if (currentPage.getHasMoreItems()) continue;
            finished = true;
        }
        return result;
    }

    public ItemIterable<QueryResult> executeQuery(String query) {
        OperationContext operationContext = this.session.createOperationContext();
        operationContext.setMaxItemsPerPage(this.pageSize);
        return this.session.query(query, false, operationContext);
    }

    public Document getDocument(QueryResult queryResult) {
        if ("cmis:document".equals(queryResult.getPropertyValueById("cmis:objectTypeId")) || "cmis:document".equals(queryResult.getPropertyValueById("cmis:baseTypeId"))) {
            String objectId = (String)queryResult.getPropertyById("cmis:objectId").getFirstValue();
            return (Document)this.session.getObject(objectId);
        }
        return null;
    }

    public InputStream getContentStreamFor(QueryResult item) {
        Document document = this.getDocument(item);
        if (document != null && document.getContentStream() != null) {
            return document.getContentStream().getStream();
        }
        return null;
    }

    public CmisObject getObjectByPath(String path) {
        return this.session.getObjectByPath(path);
    }

    public boolean isObjectTypeVersionable(String objectType) {
        if ("cmis:document".equals(this.getCMISTypeFor(objectType))) {
            ObjectType typeDefinition = this.session.getTypeDefinition(objectType);
            return ((DocumentType)typeDefinition).isVersionable();
        }
        return false;
    }

    public boolean supportsSecondaries() {
        if (this.session.getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            return false;
        }
        for (ObjectType type : this.session.getTypeChildren(null, false)) {
            if (!BaseTypeId.CMIS_SECONDARY.value().equals(type.getId())) continue;
            return true;
        }
        return false;
    }

    public ContentStream createContentStream(String fileName, byte[] buf, String mimeType) throws Exception {
        return buf != null ? this.session.getObjectFactory().createContentStream(fileName, (long)buf.length, mimeType, (InputStream)new ByteArrayInputStream(buf)) : null;
    }

    public String getCMISTypeFor(String customOrCMISType) {
        ObjectType objectBaseType = this.session.getTypeDefinition(customOrCMISType).getBaseType();
        return objectBaseType == null ? customOrCMISType : objectBaseType.getId();
    }

    public Set<String> getPropertiesFor(String objectType) {
        return this.session.getTypeDefinition(objectType).getPropertyDefinitions().keySet();
    }

    public OperationContext createOperationContext() {
        return this.session.createOperationContext();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setReadContent(boolean readContent) {
        this.readContent = readContent;
    }

    public void setReadCount(int readCount) {
        this.readCount = readCount;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

