/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamComponent;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamConfiguration;
import org.apache.camel.component.aws2.ddbstream.SequenceNumberProvider;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.dynamodb.model.ShardIteratorType;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;

public interface Aws2DdbstreamComponentBuilderFactory {
    public static Aws2DdbstreamComponentBuilder aws2Ddbstream() {
        return new Aws2DdbstreamComponentBuilderImpl();
    }

    public static class Aws2DdbstreamComponentBuilderImpl
    extends AbstractComponentBuilder<Ddb2StreamComponent>
    implements Aws2DdbstreamComponentBuilder {
        @Override
        protected Ddb2StreamComponent buildConcreteComponent() {
            return new Ddb2StreamComponent();
        }

        private Ddb2StreamConfiguration getOrCreateConfiguration(Ddb2StreamComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Ddb2StreamConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonDynamoDbStreamsClient": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setAmazonDynamoDbStreamsClient((DynamoDbStreamsClient)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((Ddb2StreamComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((Ddb2StreamComponent)component).setConfiguration((Ddb2StreamConfiguration)value);
                    return true;
                }
                case "iteratorType": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setIteratorType((ShardIteratorType)value);
                    return true;
                }
                case "maxResultsPerRequest": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setMaxResultsPerRequest(((Integer)value).intValue());
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setRegion((String)value);
                    return true;
                }
                case "sequenceNumberProvider": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setSequenceNumberProvider((SequenceNumberProvider)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "autowiredEnabled": {
                    ((Ddb2StreamComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Ddb2StreamComponent)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2DdbstreamComponentBuilder
    extends ComponentBuilder<Ddb2StreamComponent> {
        default public Aws2DdbstreamComponentBuilder amazonDynamoDbStreamsClient(DynamoDbStreamsClient amazonDynamoDbStreamsClient) {
            this.doSetProperty("amazonDynamoDbStreamsClient", amazonDynamoDbStreamsClient);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder configuration(Ddb2StreamConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder iteratorType(ShardIteratorType iteratorType) {
            this.doSetProperty("iteratorType", iteratorType);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder maxResultsPerRequest(int maxResultsPerRequest) {
            this.doSetProperty("maxResultsPerRequest", maxResultsPerRequest);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder sequenceNumberProvider(SequenceNumberProvider sequenceNumberProvider) {
            this.doSetProperty("sequenceNumberProvider", sequenceNumberProvider);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2DdbstreamComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

