/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.minio.MinioClient;
import io.minio.ServerSideEncryption;
import io.minio.ServerSideEncryptionCustomerKey;
import java.time.ZonedDateTime;
import okhttp3.OkHttpClient;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.minio.MinioComponent;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.component.minio.MinioOperations;

public interface MinioComponentBuilderFactory {
    public static MinioComponentBuilder minio() {
        return new MinioComponentBuilderImpl();
    }

    public static class MinioComponentBuilderImpl
    extends AbstractComponentBuilder<MinioComponent>
    implements MinioComponentBuilder {
        @Override
        protected MinioComponent buildConcreteComponent() {
            return new MinioComponent();
        }

        private MinioConfiguration getOrCreateConfiguration(MinioComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new MinioConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "autoCreateBucket": {
                    this.getOrCreateConfiguration((MinioComponent)component).setAutoCreateBucket(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((MinioComponent)component).setConfiguration((MinioConfiguration)value);
                    return true;
                }
                case "customHttpClient": {
                    this.getOrCreateConfiguration((MinioComponent)component).setCustomHttpClient((OkHttpClient)value);
                    return true;
                }
                case "endpoint": {
                    this.getOrCreateConfiguration((MinioComponent)component).setEndpoint((String)value);
                    return true;
                }
                case "minioClient": {
                    this.getOrCreateConfiguration((MinioComponent)component).setMinioClient((MinioClient)value);
                    return true;
                }
                case "objectLock": {
                    this.getOrCreateConfiguration((MinioComponent)component).setObjectLock(((Boolean)value).booleanValue());
                    return true;
                }
                case "policy": {
                    this.getOrCreateConfiguration((MinioComponent)component).setPolicy((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((MinioComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((MinioComponent)component).setRegion((String)value);
                    return true;
                }
                case "secure": {
                    this.getOrCreateConfiguration((MinioComponent)component).setSecure(((Boolean)value).booleanValue());
                    return true;
                }
                case "serverSideEncryption": {
                    this.getOrCreateConfiguration((MinioComponent)component).setServerSideEncryption((ServerSideEncryption)value);
                    return true;
                }
                case "serverSideEncryptionCustomerKey": {
                    this.getOrCreateConfiguration((MinioComponent)component).setServerSideEncryptionCustomerKey((ServerSideEncryptionCustomerKey)value);
                    return true;
                }
                case "autoCloseBody": {
                    this.getOrCreateConfiguration((MinioComponent)component).setAutoCloseBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((MinioComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "bypassGovernanceMode": {
                    this.getOrCreateConfiguration((MinioComponent)component).setBypassGovernanceMode(((Boolean)value).booleanValue());
                    return true;
                }
                case "deleteAfterRead": {
                    this.getOrCreateConfiguration((MinioComponent)component).setDeleteAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "delimiter": {
                    this.getOrCreateConfiguration((MinioComponent)component).setDelimiter((String)value);
                    return true;
                }
                case "destinationBucketName": {
                    this.getOrCreateConfiguration((MinioComponent)component).setDestinationBucketName((String)value);
                    return true;
                }
                case "destinationObjectName": {
                    this.getOrCreateConfiguration((MinioComponent)component).setDestinationObjectName((String)value);
                    return true;
                }
                case "includeBody": {
                    this.getOrCreateConfiguration((MinioComponent)component).setIncludeBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "includeFolders": {
                    this.getOrCreateConfiguration((MinioComponent)component).setIncludeFolders(((Boolean)value).booleanValue());
                    return true;
                }
                case "includeUserMetadata": {
                    this.getOrCreateConfiguration((MinioComponent)component).setIncludeUserMetadata(((Boolean)value).booleanValue());
                    return true;
                }
                case "includeVersions": {
                    this.getOrCreateConfiguration((MinioComponent)component).setIncludeVersions(((Boolean)value).booleanValue());
                    return true;
                }
                case "length": {
                    this.getOrCreateConfiguration((MinioComponent)component).setLength(((Long)value).longValue());
                    return true;
                }
                case "matchETag": {
                    this.getOrCreateConfiguration((MinioComponent)component).setMatchETag((String)value);
                    return true;
                }
                case "maxConnections": {
                    this.getOrCreateConfiguration((MinioComponent)component).setMaxConnections(((Integer)value).intValue());
                    return true;
                }
                case "maxMessagesPerPoll": {
                    this.getOrCreateConfiguration((MinioComponent)component).setMaxMessagesPerPoll(((Integer)value).intValue());
                    return true;
                }
                case "modifiedSince": {
                    this.getOrCreateConfiguration((MinioComponent)component).setModifiedSince((ZonedDateTime)value);
                    return true;
                }
                case "moveAfterRead": {
                    this.getOrCreateConfiguration((MinioComponent)component).setMoveAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "notMatchETag": {
                    this.getOrCreateConfiguration((MinioComponent)component).setNotMatchETag((String)value);
                    return true;
                }
                case "objectName": {
                    this.getOrCreateConfiguration((MinioComponent)component).setObjectName((String)value);
                    return true;
                }
                case "offset": {
                    this.getOrCreateConfiguration((MinioComponent)component).setOffset(((Long)value).longValue());
                    return true;
                }
                case "prefix": {
                    this.getOrCreateConfiguration((MinioComponent)component).setPrefix((String)value);
                    return true;
                }
                case "recursive": {
                    this.getOrCreateConfiguration((MinioComponent)component).setRecursive(((Boolean)value).booleanValue());
                    return true;
                }
                case "startAfter": {
                    this.getOrCreateConfiguration((MinioComponent)component).setStartAfter((String)value);
                    return true;
                }
                case "unModifiedSince": {
                    this.getOrCreateConfiguration((MinioComponent)component).setUnModifiedSince((ZonedDateTime)value);
                    return true;
                }
                case "useVersion1": {
                    this.getOrCreateConfiguration((MinioComponent)component).setUseVersion1(((Boolean)value).booleanValue());
                    return true;
                }
                case "versionId": {
                    this.getOrCreateConfiguration((MinioComponent)component).setVersionId((String)value);
                    return true;
                }
                case "deleteAfterWrite": {
                    this.getOrCreateConfiguration((MinioComponent)component).setDeleteAfterWrite(((Boolean)value).booleanValue());
                    return true;
                }
                case "keyName": {
                    this.getOrCreateConfiguration((MinioComponent)component).setKeyName((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MinioComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((MinioComponent)component).setOperation((MinioOperations)value);
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((MinioComponent)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "storageClass": {
                    this.getOrCreateConfiguration((MinioComponent)component).setStorageClass((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((MinioComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((MinioComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((MinioComponent)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface MinioComponentBuilder
    extends ComponentBuilder<MinioComponent> {
        default public MinioComponentBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public MinioComponentBuilder configuration(MinioConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public MinioComponentBuilder customHttpClient(OkHttpClient customHttpClient) {
            this.doSetProperty("customHttpClient", customHttpClient);
            return this;
        }

        default public MinioComponentBuilder endpoint(String endpoint) {
            this.doSetProperty("endpoint", endpoint);
            return this;
        }

        default public MinioComponentBuilder minioClient(MinioClient minioClient) {
            this.doSetProperty("minioClient", minioClient);
            return this;
        }

        default public MinioComponentBuilder objectLock(boolean objectLock) {
            this.doSetProperty("objectLock", objectLock);
            return this;
        }

        default public MinioComponentBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public MinioComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public MinioComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public MinioComponentBuilder secure(boolean secure) {
            this.doSetProperty("secure", secure);
            return this;
        }

        default public MinioComponentBuilder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.doSetProperty("serverSideEncryption", serverSideEncryption);
            return this;
        }

        default public MinioComponentBuilder serverSideEncryptionCustomerKey(ServerSideEncryptionCustomerKey serverSideEncryptionCustomerKey) {
            this.doSetProperty("serverSideEncryptionCustomerKey", serverSideEncryptionCustomerKey);
            return this;
        }

        default public MinioComponentBuilder autoCloseBody(boolean autoCloseBody) {
            this.doSetProperty("autoCloseBody", autoCloseBody);
            return this;
        }

        default public MinioComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public MinioComponentBuilder bypassGovernanceMode(boolean bypassGovernanceMode) {
            this.doSetProperty("bypassGovernanceMode", bypassGovernanceMode);
            return this;
        }

        default public MinioComponentBuilder deleteAfterRead(boolean deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public MinioComponentBuilder delimiter(String delimiter) {
            this.doSetProperty("delimiter", delimiter);
            return this;
        }

        default public MinioComponentBuilder destinationBucketName(String destinationBucketName) {
            this.doSetProperty("destinationBucketName", destinationBucketName);
            return this;
        }

        default public MinioComponentBuilder destinationObjectName(String destinationObjectName) {
            this.doSetProperty("destinationObjectName", destinationObjectName);
            return this;
        }

        default public MinioComponentBuilder includeBody(boolean includeBody) {
            this.doSetProperty("includeBody", includeBody);
            return this;
        }

        default public MinioComponentBuilder includeFolders(boolean includeFolders) {
            this.doSetProperty("includeFolders", includeFolders);
            return this;
        }

        default public MinioComponentBuilder includeUserMetadata(boolean includeUserMetadata) {
            this.doSetProperty("includeUserMetadata", includeUserMetadata);
            return this;
        }

        default public MinioComponentBuilder includeVersions(boolean includeVersions) {
            this.doSetProperty("includeVersions", includeVersions);
            return this;
        }

        default public MinioComponentBuilder length(long length) {
            this.doSetProperty("length", length);
            return this;
        }

        default public MinioComponentBuilder matchETag(String matchETag) {
            this.doSetProperty("matchETag", matchETag);
            return this;
        }

        default public MinioComponentBuilder maxConnections(int maxConnections) {
            this.doSetProperty("maxConnections", maxConnections);
            return this;
        }

        default public MinioComponentBuilder maxMessagesPerPoll(int maxMessagesPerPoll) {
            this.doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }

        default public MinioComponentBuilder modifiedSince(ZonedDateTime modifiedSince) {
            this.doSetProperty("modifiedSince", modifiedSince);
            return this;
        }

        default public MinioComponentBuilder moveAfterRead(boolean moveAfterRead) {
            this.doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }

        default public MinioComponentBuilder notMatchETag(String notMatchETag) {
            this.doSetProperty("notMatchETag", notMatchETag);
            return this;
        }

        default public MinioComponentBuilder objectName(String objectName) {
            this.doSetProperty("objectName", objectName);
            return this;
        }

        default public MinioComponentBuilder offset(long offset) {
            this.doSetProperty("offset", offset);
            return this;
        }

        default public MinioComponentBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public MinioComponentBuilder recursive(boolean recursive) {
            this.doSetProperty("recursive", recursive);
            return this;
        }

        default public MinioComponentBuilder startAfter(String startAfter) {
            this.doSetProperty("startAfter", startAfter);
            return this;
        }

        default public MinioComponentBuilder unModifiedSince(ZonedDateTime unModifiedSince) {
            this.doSetProperty("unModifiedSince", unModifiedSince);
            return this;
        }

        default public MinioComponentBuilder useVersion1(boolean useVersion1) {
            this.doSetProperty("useVersion1", useVersion1);
            return this;
        }

        default public MinioComponentBuilder versionId(String versionId) {
            this.doSetProperty("versionId", versionId);
            return this;
        }

        default public MinioComponentBuilder deleteAfterWrite(boolean deleteAfterWrite) {
            this.doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }

        default public MinioComponentBuilder keyName(String keyName) {
            this.doSetProperty("keyName", keyName);
            return this;
        }

        default public MinioComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public MinioComponentBuilder operation(MinioOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public MinioComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public MinioComponentBuilder storageClass(String storageClass) {
            this.doSetProperty("storageClass", storageClass);
            return this;
        }

        default public MinioComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public MinioComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public MinioComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

