/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.connector.db2.Db2Connector;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class Db2ConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,db2";
    @UriParam(label="consumer,db2")
    private String messageKeyColumns;
    @UriParam(label="consumer,db2", defaultValue="0")
    private int queryFetchSize = 0;
    @UriParam(label="consumer,db2")
    private String columnBlacklist;
    @UriParam(label="consumer,db2")
    private String tableBlacklist;
    @UriParam(label="consumer,db2", defaultValue="true")
    private boolean includeSchemaChanges = true;
    @UriParam(label="consumer,db2", defaultValue="500ms", javaType="java.time.Duration")
    private long pollIntervalMs = 500L;
    @UriParam(label="consumer,db2", defaultValue="100ms", javaType="java.time.Duration")
    private int databaseHistoryKafkaRecoveryPollIntervalMs = 100;
    @UriParam(label="consumer,db2")
    private String signalDataCollection;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean databaseHistoryStoreOnlyCapturedTablesDdl = false;
    @UriParam(label="consumer,db2")
    private String converters;
    @UriParam(label="consumer,db2", defaultValue="__debezium-heartbeat")
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    @UriParam(label="consumer,db2")
    private int snapshotFetchSize;
    @UriParam(label="consumer,db2", defaultValue="10s", javaType="java.time.Duration")
    private long snapshotLockTimeoutMs = 10000L;
    @UriParam(label="consumer,db2", defaultValue="3s", javaType="java.time.Duration")
    private long databaseHistoryKafkaQueryTimeoutMs = 3000L;
    @UriParam(label="consumer,db2")
    private String databaseUser;
    @UriParam(label="consumer,db2")
    private String databaseDbname;
    @UriParam(label="consumer,db2")
    private String datatypePropagateSourceType;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean sanitizeFieldNames = false;
    @UriParam(label="consumer,db2")
    private String snapshotSelectStatementOverrides;
    @UriParam(label="consumer,db2")
    private String databaseHistoryKafkaBootstrapServers;
    @UriParam(label="consumer,db2", defaultValue="v2")
    private String sourceStructVersion = "v2";
    @UriParam(label="consumer,db2", defaultValue="0ms", javaType="java.time.Duration")
    private int heartbeatIntervalMs = 0;
    @UriParam(label="consumer,db2")
    private String columnWhitelist;
    @UriParam(label="consumer,db2")
    private String columnIncludeList;
    @UriParam(label="consumer,db2")
    private String columnPropagateSourceType;
    @UriParam(label="consumer,db2")
    private String tableExcludeList;
    @UriParam(label="consumer,db2")
    @Metadata(required=true)
    private String databasePassword;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean databaseHistoryStoreOnlyMonitoredTablesDdl = false;
    @UriParam(label="consumer,db2", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,db2")
    private String skippedOperations;
    @UriParam(label="consumer,db2", defaultValue="initial")
    private String snapshotMode = "initial";
    @UriParam(label="consumer,db2", defaultValue="io.debezium.relational.history.KafkaDatabaseHistory")
    private String databaseHistory = "io.debezium.relational.history.KafkaDatabaseHistory";
    @UriParam(label="consumer,db2", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,db2", defaultValue="1024")
    private int incrementalSnapshotChunkSize = 1024;
    @UriParam(label="consumer,db2")
    private String databaseHistoryKafkaTopic;
    @UriParam(label="consumer,db2", defaultValue="10s", javaType="java.time.Duration")
    private long retriableRestartConnectorWaitMs = 10000L;
    @UriParam(label="consumer,db2", defaultValue="0ms", javaType="java.time.Duration")
    private long snapshotDelayMs = 0L;
    @UriParam(label="consumer,db2", defaultValue="100")
    private int databaseHistoryKafkaRecoveryAttempts = 100;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean provideTransactionMetadata = false;
    @UriParam(label="consumer,db2")
    private String tableWhitelist;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean tombstonesOnDelete = false;
    @UriParam(label="consumer,db2", defaultValue="precise")
    private String decimalHandlingMode = "precise";
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean databaseHistorySkipUnparseableDdl = false;
    @UriParam(label="consumer,db2", defaultValue="true")
    private boolean tableIgnoreBuiltin = true;
    @UriParam(label="consumer,db2")
    private String snapshotIncludeCollectionList;
    @UriParam(label="consumer,db2")
    private String databaseHistoryFileFilename;
    @UriParam(label="consumer,db2", defaultValue="0")
    private long maxQueueSizeInBytes = 0L;
    @UriParam(label="consumer,db2", defaultValue="${database.server.name}.transaction")
    private String transactionTopic = "${database.server.name}.transaction";
    @UriParam(label="consumer,db2", defaultValue="adaptive")
    private String timePrecisionMode = "adaptive";
    @UriParam(label="consumer,db2")
    @Metadata(required=true)
    private String databaseServerName;
    @UriParam(label="consumer,db2", defaultValue="fail")
    private String eventProcessingFailureHandlingMode = "fail";
    @UriParam(label="consumer,db2", defaultValue="50000")
    private int databasePort = 50000;
    @UriParam(label="consumer,db2")
    private String columnExcludeList;
    @UriParam(label="consumer,db2")
    private String databaseHostname;
    @UriParam(label="consumer,db2", defaultValue="avro")
    private String schemaNameAdjustmentMode = "avro";
    @UriParam(label="consumer,db2")
    private String tableIncludeList;

    public void setMessageKeyColumns(String messageKeyColumns) {
        this.messageKeyColumns = messageKeyColumns;
    }

    public String getMessageKeyColumns() {
        return this.messageKeyColumns;
    }

    public void setQueryFetchSize(int queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setColumnBlacklist(String columnBlacklist) {
        this.columnBlacklist = columnBlacklist;
    }

    public String getColumnBlacklist() {
        return this.columnBlacklist;
    }

    public void setTableBlacklist(String tableBlacklist) {
        this.tableBlacklist = tableBlacklist;
    }

    public String getTableBlacklist() {
        return this.tableBlacklist;
    }

    public void setIncludeSchemaChanges(boolean includeSchemaChanges) {
        this.includeSchemaChanges = includeSchemaChanges;
    }

    public boolean isIncludeSchemaChanges() {
        return this.includeSchemaChanges;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setDatabaseHistoryKafkaRecoveryPollIntervalMs(int databaseHistoryKafkaRecoveryPollIntervalMs) {
        this.databaseHistoryKafkaRecoveryPollIntervalMs = databaseHistoryKafkaRecoveryPollIntervalMs;
    }

    public int getDatabaseHistoryKafkaRecoveryPollIntervalMs() {
        return this.databaseHistoryKafkaRecoveryPollIntervalMs;
    }

    public void setSignalDataCollection(String signalDataCollection) {
        this.signalDataCollection = signalDataCollection;
    }

    public String getSignalDataCollection() {
        return this.signalDataCollection;
    }

    public void setDatabaseHistoryStoreOnlyCapturedTablesDdl(boolean databaseHistoryStoreOnlyCapturedTablesDdl) {
        this.databaseHistoryStoreOnlyCapturedTablesDdl = databaseHistoryStoreOnlyCapturedTablesDdl;
    }

    public boolean isDatabaseHistoryStoreOnlyCapturedTablesDdl() {
        return this.databaseHistoryStoreOnlyCapturedTablesDdl;
    }

    public void setConverters(String converters) {
        this.converters = converters;
    }

    public String getConverters() {
        return this.converters;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public void setSnapshotFetchSize(int snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public void setSnapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
        this.snapshotLockTimeoutMs = snapshotLockTimeoutMs;
    }

    public long getSnapshotLockTimeoutMs() {
        return this.snapshotLockTimeoutMs;
    }

    public void setDatabaseHistoryKafkaQueryTimeoutMs(long databaseHistoryKafkaQueryTimeoutMs) {
        this.databaseHistoryKafkaQueryTimeoutMs = databaseHistoryKafkaQueryTimeoutMs;
    }

    public long getDatabaseHistoryKafkaQueryTimeoutMs() {
        return this.databaseHistoryKafkaQueryTimeoutMs;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseDbname(String databaseDbname) {
        this.databaseDbname = databaseDbname;
    }

    public String getDatabaseDbname() {
        return this.databaseDbname;
    }

    public void setDatatypePropagateSourceType(String datatypePropagateSourceType) {
        this.datatypePropagateSourceType = datatypePropagateSourceType;
    }

    public String getDatatypePropagateSourceType() {
        return this.datatypePropagateSourceType;
    }

    public void setSanitizeFieldNames(boolean sanitizeFieldNames) {
        this.sanitizeFieldNames = sanitizeFieldNames;
    }

    public boolean isSanitizeFieldNames() {
        return this.sanitizeFieldNames;
    }

    public void setSnapshotSelectStatementOverrides(String snapshotSelectStatementOverrides) {
        this.snapshotSelectStatementOverrides = snapshotSelectStatementOverrides;
    }

    public String getSnapshotSelectStatementOverrides() {
        return this.snapshotSelectStatementOverrides;
    }

    public void setDatabaseHistoryKafkaBootstrapServers(String databaseHistoryKafkaBootstrapServers) {
        this.databaseHistoryKafkaBootstrapServers = databaseHistoryKafkaBootstrapServers;
    }

    public String getDatabaseHistoryKafkaBootstrapServers() {
        return this.databaseHistoryKafkaBootstrapServers;
    }

    public void setSourceStructVersion(String sourceStructVersion) {
        this.sourceStructVersion = sourceStructVersion;
    }

    public String getSourceStructVersion() {
        return this.sourceStructVersion;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setColumnWhitelist(String columnWhitelist) {
        this.columnWhitelist = columnWhitelist;
    }

    public String getColumnWhitelist() {
        return this.columnWhitelist;
    }

    public void setColumnIncludeList(String columnIncludeList) {
        this.columnIncludeList = columnIncludeList;
    }

    public String getColumnIncludeList() {
        return this.columnIncludeList;
    }

    public void setColumnPropagateSourceType(String columnPropagateSourceType) {
        this.columnPropagateSourceType = columnPropagateSourceType;
    }

    public String getColumnPropagateSourceType() {
        return this.columnPropagateSourceType;
    }

    public void setTableExcludeList(String tableExcludeList) {
        this.tableExcludeList = tableExcludeList;
    }

    public String getTableExcludeList() {
        return this.tableExcludeList;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabaseHistoryStoreOnlyMonitoredTablesDdl(boolean databaseHistoryStoreOnlyMonitoredTablesDdl) {
        this.databaseHistoryStoreOnlyMonitoredTablesDdl = databaseHistoryStoreOnlyMonitoredTablesDdl;
    }

    public boolean isDatabaseHistoryStoreOnlyMonitoredTablesDdl() {
        return this.databaseHistoryStoreOnlyMonitoredTablesDdl;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setSkippedOperations(String skippedOperations) {
        this.skippedOperations = skippedOperations;
    }

    public String getSkippedOperations() {
        return this.skippedOperations;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public void setDatabaseHistory(String databaseHistory) {
        this.databaseHistory = databaseHistory;
    }

    public String getDatabaseHistory() {
        return this.databaseHistory;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setIncrementalSnapshotChunkSize(int incrementalSnapshotChunkSize) {
        this.incrementalSnapshotChunkSize = incrementalSnapshotChunkSize;
    }

    public int getIncrementalSnapshotChunkSize() {
        return this.incrementalSnapshotChunkSize;
    }

    public void setDatabaseHistoryKafkaTopic(String databaseHistoryKafkaTopic) {
        this.databaseHistoryKafkaTopic = databaseHistoryKafkaTopic;
    }

    public String getDatabaseHistoryKafkaTopic() {
        return this.databaseHistoryKafkaTopic;
    }

    public void setRetriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
        this.retriableRestartConnectorWaitMs = retriableRestartConnectorWaitMs;
    }

    public long getRetriableRestartConnectorWaitMs() {
        return this.retriableRestartConnectorWaitMs;
    }

    public void setSnapshotDelayMs(long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public long getSnapshotDelayMs() {
        return this.snapshotDelayMs;
    }

    public void setDatabaseHistoryKafkaRecoveryAttempts(int databaseHistoryKafkaRecoveryAttempts) {
        this.databaseHistoryKafkaRecoveryAttempts = databaseHistoryKafkaRecoveryAttempts;
    }

    public int getDatabaseHistoryKafkaRecoveryAttempts() {
        return this.databaseHistoryKafkaRecoveryAttempts;
    }

    public void setProvideTransactionMetadata(boolean provideTransactionMetadata) {
        this.provideTransactionMetadata = provideTransactionMetadata;
    }

    public boolean isProvideTransactionMetadata() {
        return this.provideTransactionMetadata;
    }

    public void setTableWhitelist(String tableWhitelist) {
        this.tableWhitelist = tableWhitelist;
    }

    public String getTableWhitelist() {
        return this.tableWhitelist;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public boolean isTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setDecimalHandlingMode(String decimalHandlingMode) {
        this.decimalHandlingMode = decimalHandlingMode;
    }

    public String getDecimalHandlingMode() {
        return this.decimalHandlingMode;
    }

    public void setDatabaseHistorySkipUnparseableDdl(boolean databaseHistorySkipUnparseableDdl) {
        this.databaseHistorySkipUnparseableDdl = databaseHistorySkipUnparseableDdl;
    }

    public boolean isDatabaseHistorySkipUnparseableDdl() {
        return this.databaseHistorySkipUnparseableDdl;
    }

    public void setTableIgnoreBuiltin(boolean tableIgnoreBuiltin) {
        this.tableIgnoreBuiltin = tableIgnoreBuiltin;
    }

    public boolean isTableIgnoreBuiltin() {
        return this.tableIgnoreBuiltin;
    }

    public void setSnapshotIncludeCollectionList(String snapshotIncludeCollectionList) {
        this.snapshotIncludeCollectionList = snapshotIncludeCollectionList;
    }

    public String getSnapshotIncludeCollectionList() {
        return this.snapshotIncludeCollectionList;
    }

    public void setDatabaseHistoryFileFilename(String databaseHistoryFileFilename) {
        this.databaseHistoryFileFilename = databaseHistoryFileFilename;
    }

    public String getDatabaseHistoryFileFilename() {
        return this.databaseHistoryFileFilename;
    }

    public void setMaxQueueSizeInBytes(long maxQueueSizeInBytes) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
    }

    public long getMaxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public void setTransactionTopic(String transactionTopic) {
        this.transactionTopic = transactionTopic;
    }

    public String getTransactionTopic() {
        return this.transactionTopic;
    }

    public void setTimePrecisionMode(String timePrecisionMode) {
        this.timePrecisionMode = timePrecisionMode;
    }

    public String getTimePrecisionMode() {
        return this.timePrecisionMode;
    }

    public void setDatabaseServerName(String databaseServerName) {
        this.databaseServerName = databaseServerName;
    }

    public String getDatabaseServerName() {
        return this.databaseServerName;
    }

    public void setEventProcessingFailureHandlingMode(String eventProcessingFailureHandlingMode) {
        this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
    }

    public String getEventProcessingFailureHandlingMode() {
        return this.eventProcessingFailureHandlingMode;
    }

    public void setDatabasePort(int databasePort) {
        this.databasePort = databasePort;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public void setColumnExcludeList(String columnExcludeList) {
        this.columnExcludeList = columnExcludeList;
    }

    public String getColumnExcludeList() {
        return this.columnExcludeList;
    }

    public void setDatabaseHostname(String databaseHostname) {
        this.databaseHostname = databaseHostname;
    }

    public String getDatabaseHostname() {
        return this.databaseHostname;
    }

    public void setSchemaNameAdjustmentMode(String schemaNameAdjustmentMode) {
        this.schemaNameAdjustmentMode = schemaNameAdjustmentMode;
    }

    public String getSchemaNameAdjustmentMode() {
        return this.schemaNameAdjustmentMode;
    }

    public void setTableIncludeList(String tableIncludeList) {
        this.tableIncludeList = tableIncludeList;
    }

    public String getTableIncludeList() {
        return this.tableIncludeList;
    }

    protected Configuration createConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"message.key.columns", (Object)this.messageKeyColumns);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"query.fetch.size", (Object)this.queryFetchSize);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.blacklist", (Object)this.columnBlacklist);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.blacklist", (Object)this.tableBlacklist);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"include.schema.changes", (Object)this.includeSchemaChanges);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"poll.interval.ms", (Object)this.pollIntervalMs);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.recovery.poll.interval.ms", (Object)this.databaseHistoryKafkaRecoveryPollIntervalMs);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"signal.data.collection", (Object)this.signalDataCollection);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.store.only.captured.tables.ddl", (Object)this.databaseHistoryStoreOnlyCapturedTablesDdl);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"converters", (Object)this.converters);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.topics.prefix", (Object)this.heartbeatTopicsPrefix);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.fetch.size", (Object)this.snapshotFetchSize);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.lock.timeout.ms", (Object)this.snapshotLockTimeoutMs);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.query.timeout.ms", (Object)this.databaseHistoryKafkaQueryTimeoutMs);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.user", (Object)this.databaseUser);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.dbname", (Object)this.databaseDbname);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"datatype.propagate.source.type", (Object)this.datatypePropagateSourceType);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"sanitize.field.names", (Object)this.sanitizeFieldNames);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.select.statement.overrides", (Object)this.snapshotSelectStatementOverrides);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.bootstrap.servers", (Object)this.databaseHistoryKafkaBootstrapServers);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"source.struct.version", (Object)this.sourceStructVersion);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.interval.ms", (Object)this.heartbeatIntervalMs);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.whitelist", (Object)this.columnWhitelist);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.include.list", (Object)this.columnIncludeList);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.propagate.source.type", (Object)this.columnPropagateSourceType);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.exclude.list", (Object)this.tableExcludeList);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.password", (Object)this.databasePassword);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.store.only.monitored.tables.ddl", (Object)this.databaseHistoryStoreOnlyMonitoredTablesDdl);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.batch.size", (Object)this.maxBatchSize);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"skipped.operations", (Object)this.skippedOperations);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.mode", (Object)this.snapshotMode);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history", (Object)this.databaseHistory);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.queue.size", (Object)this.maxQueueSize);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"incremental.snapshot.chunk.size", (Object)this.incrementalSnapshotChunkSize);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.topic", (Object)this.databaseHistoryKafkaTopic);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"retriable.restart.connector.wait.ms", (Object)this.retriableRestartConnectorWaitMs);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.delay.ms", (Object)this.snapshotDelayMs);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.recovery.attempts", (Object)this.databaseHistoryKafkaRecoveryAttempts);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"provide.transaction.metadata", (Object)this.provideTransactionMetadata);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.whitelist", (Object)this.tableWhitelist);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"tombstones.on.delete", (Object)this.tombstonesOnDelete);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"decimal.handling.mode", (Object)this.decimalHandlingMode);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.skip.unparseable.ddl", (Object)this.databaseHistorySkipUnparseableDdl);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.ignore.builtin", (Object)this.tableIgnoreBuiltin);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.include.collection.list", (Object)this.snapshotIncludeCollectionList);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.file.filename", (Object)this.databaseHistoryFileFilename);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.queue.size.in.bytes", (Object)this.maxQueueSizeInBytes);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"transaction.topic", (Object)this.transactionTopic);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"time.precision.mode", (Object)this.timePrecisionMode);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.server.name", (Object)this.databaseServerName);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"event.processing.failure.handling.mode", (Object)this.eventProcessingFailureHandlingMode);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.port", (Object)this.databasePort);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.exclude.list", (Object)this.columnExcludeList);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.hostname", (Object)this.databaseHostname);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"schema.name.adjustment.mode", (Object)this.schemaNameAdjustmentMode);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.include.list", (Object)this.tableIncludeList);
        return configBuilder.build();
    }

    protected Class configureConnectorClass() {
        return Db2Connector.class;
    }

    protected ConfigurationValidation validateConnectorConfiguration() {
        if (Db2ConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet((Object)this.databasePassword)) {
            return ConfigurationValidation.notValid((String)"Required field 'databasePassword' must be set.");
        }
        if (Db2ConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet((Object)this.databaseServerName)) {
            return ConfigurationValidation.notValid((String)"Required field 'databaseServerName' must be set.");
        }
        return ConfigurationValidation.valid();
    }

    public String getConnectorDatabaseType() {
        return "db2";
    }
}

