/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gora;

import java.lang.reflect.InvocationTargetException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.gora.GoraConfiguration;
import org.apache.camel.component.gora.utils.GoraUtils;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.store.DataStore;

public class GoraConsumer
extends ScheduledPollConsumer {
    private final DataStore<Object, Persistent> dataStore;
    private final GoraConfiguration configuration;
    private Query query;
    private boolean firstRun;

    public GoraConsumer(Endpoint endpoint, Processor processor, GoraConfiguration configuration, DataStore<Object, Persistent> dataStore) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        super(endpoint, processor);
        this.configuration = configuration;
        this.dataStore = dataStore;
        this.query = GoraUtils.constractQueryFromConfiguration(this.dataStore, this.configuration);
    }

    protected int poll() throws Exception {
        Exchange exchange = this.createExchange(true);
        if (this.firstRun) {
            this.query.setStartTime(System.currentTimeMillis());
        } else {
            this.query.setStartTime(System.currentTimeMillis() - this.getDelay());
        }
        Result result = this.query.execute();
        this.getProcessor().process(exchange);
        return (int)result.getOffset();
    }
}

