/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.hdfs.HdfsCompressionCodec;
import org.apache.camel.component.hdfs.HdfsConstants;
import org.apache.camel.component.hdfs.HdfsFileSystemType;
import org.apache.camel.component.hdfs.HdfsFileType;
import org.apache.camel.component.hdfs.HdfsProducer;
import org.apache.camel.component.hdfs.HdfsWritableFactories;
import org.apache.camel.util.URISupport;
import org.apache.hadoop.io.SequenceFile;

public class HdfsConfiguration {
    private URI uri;
    private String hostName;
    private int port = 8020;
    private String path;
    private boolean overwrite = true;
    private boolean append;
    private int bufferSize = 4096;
    private short replication = (short)3;
    private long blockSize = 0x4000000L;
    private SequenceFile.CompressionType compressionType = HdfsConstants.DEFAULT_COMPRESSIONTYPE;
    private HdfsCompressionCodec compressionCodec = HdfsConstants.DEFAULT_CODEC;
    private HdfsFileType fileType = HdfsFileType.NORMAL_FILE;
    private HdfsFileSystemType fileSystemType = HdfsFileSystemType.HDFS;
    private HdfsWritableFactories.WritableType keyType = HdfsWritableFactories.WritableType.NULL;
    private HdfsWritableFactories.WritableType valueType = HdfsWritableFactories.WritableType.BYTES;
    private String openedSuffix = "opened";
    private String readSuffix = "read";
    private long initialDelay;
    private long delay = 1000L;
    private String pattern = "*";
    private int chunkSize = 4096;
    private int checkIdleInterval = 500;
    private List<HdfsProducer.SplitStrategy> splitStrategies;

    private Boolean getBoolean(Map hdfsSettings, String param, Boolean dflt) {
        if (hdfsSettings.containsKey(param)) {
            return Boolean.valueOf((String)hdfsSettings.get(param));
        }
        return dflt;
    }

    private Integer getInteger(Map hdfsSettings, String param, Integer dflt) {
        if (hdfsSettings.containsKey(param)) {
            return Integer.valueOf((String)hdfsSettings.get(param));
        }
        return dflt;
    }

    private Short getShort(Map hdfsSettings, String param, Short dflt) {
        if (hdfsSettings.containsKey(param)) {
            return Short.valueOf((String)hdfsSettings.get(param));
        }
        return dflt;
    }

    private Long getLong(Map hdfsSettings, String param, Long dflt) {
        if (hdfsSettings.containsKey(param)) {
            return Long.valueOf((String)hdfsSettings.get(param));
        }
        return dflt;
    }

    private HdfsFileType getFileType(Map hdfsSettings, String param, HdfsFileType dflt) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return HdfsFileType.valueOf(eit);
        }
        return dflt;
    }

    private HdfsFileSystemType getFileSystemType(Map hdfsSettings, String param, HdfsFileSystemType dflt) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return HdfsFileSystemType.valueOf(eit);
        }
        return dflt;
    }

    private HdfsWritableFactories.WritableType getWritableType(Map hdfsSettings, String param, HdfsWritableFactories.WritableType dflt) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return HdfsWritableFactories.WritableType.valueOf(eit);
        }
        return dflt;
    }

    private SequenceFile.CompressionType getCompressionType(Map hdfsSettings, String param, SequenceFile.CompressionType ct) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return SequenceFile.CompressionType.valueOf((String)eit);
        }
        return ct;
    }

    private HdfsCompressionCodec getCompressionCodec(Map hdfsSettings, String param, HdfsCompressionCodec cd) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return HdfsCompressionCodec.valueOf(eit);
        }
        return cd;
    }

    private String getString(Map hdfsSettings, String param, String dflt) {
        if (hdfsSettings.containsKey(param)) {
            return (String)hdfsSettings.get(param);
        }
        return dflt;
    }

    private List<HdfsProducer.SplitStrategy> getSplitStrategies(Map hdfsSettings) {
        ArrayList<HdfsProducer.SplitStrategy> strategies = new ArrayList<HdfsProducer.SplitStrategy>();
        for (Object obj : hdfsSettings.keySet()) {
            String[] strstrategies;
            String eit;
            String key = (String)obj;
            if (!"splitStrategy".equals(key) || (eit = (String)hdfsSettings.get(key)) == null) continue;
            for (String strstrategy : strstrategies = eit.split(",")) {
                String[] tokens = strstrategy.split(":");
                if (tokens.length != 2) {
                    throw new IllegalArgumentException("Wrong Split Strategy " + key + "=" + eit);
                }
                HdfsProducer.SplitStrategyType sst = HdfsProducer.SplitStrategyType.valueOf(tokens[0]);
                long ssv = Long.valueOf(tokens[1]);
                strategies.add(new HdfsProducer.SplitStrategy(sst, ssv));
            }
        }
        return strategies;
    }

    public void checkConsumerOptions() {
    }

    public void checkProducerOptions() {
        if (this.isAppend()) {
            if (this.getSplitStrategies().size() != 0) {
                throw new IllegalArgumentException("Split Strategies incompatible with append=true");
            }
            if (this.getFileType() != HdfsFileType.NORMAL_FILE) {
                throw new IllegalArgumentException("append=true works only with NORMAL_FILEs");
            }
        }
    }

    public void parseURI(URI uri) throws URISyntaxException {
        String protocol = uri.getScheme();
        if (!protocol.equalsIgnoreCase("hdfs")) {
            throw new IllegalArgumentException("Unrecognized Cache protocol: " + protocol + " for uri: " + uri);
        }
        this.hostName = uri.getHost();
        this.port = uri.getPort() == -1 ? 8020 : uri.getPort();
        this.path = uri.getPath();
        Map hdfsSettings = URISupport.parseParameters((URI)uri);
        this.overwrite = this.getBoolean(hdfsSettings, "overwrite", this.overwrite);
        this.append = this.getBoolean(hdfsSettings, "append", this.append);
        this.bufferSize = this.getInteger(hdfsSettings, "bufferSize", this.bufferSize);
        this.replication = this.getShort(hdfsSettings, "replication", this.replication);
        this.blockSize = this.getLong(hdfsSettings, "blockSize", this.blockSize);
        this.compressionType = this.getCompressionType(hdfsSettings, "compressionType", this.compressionType);
        this.compressionCodec = this.getCompressionCodec(hdfsSettings, "compressionCodec", this.compressionCodec);
        this.fileType = this.getFileType(hdfsSettings, "fileType", this.fileType);
        this.fileSystemType = this.getFileSystemType(hdfsSettings, "fileSystemType", this.fileSystemType);
        this.keyType = this.getWritableType(hdfsSettings, "keyType", this.keyType);
        this.valueType = this.getWritableType(hdfsSettings, "valueType", this.valueType);
        this.openedSuffix = this.getString(hdfsSettings, "openedSuffix", this.openedSuffix);
        this.readSuffix = this.getString(hdfsSettings, "readSuffix", this.readSuffix);
        this.initialDelay = this.getLong(hdfsSettings, "initialDelay", this.initialDelay);
        this.delay = this.getLong(hdfsSettings, "delay", this.delay);
        this.pattern = this.getString(hdfsSettings, "pattern", this.pattern);
        this.chunkSize = this.getInteger(hdfsSettings, "chunkSize", this.chunkSize);
        this.splitStrategies = this.getSplitStrategies(hdfsSettings);
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public short getReplication() {
        return this.replication;
    }

    public void setReplication(short replication) {
        this.replication = replication;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public HdfsFileType getFileType() {
        return this.fileType;
    }

    public void setFileType(HdfsFileType fileType) {
        this.fileType = fileType;
    }

    public SequenceFile.CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(SequenceFile.CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public HdfsCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public void setCompressionCodec(HdfsCompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public void setFileSystemType(HdfsFileSystemType fileSystemType) {
        this.fileSystemType = fileSystemType;
    }

    public HdfsFileSystemType getFileSystemType() {
        return this.fileSystemType;
    }

    public HdfsWritableFactories.WritableType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(HdfsWritableFactories.WritableType keyType) {
        this.keyType = keyType;
    }

    public HdfsWritableFactories.WritableType getValueType() {
        return this.valueType;
    }

    public void setValueType(HdfsWritableFactories.WritableType valueType) {
        this.valueType = valueType;
    }

    public void setOpenedSuffix(String openedSuffix) {
        this.openedSuffix = openedSuffix;
    }

    public String getOpenedSuffix() {
        return this.openedSuffix;
    }

    public void setReadSuffix(String readSuffix) {
        this.readSuffix = readSuffix;
    }

    public String getReadSuffix() {
        return this.readSuffix;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setCheckIdleInterval(int checkIdleInterval) {
        this.checkIdleInterval = checkIdleInterval;
    }

    public int getCheckIdleInterval() {
        return this.checkIdleInterval;
    }

    public List<HdfsProducer.SplitStrategy> getSplitStrategies() {
        return this.splitStrategies;
    }

    public void setSplitStrategy(String splitStrategy) {
    }
}

