/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.obs.models;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.util.ObjectHelper;

public final class OBSRegion {
    private static final Map<String, String> REGIONS = OBSRegion.createRegions();

    private OBSRegion() {
    }

    private static Map<String, String> createRegions() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("af-south-1", "obs.af-south-1.myhuaweicloud.com");
        map.put("ap-southeast-2", "obs.ap-southeast-2.myhuaweicloud.com");
        map.put("ap-southeast-3", "obs.ap-southeast-3.myhuaweicloud.com");
        map.put("cn-east-3", "obs.cn-east-3.myhuaweicloud.com");
        map.put("cn-east-2", "obs.cn-east-2.myhuaweicloud.com");
        map.put("cn-north-1", "obs.cn-north-1.myhuaweicloud.com");
        map.put("cn-south-1", "obs.cn-south-1.myhuaweicloud.com");
        map.put("ap-southeast-1", "obs.ap-southeast-1.myhuaweicloud.com");
        map.put("sa-argentina-1", "obs.sa-argentina-1.myhuaweicloud.com");
        map.put("sa-peru-1", "obs.sa-peru-1.myhuaweicloud.com");
        map.put("na-mexico-1", "obs.na-mexico-1.myhuaweicloud.com");
        map.put("la-south-2", "obs.la-south-2.myhuaweicloud.com");
        map.put("sa-chile-1", "obs.sa-chile-1.myhuaweicloud.com");
        map.put("sa-brazil-1", "obs.sa-brazil-1.myhuaweicloud.com");
        return map;
    }

    public static String valueOf(String regionId) {
        if (ObjectHelper.isEmpty((String)regionId)) {
            throw new IllegalArgumentException("Unexpected empty parameter: regionId.");
        }
        String endpoint = REGIONS.get(regionId.toLowerCase());
        if (ObjectHelper.isNotEmpty((String)endpoint)) {
            return endpoint;
        }
        throw new IllegalArgumentException("Unexpected regionId: " + regionId);
    }

    public static void checkValidRegion(String regionId) {
        if (ObjectHelper.isEmpty((String)regionId)) {
            throw new IllegalArgumentException("Unexpected empty parameter: regionId.");
        }
        if (ObjectHelper.isEmpty((String)REGIONS.get(regionId.toLowerCase()))) {
            throw new IllegalArgumentException("Unexpected regionId: " + regionId);
        }
    }
}

