/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ical;

import java.io.InputStream;
import java.io.OutputStream;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="ical")
public class ICalDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private boolean validating;
    private CalendarOutputter outputer;
    private CalendarBuilder builder;

    public String getDataFormatName() {
        return "ical";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        Calendar calendar = (Calendar)exchange.getContext().getTypeConverter().convertTo(Calendar.class, graph);
        this.outputer.output(calendar, stream);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.builder.build(stream);
    }

    protected void doStart() throws Exception {
        this.outputer = new CalendarOutputter(this.validating);
        this.builder = new CalendarBuilder();
    }

    protected void doStop() throws Exception {
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isValidating() {
        return this.validating;
    }
}

