/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import jakarta.xml.bind.annotation.XmlElementDecl;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;

public final class JaxbHelper {
    private JaxbHelper() {
    }

    public static <T> Method getJaxbElementFactoryMethod(CamelContext camelContext, Class<T> type) {
        if (camelContext == null) {
            return null;
        }
        Class<?> factory = JaxbHelper.getObjectFactory(camelContext, type);
        if (factory != null) {
            for (Method m : factory.getMethods()) {
                Class<?>[] parameters;
                XmlElementDecl a = m.getAnnotation(XmlElementDecl.class);
                if (a == null || (parameters = m.getParameterTypes()).length != 1 || !parameters[0].isAssignableFrom(type)) continue;
                return m;
            }
        }
        return null;
    }

    public static <T> Class<?> getObjectFactory(CamelContext camelContext, Class<T> type) {
        if (camelContext == null) {
            return null;
        }
        if (type.getPackage() != null) {
            String objectFactoryClassName = type.getPackage().getName() + ".ObjectFactory";
            return camelContext.getClassResolver().resolveClass(objectFactoryClassName);
        }
        return null;
    }
}

