/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups.raft;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jgroups.raft.JGroupsRaftConsumer;
import org.apache.camel.component.jgroups.raft.JGroupsRaftEndpoint;
import org.apache.camel.component.jgroups.raft.JGroupsRaftEventType;
import org.apache.camel.component.jgroups.raft.JGroupsRaftException;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelRoleChangeListener
implements RAFT.RoleChange {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelRoleChangeListener.class);
    private final JGroupsRaftConsumer consumer;
    private final JGroupsRaftEndpoint endpoint;
    private final AsyncProcessor processor;

    public CamelRoleChangeListener(JGroupsRaftConsumer consumer, JGroupsRaftEndpoint endpoint, Processor processor) {
        this.consumer = consumer;
        this.endpoint = endpoint;
        this.processor = AsyncProcessorConverterHelper.convert((Processor)processor);
    }

    public void roleChanged(Role role) {
        LOG.trace("New Role {} received.", (Object)role);
        Exchange exchange = this.createExchange();
        switch (role) {
            case Leader: {
                exchange.getIn().setHeader("JGROUPSRAFT_EVENT_TYPE", (Object)JGroupsRaftEventType.LEADER);
                this.processExchange(role, exchange);
                break;
            }
            case Follower: {
                exchange.getIn().setHeader("JGROUPSRAFT_EVENT_TYPE", (Object)JGroupsRaftEventType.FOLLOWER);
                this.processExchange(role, exchange);
                break;
            }
            case Candidate: {
                exchange.getIn().setHeader("JGROUPSRAFT_EVENT_TYPE", (Object)JGroupsRaftEventType.CANDIDATE);
                this.processExchange(role, exchange);
                break;
            }
            default: {
                throw new JGroupsRaftException("Role [" + role + "] unknown.");
            }
        }
    }

    private void processExchange(Role role, Exchange exchange) {
        try {
            LOG.debug("Processing Role: {}", (Object)role);
            this.processor.process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                }
            });
        }
        catch (Exception e) {
            throw new JGroupsRaftException("Error in consumer while dispatching exchange containing role " + role, e);
        }
    }

    private Exchange createExchange() {
        Exchange exchange = this.consumer.createExchange(true);
        this.endpoint.populateJGroupsRaftHeaders(exchange);
        return exchange;
    }
}

