/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.apache.camel.Attachment;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mail.AttachmentsContentTransferEncodingResolver;
import org.apache.camel.component.mail.ContentTypeResolver;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailMessage;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.DefaultAttachment;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailBinding {
    private static final Logger LOG = LoggerFactory.getLogger(MailBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;
    private ContentTypeResolver contentTypeResolver;

    public MailBinding() {
        this.headerFilterStrategy = new DefaultHeaderFilterStrategy();
    }

    public MailBinding(HeaderFilterStrategy headerFilterStrategy, ContentTypeResolver contentTypeResolver) {
        this.headerFilterStrategy = headerFilterStrategy;
        this.contentTypeResolver = contentTypeResolver;
    }

    public void populateMailMessage(MailEndpoint endpoint, MimeMessage mimeMessage, Exchange exchange) throws MessagingException, IOException {
        if (MailBinding.hasRecipientHeaders(exchange)) {
            this.setRecipientFromCamelMessage(mimeMessage, endpoint.getConfiguration(), exchange);
        } else {
            this.setRecipientFromEndpointConfiguration(mimeMessage, endpoint, exchange);
        }
        String replyTo = (String)exchange.getIn().getHeader("Reply-To", String.class);
        if (replyTo == null) {
            replyTo = endpoint.getConfiguration().getReplyTo();
        }
        if (replyTo != null) {
            ArrayList<InternetAddress> replyToAddresses = new ArrayList<InternetAddress>();
            for (String reply : MailBinding.splitRecipients(replyTo)) {
                replyToAddresses.add(MailBinding.asEncodedInternetAddress(reply.trim(), MailBinding.determineCharSet(endpoint.getConfiguration(), exchange)));
            }
            mimeMessage.setReplyTo((Address[])replyToAddresses.toArray(new InternetAddress[replyToAddresses.size()]));
        }
        if (mimeMessage.getAllRecipients() == null) {
            throw new IllegalArgumentException("The mail message does not have any recipients set.");
        }
        String subject = endpoint.getConfiguration().getSubject();
        if (subject != null) {
            mimeMessage.setSubject(subject, IOHelper.getCharsetName((Exchange)exchange, (boolean)false));
        }
        this.appendHeadersFromCamelMessage(mimeMessage, endpoint.getConfiguration(), exchange);
        if (MailBinding.empty(mimeMessage.getFrom())) {
            String from = endpoint.getConfiguration().getFrom();
            mimeMessage.setFrom((Address)MailBinding.asEncodedInternetAddress(from, MailBinding.determineCharSet(endpoint.getConfiguration(), exchange)));
        }
        if (MailBinding.hasAlternativeBody(endpoint.getConfiguration(), exchange)) {
            this.createMultipartAlternativeMessage(mimeMessage, endpoint.getConfiguration(), exchange);
        } else if (exchange.getIn().hasAttachments()) {
            this.appendAttachmentsFromCamel(mimeMessage, endpoint.getConfiguration(), exchange);
        } else {
            this.populateContentOnMimeMessage(mimeMessage, endpoint.getConfiguration(), exchange);
        }
    }

    protected String determineContentType(MailConfiguration configuration, Exchange exchange) {
        String contentType = configuration.getContentType();
        if (exchange.getIn().getHeader("contentType") != null) {
            contentType = (String)exchange.getIn().getHeader("contentType", String.class);
        } else if (exchange.getIn().getHeader("Content-Type") != null) {
            contentType = (String)exchange.getIn().getHeader("Content-Type", String.class);
        }
        if (contentType != null && contentType.contains(";")) {
            contentType = MailUtils.padContentType(contentType);
        }
        if (contentType != null) {
            String charset = MailBinding.determineCharSet(configuration, exchange);
            contentType = MailUtils.replaceCharSet(contentType, charset);
        }
        LOG.trace("Determined Content-Type: {}", (Object)contentType);
        return contentType;
    }

    protected static String determineCharSet(MailConfiguration configuration, Exchange exchange) {
        String contentType = configuration.getContentType();
        if (exchange.getIn().getHeader("contentType") != null) {
            contentType = (String)exchange.getIn().getHeader("contentType", String.class);
        } else if (exchange.getIn().getHeader("Content-Type") != null) {
            contentType = (String)exchange.getIn().getHeader("Content-Type", String.class);
        }
        String charset = MailUtils.getCharSetFromContentType(contentType);
        if (charset != null && (charset = IOHelper.normalizeCharset((String)charset)) != null) {
            boolean supported;
            try {
                supported = Charset.isSupported(charset);
            }
            catch (IllegalCharsetNameException e) {
                supported = false;
            }
            if (supported) {
                return charset;
            }
            if (!configuration.isIgnoreUnsupportedCharset()) {
                return charset;
            }
            if (configuration.isIgnoreUnsupportedCharset()) {
                LOG.warn("Charset: {} is not supported and cannot be used as charset in Content-Type header.", (Object)charset);
                return null;
            }
        }
        return IOHelper.getCharsetName((Exchange)exchange, (boolean)false);
    }

    protected String populateContentOnMimeMessage(MimeMessage part, MailConfiguration configuration, Exchange exchange) throws MessagingException, IOException {
        String contentType = this.determineContentType(configuration, exchange);
        LOG.trace("Using Content-Type {} for MimeMessage: {}", (Object)contentType, (Object)part);
        String body = (String)exchange.getIn().getBody(String.class);
        if (body == null) {
            body = "";
        }
        ByteArrayDataSource ds = new ByteArrayDataSource(body, contentType);
        part.setDataHandler(new DataHandler((DataSource)ds));
        part.setHeader("Content-Type", contentType);
        return contentType;
    }

    protected String populateContentOnBodyPart(BodyPart part, MailConfiguration configuration, Exchange exchange) throws MessagingException, IOException {
        String contentType = this.determineContentType(configuration, exchange);
        if (contentType != null) {
            LOG.trace("Using Content-Type {} for BodyPart: {}", (Object)contentType, (Object)part);
            String data = (String)exchange.getContext().getTypeConverter().tryConvertTo(String.class, exchange.getIn().getBody());
            data = data != null ? data : "";
            ByteArrayDataSource ds = new ByteArrayDataSource(data, contentType);
            part.setDataHandler(new DataHandler((DataSource)ds));
            part.setHeader("Content-Type", contentType);
        }
        return contentType;
    }

    public Object extractBodyFromMail(Exchange exchange, MailMessage mailMessage) {
        Message message = mailMessage.getMessage();
        try {
            if (((MailEndpoint)exchange.getFromEndpoint()).getConfiguration().isMapMailMessage()) {
                return message.getContent();
            }
            return message;
        }
        catch (Exception e) {
            UnsupportedEncodingException uee = (UnsupportedEncodingException)ObjectHelper.getException(UnsupportedEncodingException.class, (Throwable)e);
            if (uee != null) {
                LOG.debug("Unsupported encoding detected: {}", (Object)uee.getMessage());
                try {
                    String contentType = message.getContentType();
                    String type = ObjectHelper.before((String)contentType, (String)"charset=");
                    if (type != null) {
                        LOG.debug("Trying to extract mail message again with fixed Content-Type: {}", (Object)type);
                        MimeMessage messageCopy = new MimeMessage((MimeMessage)message);
                        messageCopy.setHeader("Content-Type", type);
                        Object body = messageCopy.getContent();
                        mailMessage.setMessage((Message)messageCopy);
                        return body;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RuntimeCamelException("Failed to extract body due to: " + e.getMessage() + ". Exchange: " + exchange + ". Message: " + message, (Throwable)e);
        }
    }

    public void extractAttachmentsFromMail(Message message, Map<String, Attachment> map) throws MessagingException, IOException {
        LOG.trace("Extracting attachments +++ start +++");
        Object content = message.getContent();
        if (content instanceof Multipart) {
            this.extractAttachmentsFromMultipart((Multipart)content, map);
        } else if (content != null) {
            LOG.trace("No attachments to extract as content is not Multipart: {}", (Object)content.getClass().getName());
        }
        LOG.trace("Extracting attachments +++ done +++");
    }

    protected void extractAttachmentsFromMultipart(Multipart mp, Map<String, Attachment> map) throws MessagingException, IOException {
        for (int i = 0; i < mp.getCount(); ++i) {
            BodyPart part = mp.getBodyPart(i);
            LOG.trace("Part #{}: {}", (Object)i, (Object)part);
            if (part.isMimeType("multipart/*")) {
                LOG.trace("Part #{}: is mimetype: multipart/*", (Object)i);
                this.extractAttachmentsFromMultipart((Multipart)part.getContent(), map);
                continue;
            }
            String disposition = part.getDisposition();
            String fileName = part.getFileName();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Part #{}: Disposition: {}", (Object)i, (Object)disposition);
                LOG.trace("Part #{}: Description: {}", (Object)i, (Object)part.getDescription());
                LOG.trace("Part #{}: ContentType: {}", (Object)i, (Object)part.getContentType());
                LOG.trace("Part #{}: FileName: {}", (Object)i, (Object)fileName);
                LOG.trace("Part #{}: Size: {}", (Object)i, (Object)part.getSize());
                LOG.trace("Part #{}: LineCount: {}", (Object)i, (Object)part.getLineCount());
            }
            if (!this.validDisposition(disposition, fileName) && fileName == null) continue;
            LOG.debug("Mail contains file attachment: {}", (Object)fileName);
            if (!map.containsKey(fileName)) {
                DefaultAttachment camelAttachment = new DefaultAttachment(part.getDataHandler());
                Enumeration headers = part.getAllHeaders();
                while (headers.hasMoreElements()) {
                    Header header = (Header)headers.nextElement();
                    camelAttachment.addHeader(header.getName(), header.getValue());
                }
                map.put(fileName, (Attachment)camelAttachment);
                continue;
            }
            LOG.warn("Cannot extract duplicate file attachment: {}.", (Object)fileName);
        }
    }

    private boolean validDisposition(String disposition, String fileName) {
        return disposition != null && fileName != null && (disposition.equalsIgnoreCase("attachment") || disposition.equalsIgnoreCase("inline"));
    }

    protected void appendHeadersFromCamelMessage(MimeMessage mimeMessage, MailConfiguration configuration, Exchange exchange) throws MessagingException, IOException {
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(headerName, headerValue, exchange)) continue;
            if (headerName.equalsIgnoreCase("subject")) {
                mimeMessage.setSubject(MailBinding.asString(exchange, headerValue), MailBinding.determineCharSet(configuration, exchange));
                continue;
            }
            if (headerName.equalsIgnoreCase("from")) {
                mimeMessage.setFrom((Address)MailBinding.asEncodedInternetAddress(MailBinding.asString(exchange, headerValue), MailBinding.determineCharSet(configuration, exchange)));
                continue;
            }
            if (headerName.equalsIgnoreCase("sender")) {
                mimeMessage.setSender((Address)MailBinding.asEncodedInternetAddress(MailBinding.asString(exchange, headerValue), MailBinding.determineCharSet(configuration, exchange)));
                continue;
            }
            if (MailBinding.isRecipientHeader(headerName) || headerName.equalsIgnoreCase(configuration.getAlternativeBodyHeader())) continue;
            if (ObjectConverter.isCollection(headerValue)) {
                Iterator iter = ObjectHelper.createIterator(headerValue);
                while (iter.hasNext()) {
                    Object value = iter.next();
                    mimeMessage.addHeader(headerName, MailBinding.asString(exchange, value));
                }
                continue;
            }
            mimeMessage.setHeader(headerName, MailBinding.asString(exchange, headerValue));
        }
    }

    private void setRecipientFromCamelMessage(MimeMessage mimeMessage, MailConfiguration configuration, Exchange exchange) throws MessagingException, IOException {
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            if (headerValue == null || !MailBinding.isRecipientHeader(headerName)) continue;
            if (ObjectConverter.isCollection(headerValue)) {
                Iterator iter = ObjectHelper.createIterator(headerValue);
                while (iter.hasNext()) {
                    Object recipient = iter.next();
                    MailBinding.appendRecipientToMimeMessage(mimeMessage, configuration, exchange, headerName, MailBinding.asString(exchange, recipient));
                }
                continue;
            }
            MailBinding.appendRecipientToMimeMessage(mimeMessage, configuration, exchange, headerName, MailBinding.asString(exchange, headerValue));
        }
    }

    protected void setRecipientFromEndpointConfiguration(MimeMessage mimeMessage, MailEndpoint endpoint, Exchange exchange) throws MessagingException, IOException {
        Map<Message.RecipientType, String> recipients = endpoint.getConfiguration().getRecipients();
        if (recipients.containsKey(Message.RecipientType.TO)) {
            MailBinding.appendRecipientToMimeMessage(mimeMessage, endpoint.getConfiguration(), exchange, Message.RecipientType.TO.toString(), recipients.get(Message.RecipientType.TO));
        }
        if (recipients.containsKey(Message.RecipientType.CC)) {
            MailBinding.appendRecipientToMimeMessage(mimeMessage, endpoint.getConfiguration(), exchange, Message.RecipientType.CC.toString(), recipients.get(Message.RecipientType.CC));
        }
        if (recipients.containsKey(Message.RecipientType.BCC)) {
            MailBinding.appendRecipientToMimeMessage(mimeMessage, endpoint.getConfiguration(), exchange, Message.RecipientType.BCC.toString(), recipients.get(Message.RecipientType.BCC));
        }
    }

    protected void appendAttachmentsFromCamel(MimeMessage mimeMessage, MailConfiguration configuration, Exchange exchange) throws MessagingException, IOException {
        mimeMessage.setContent((Multipart)this.createMixedMultipartAttachments(configuration, exchange));
    }

    private MimeMultipart createMixedMultipartAttachments(MailConfiguration configuration, Exchange exchange) throws MessagingException, IOException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.setSubType("mixed");
        this.addBodyToMultipart(configuration, multipart, exchange);
        String partDisposition = configuration.isUseInlineAttachments() ? "inline" : "attachment";
        AttachmentsContentTransferEncodingResolver contentTransferEncodingResolver = configuration.getAttachmentsContentTransferEncodingResolver();
        if (exchange.getIn().hasAttachments()) {
            this.addAttachmentsToMultipart(multipart, partDisposition, contentTransferEncodingResolver, exchange);
        }
        return multipart;
    }

    protected void addAttachmentsToMultipart(MimeMultipart multipart, String partDisposition, AttachmentsContentTransferEncodingResolver encodingResolver, Exchange exchange) throws MessagingException {
        LOG.trace("Adding attachments +++ start +++");
        int i = 0;
        for (Map.Entry entry : exchange.getIn().getAttachmentObjects().entrySet()) {
            String attachmentFilename = (String)entry.getKey();
            Attachment attachment = (Attachment)entry.getValue();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Attachment #{}: Disposition: {}", (Object)i, (Object)partDisposition);
                LOG.trace("Attachment #{}: DataHandler: {}", (Object)i, (Object)attachment.getDataHandler());
                LOG.trace("Attachment #{}: FileName: {}", (Object)i, (Object)attachmentFilename);
            }
            if (attachment != null) {
                if (this.shouldAddAttachment(exchange, attachmentFilename, attachment.getDataHandler())) {
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(attachment.getDataHandler());
                    for (String headerName : attachment.getHeaderNames()) {
                        List values = attachment.getHeaderAsList(headerName);
                        for (String value : values) {
                            messageBodyPart.setHeader(headerName, value);
                        }
                    }
                    if (attachmentFilename.toLowerCase().startsWith("cid:")) {
                        messageBodyPart.addHeader("Content-ID", "<" + attachmentFilename.substring(4) + ">");
                        messageBodyPart.setFileName(attachmentFilename.substring(4));
                    } else {
                        messageBodyPart.setFileName(attachmentFilename);
                    }
                    LOG.trace("Attachment #{}: ContentType: {}", (Object)i, (Object)messageBodyPart.getContentType());
                    if (this.contentTypeResolver != null) {
                        String contentType = this.contentTypeResolver.resolveContentType(attachmentFilename);
                        LOG.trace("Attachment #{}: Using content type resolver: {} resolved content type as: {}", new Object[]{i, this.contentTypeResolver, contentType});
                        if (contentType != null) {
                            String value = contentType + "; name=" + attachmentFilename;
                            messageBodyPart.setHeader("Content-Type", value);
                            LOG.trace("Attachment #{}: ContentType: {}", (Object)i, (Object)messageBodyPart.getContentType());
                        }
                    }
                    this.resolveContentTransferEncoding(encodingResolver, i, (BodyPart)messageBodyPart);
                    messageBodyPart.setDisposition(partDisposition);
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                } else {
                    LOG.trace("shouldAddAttachment: false");
                }
            } else {
                LOG.warn("Cannot add attachment: {} as DataHandler is null", (Object)attachmentFilename);
            }
            ++i;
        }
        LOG.trace("Adding attachments +++ done +++");
    }

    protected void resolveContentTransferEncoding(AttachmentsContentTransferEncodingResolver resolver, int i, BodyPart messageBodyPart) throws MessagingException {
        if (resolver != null) {
            String contentTransferEncoding = resolver.resolveContentTransferEncoding(messageBodyPart);
            LOG.trace("Attachment #{}: Using content transfer encoding resolver: {} resolved content transfer encoding as: {}", new Object[]{i, resolver, contentTransferEncoding});
            if (contentTransferEncoding != null) {
                messageBodyPart.setHeader("Content-Transfer-Encoding", contentTransferEncoding);
            }
        }
    }

    protected void createMultipartAlternativeMessage(MimeMessage mimeMessage, MailConfiguration configuration, Exchange exchange) throws MessagingException, IOException {
        MimeMultipart multipartAlternative = new MimeMultipart("alternative");
        mimeMessage.setContent((Multipart)multipartAlternative);
        MimeBodyPart plainText = new MimeBodyPart();
        plainText.setText(MailBinding.getAlternativeBody(configuration, exchange), MailBinding.determineCharSet(configuration, exchange));
        exchange.getIn().removeHeader(configuration.getAlternativeBodyHeader());
        multipartAlternative.addBodyPart((BodyPart)plainText);
        if (!exchange.getIn().hasAttachments()) {
            this.addBodyToMultipart(configuration, multipartAlternative, exchange);
        } else if (!configuration.isUseInlineAttachments()) {
            MimeBodyPart mixedAttachments = new MimeBodyPart();
            mixedAttachments.setContent((Multipart)this.createMixedMultipartAttachments(configuration, exchange));
            multipartAlternative.addBodyPart((BodyPart)mixedAttachments);
        } else {
            MimeMultipart multipartRelated = new MimeMultipart("related");
            MimeBodyPart related = new MimeBodyPart();
            related.setContent((Multipart)multipartRelated);
            multipartAlternative.addBodyPart((BodyPart)related);
            this.addBodyToMultipart(configuration, multipartRelated, exchange);
            AttachmentsContentTransferEncodingResolver resolver = configuration.getAttachmentsContentTransferEncodingResolver();
            this.addAttachmentsToMultipart(multipartRelated, "inline", resolver, exchange);
        }
    }

    protected void addBodyToMultipart(MailConfiguration configuration, MimeMultipart activeMultipart, Exchange exchange) throws MessagingException, IOException {
        MimeBodyPart bodyMessage = new MimeBodyPart();
        this.populateContentOnBodyPart((BodyPart)bodyMessage, configuration, exchange);
        activeMultipart.addBodyPart((BodyPart)bodyMessage);
    }

    protected boolean shouldAddAttachment(Exchange exchange, String attachmentFilename, DataHandler handler) {
        return true;
    }

    protected Map<String, Object> extractHeadersFromMail(Message mailMessage, Exchange exchange) throws MessagingException, IOException {
        Object content;
        TreeMap<String, Object> answer = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        Enumeration names = mailMessage.getAllHeaders();
        MailConfiguration mailConfiguration = ((MailEndpoint)exchange.getFromEndpoint()).getConfiguration();
        while (names.hasMoreElements()) {
            Header header = (Header)names.nextElement();
            String value = header.getValue();
            if (value != null && mailConfiguration.isMimeDecodeHeaders()) {
                value = MimeUtility.decodeText((String)MimeUtility.unfold((String)value));
            }
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(header.getName(), (Object)value, exchange)) continue;
            CollectionHelper.appendValue(answer, (String)header.getName(), (Object)value);
        }
        if (mailConfiguration.isMapMailMessage() && (content = mailMessage.getContent()) instanceof MimeMultipart) {
            MimeMultipart multipart = (MimeMultipart)content;
            int size = multipart.getCount();
            for (int i = 0; i < size; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                content = part.getContent();
                while (content instanceof MimeMultipart && multipart.getCount() >= 1) {
                    part = ((MimeMultipart)content).getBodyPart(0);
                    content = part.getContent();
                }
                if (!part.getContentType().toLowerCase().startsWith("text")) continue;
                answer.put("Content-Type", part.getContentType());
                break;
            }
        }
        return answer;
    }

    private static void appendRecipientToMimeMessage(MimeMessage mimeMessage, MailConfiguration configuration, Exchange exchange, String type, String recipient) throws MessagingException, IOException {
        ArrayList<InternetAddress> recipientsAddresses = new ArrayList<InternetAddress>();
        for (String line : MailBinding.splitRecipients(recipient)) {
            String address = line.trim();
            if (!ObjectHelper.isNotEmpty((Object)address)) continue;
            recipientsAddresses.add(MailBinding.asEncodedInternetAddress(address, MailBinding.determineCharSet(configuration, exchange)));
        }
        mimeMessage.addRecipients(MailBinding.asRecipientType(type), (Address[])recipientsAddresses.toArray(new InternetAddress[recipientsAddresses.size()]));
    }

    private static String[] splitRecipients(String recipients) {
        return recipients.split("[,;]++(?=(?:(?:[^\\\"]*+\\\"){2})*+[^\\\"]*+$)");
    }

    private static boolean hasRecipientHeaders(Exchange exchange) {
        for (String key : exchange.getIn().getHeaders().keySet()) {
            if (!MailBinding.isRecipientHeader(key)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasAlternativeBody(MailConfiguration configuration, Exchange exchange) {
        return MailBinding.getAlternativeBody(configuration, exchange) != null;
    }

    protected static String getAlternativeBody(MailConfiguration configuration, Exchange exchange) {
        String alternativeBodyHeader = configuration.getAlternativeBodyHeader();
        return (String)exchange.getIn().getHeader(alternativeBodyHeader, String.class);
    }

    private static boolean isRecipientHeader(String key) {
        if (Message.RecipientType.TO.toString().equalsIgnoreCase(key)) {
            return true;
        }
        if (Message.RecipientType.CC.toString().equalsIgnoreCase(key)) {
            return true;
        }
        return Message.RecipientType.BCC.toString().equalsIgnoreCase(key);
    }

    private static Message.RecipientType asRecipientType(String type) {
        if (Message.RecipientType.TO.toString().equalsIgnoreCase(type)) {
            return Message.RecipientType.TO;
        }
        if (Message.RecipientType.CC.toString().equalsIgnoreCase(type)) {
            return Message.RecipientType.CC;
        }
        if (Message.RecipientType.BCC.toString().equalsIgnoreCase(type)) {
            return Message.RecipientType.BCC;
        }
        throw new IllegalArgumentException("Unknown recipient type: " + type);
    }

    private static boolean empty(Address[] addresses) {
        return addresses == null || addresses.length == 0;
    }

    private static String asString(Exchange exchange, Object value) {
        return (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, value);
    }

    private static InternetAddress asEncodedInternetAddress(String address, String charset) throws UnsupportedEncodingException, AddressException {
        InternetAddress internetAddress = new InternetAddress(address);
        internetAddress.setPersonal(internetAddress.getPersonal(), charset);
        return internetAddress;
    }
}

