/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import com.sun.mail.imap.SortTerm;
import javax.mail.search.SearchTerm;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mail.ContentTypeResolver;
import org.apache.camel.component.mail.DefaultMailUidGenerator;
import org.apache.camel.component.mail.JavaMailSender;
import org.apache.camel.component.mail.MailBinding;
import org.apache.camel.component.mail.MailBoxPostProcessAction;
import org.apache.camel.component.mail.MailComponent;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailConsumer;
import org.apache.camel.component.mail.MailHeaderFilterStrategy;
import org.apache.camel.component.mail.MailMessage;
import org.apache.camel.component.mail.MailProducer;
import org.apache.camel.component.mail.MailUidGenerator;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="1.0.0", scheme="imap,imaps,pop3,pop3s,smtp,smtps", title="IMAP,IMAPS,POP3,POP3S,SMTP,SMTPS", syntax="imap:host:port", alternativeSyntax="imap:username:password@host:port", label="mail")
public class MailEndpoint
extends ScheduledPollEndpoint
implements HeaderFilterStrategyAware {
    @UriParam(optionalPrefix="consumer.", defaultValue="60000", label="consumer,scheduler", description="Milliseconds before the next poll.")
    private long delay = 60000L;
    @UriParam
    private MailConfiguration configuration;
    @UriParam(label="advanced")
    private MailBinding binding;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy = new MailHeaderFilterStrategy();
    @UriParam(label="advanced")
    private ContentTypeResolver contentTypeResolver;
    @UriParam(label="consumer")
    private int maxMessagesPerPoll;
    @UriParam(label="consumer,filter", prefix="searchTerm.", multiValue=true)
    private SearchTerm searchTerm;
    @UriParam(label="consumer,sort", javaType="java.lang.String")
    private SortTerm[] sortTerm;
    @UriParam(label="consumer,advanced")
    private MailBoxPostProcessAction postProcessAction;
    @UriParam(label="consumer,filter")
    private IdempotentRepository idempotentRepository;
    @UriParam(label="consumer,filter", defaultValue="true")
    private boolean idempotentRepositoryRemoveOnCommit = true;
    @UriParam(label="consumer,advanced")
    private MailUidGenerator mailUidGenerator = new DefaultMailUidGenerator();

    public MailEndpoint() {
        this(null, null, null);
    }

    public MailEndpoint(String endpointUri) {
        this(endpointUri, null, new MailConfiguration());
    }

    public MailEndpoint(String uri, MailComponent component, MailConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.setDelay(60000L);
    }

    public Producer createProducer() throws Exception {
        JavaMailSender sender = this.configuration.getJavaMailSender();
        if (sender == null) {
            sender = this.configuration.createJavaMailSender();
        }
        return this.createProducer(sender);
    }

    public Producer createProducer(JavaMailSender sender) throws Exception {
        return new MailProducer(this, sender);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.configuration.getProtocol().startsWith("smtp")) {
            throw new IllegalArgumentException("Protocol " + this.configuration.getProtocol() + " cannot be used for a MailConsumer. Please use another protocol such as pop3 or imap.");
        }
        JavaMailSender sender = this.configuration.createJavaMailSender();
        return this.createConsumer(processor, sender);
    }

    public Consumer createConsumer(Processor processor, JavaMailSender sender) throws Exception {
        MailConsumer answer = new MailConsumer(this, processor, sender);
        answer.setHandleFailedMessage(this.configuration.isHandleFailedMessage());
        answer.setSkipFailedMessage(this.configuration.isSkipFailedMessage());
        answer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isSingleton() {
        return false;
    }

    public Exchange createExchange(javax.mail.Message message) {
        Exchange exchange = super.createExchange();
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        exchange.setIn((Message)new MailMessage(exchange, message, this.getConfiguration().isMapMailMessage()));
        return exchange;
    }

    public MailBinding getBinding() {
        if (this.binding == null) {
            this.binding = new MailBinding(this.headerFilterStrategy, this.contentTypeResolver);
        }
        return this.binding;
    }

    public void setBinding(MailBinding binding) {
        this.binding = binding;
    }

    public MailConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MailConfiguration configuration) {
        this.configuration = configuration;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public ContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setContentTypeResolver(ContentTypeResolver contentTypeResolver) {
        this.contentTypeResolver = contentTypeResolver;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public SearchTerm getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(SearchTerm searchTerm) {
        this.searchTerm = searchTerm;
    }

    public SortTerm[] getSortTerm() {
        return this.sortTerm == null ? null : (SortTerm[])this.sortTerm.clone();
    }

    public void setSortTerm(SortTerm[] sortTerm) {
        this.sortTerm = sortTerm == null ? null : (SortTerm[])sortTerm.clone();
    }

    public MailBoxPostProcessAction getPostProcessAction() {
        return this.postProcessAction;
    }

    public void setPostProcessAction(MailBoxPostProcessAction postProcessAction) {
        this.postProcessAction = postProcessAction;
    }

    public IdempotentRepository getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public void setIdempotentRepository(IdempotentRepository idempotentRepository) {
        this.idempotentRepository = idempotentRepository;
    }

    public boolean isIdempotentRepositoryRemoveOnCommit() {
        return this.idempotentRepositoryRemoveOnCommit;
    }

    public void setIdempotentRepositoryRemoveOnCommit(boolean idempotentRepositoryRemoveOnCommit) {
        this.idempotentRepositoryRemoveOnCommit = idempotentRepositoryRemoveOnCommit;
    }

    public MailUidGenerator getMailUidGenerator() {
        return this.mailUidGenerator;
    }

    public void setMailUidGenerator(MailUidGenerator mailUidGenerator) {
        this.mailUidGenerator = mailUidGenerator;
    }

    public void setDelay(long delay) {
        super.setDelay(delay);
        this.delay = delay;
    }
}

