/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.main.BaseMainSupport;
import org.apache.camel.main.SimpleMainShutdownStrategy;
import org.apache.camel.spi.CamelContextTracker;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMainShutdownStrategy
extends SimpleMainShutdownStrategy {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultMainShutdownStrategy.class);
    private final AtomicBoolean hangupIntercepted;
    private final BaseMainSupport main;
    private volatile boolean hangupInterceptorEnabled;

    public DefaultMainShutdownStrategy(BaseMainSupport main) {
        this.main = main;
        this.hangupIntercepted = new AtomicBoolean();
    }

    public void disableHangupSupport() {
        this.hangupInterceptorEnabled = false;
    }

    public void enableHangupSupport() {
        this.hangupInterceptorEnabled = true;
    }

    @Override
    public void await() throws InterruptedException {
        this.installHangupInterceptor();
        super.await();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        this.installHangupInterceptor();
        return super.await(timeout, unit);
    }

    private void handleHangup() {
        LOG.debug("Received hangup signal, stopping the main instance.");
        this.addShutdownListener(() -> {
            LOG.trace("OnShutdown");
            if (this.main.getCamelContext() != null) {
                boolean success;
                final CountDownLatch latch = new CountDownLatch(1);
                CamelContextTracker tracker = new CamelContextTracker(){

                    public void contextDestroyed(CamelContext camelContext) {
                        latch.countDown();
                    }
                };
                tracker.open();
                long max = TimeUnit.SECONDS.toMillis(this.getExtraShutdownTimeout()) + this.main.getCamelContext().getShutdownStrategy().getTimeUnit().toMillis(this.main.getCamelContext().getShutdownStrategy().getTimeout());
                int waits = 0;
                boolean done = false;
                StopWatch watch = new StopWatch();
                while (!this.main.getCamelContext().isStopped() && !done && watch.taken() < max) {
                    String msg = "Waiting for CamelContext to graceful shutdown (max:" + TimeUtils.printDuration((long)max, (boolean)true) + ", elapsed:" + TimeUtils.printDuration((long)watch.taken(), (boolean)true) + ")";
                    if (waits > 0 && waits % 5 == 0) {
                        LOG.info(msg);
                    } else {
                        LOG.trace(msg);
                    }
                    ++waits;
                    try {
                        done = latch.await(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = success = done || this.main.getCamelContext().isStopped();
                if (!success) {
                    LOG.warn("CamelContext not yet shutdown completely after: {}. Forcing shutdown.", (Object)TimeUtils.printDuration((long)watch.taken(), (boolean)true));
                }
                tracker.close();
            }
            LOG.trace("OnShutdown complete");
        });
        this.shutdown();
    }

    private void installHangupInterceptor() {
        if (this.hangupIntercepted.compareAndSet(false, this.hangupInterceptorEnabled)) {
            Thread task = new Thread(this::handleHangup);
            task.setName(ThreadHelper.resolveThreadName(null, (String)"CamelHangupInterceptor"));
            Runtime.getRuntime().addShutdownHook(task);
        }
    }
}

