/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.rest.RestComponentVerifierExtension;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

@Component(value="rest")
@Metadata(label="verifiers", enums="parameters,connectivity")
public class RestComponent
extends DefaultComponent {
    public static final String DEFAULT_REST_CONFIGURATION_ID = "rest-configuration";
    @Metadata(label="common")
    private String componentName;
    @Metadata(label="producer")
    private String apiDoc;
    @Metadata(label="producer")
    private String host;

    public RestComponent() {
        this.registerExtension(RestComponentVerifierExtension::new);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String uriTemplate;
        String path;
        String restConfigurationName = (String)this.getAndRemoveParameter(parameters, "componentName", String.class, this.componentName);
        RestEndpoint answer = new RestEndpoint(uri, this);
        answer.setComponentName(restConfigurationName);
        answer.setApiDoc(this.apiDoc);
        RestConfiguration config = new RestConfiguration();
        this.mergeConfigurations(config, this.findGlobalRestConfiguration());
        this.mergeConfigurations(config, this.getCamelContext().getRestConfiguration(restConfigurationName, true));
        String h = (String)this.getAndRemoveOrResolveReferenceParameter(parameters, "host", String.class, this.host);
        if (h == null) {
            h = config.getHost();
            int port = config.getPort();
            if (port > 0 && port != 80 && port != 443) {
                h = h + ":" + port;
            }
        }
        if (h != null && !h.startsWith("http://") && !h.startsWith("https://")) {
            h = "http://" + h;
        }
        answer.setHost(h);
        this.setProperties((Object)answer, parameters);
        if (!parameters.isEmpty()) {
            LinkedHashMap<String, Object> queryParameters = new LinkedHashMap<String, Object>(parameters);
            Map existingQueryParameters = URISupport.parseQuery((String)answer.getQueryParameters());
            queryParameters.putAll(existingQueryParameters);
            String remainingParameters = URISupport.createQueryString(queryParameters);
            answer.setQueryParameters(remainingParameters);
        }
        answer.setParameters(parameters);
        if (!remaining.contains(":")) {
            throw new IllegalArgumentException("Invalid syntax. Must be rest:method:path[:uriTemplate] where uriTemplate is optional");
        }
        String method = StringHelper.before((String)remaining, (String)":");
        String s = StringHelper.after((String)remaining, (String)":");
        if (s != null && s.contains(":")) {
            path = StringHelper.before((String)s, (String)":");
            uriTemplate = StringHelper.after((String)s, (String)":");
        } else {
            path = s;
            uriTemplate = null;
        }
        path = FileUtil.stripTrailingSeparator((String)path);
        uriTemplate = FileUtil.stripTrailingSeparator(uriTemplate);
        answer.setMethod(method);
        answer.setPath(path);
        answer.setUriTemplate(uriTemplate);
        if (answer.getComponentName() == null) {
            String name = config.getProducerComponent();
            if (name == null) {
                name = config.getComponent();
            }
            answer.setComponentName(name);
        }
        if (answer.getApiDoc() == null) {
            answer.setApiDoc(config.getProducerApiDoc());
        }
        return answer;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getApiDoc() {
        return this.apiDoc;
    }

    public void setApiDoc(String apiDoc) {
        this.apiDoc = apiDoc;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    private RestConfiguration findGlobalRestConfiguration() {
        CamelContext context = this.getCamelContext();
        RestConfiguration conf = (RestConfiguration)CamelContextHelper.lookup((CamelContext)context, (String)DEFAULT_REST_CONFIGURATION_ID, RestConfiguration.class);
        if (conf == null) {
            conf = (RestConfiguration)CamelContextHelper.findByType((CamelContext)this.getCamelContext(), RestConfiguration.class);
        }
        return conf;
    }

    private RestConfiguration mergeConfigurations(RestConfiguration conf, RestConfiguration from) throws Exception {
        if (conf == from) {
            return conf;
        }
        if (from != null) {
            Map map = IntrospectionSupport.getNonNullProperties((Object)from);
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!(entry.getValue() instanceof Map)) continue;
                it.remove();
            }
            PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)conf, (Map)map);
            this.mergeProperties(() -> ((RestConfiguration)conf).getComponentProperties(), () -> ((RestConfiguration)from).getComponentProperties(), arg_0 -> ((RestConfiguration)conf).setComponentProperties(arg_0));
            this.mergeProperties(() -> ((RestConfiguration)conf).getEndpointProperties(), () -> ((RestConfiguration)from).getEndpointProperties(), arg_0 -> ((RestConfiguration)conf).setEndpointProperties(arg_0));
            this.mergeProperties(() -> ((RestConfiguration)conf).getConsumerProperties(), () -> ((RestConfiguration)from).getConsumerProperties(), arg_0 -> ((RestConfiguration)conf).setConsumerProperties(arg_0));
            this.mergeProperties(() -> ((RestConfiguration)conf).getDataFormatProperties(), () -> ((RestConfiguration)from).getDataFormatProperties(), arg_0 -> ((RestConfiguration)conf).setDataFormatProperties(arg_0));
            this.mergeProperties(() -> ((RestConfiguration)conf).getApiProperties(), () -> ((RestConfiguration)from).getApiProperties(), arg_0 -> ((RestConfiguration)conf).setApiProperties(arg_0));
            this.mergeProperties(() -> ((RestConfiguration)conf).getCorsHeaders(), () -> ((RestConfiguration)from).getCorsHeaders(), arg_0 -> ((RestConfiguration)conf).setCorsHeaders(arg_0));
        }
        return conf;
    }

    private <T> void mergeProperties(Supplier<Map<String, T>> base, Supplier<Map<String, T>> addons, Consumer<Map<String, T>> consumer) {
        Map<String, T> baseMap = base.get();
        Map<String, T> addonsMap = addons.get();
        if (baseMap != null || addonsMap != null) {
            HashMap<String, T> result = new HashMap<String, T>();
            if (baseMap != null) {
                result.putAll(baseMap);
            }
            if (addonsMap != null) {
                result.putAll(addonsMap);
            }
            consumer.accept(result);
        }
    }

    public ComponentVerifierExtension getVerifier() {
        return (scope, parameters) -> ((ComponentVerifierExtension)this.getExtension(ComponentVerifierExtension.class).orElseThrow(UnsupportedOperationException::new)).verify(scope, parameters);
    }
}

