/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisConfiguration {
    private String command;
    private String channels;
    private String host;
    private Integer port;
    private RedisTemplate redisTemplate;
    private RedisMessageListenerContainer listenerContainer;
    private RedisConnectionFactory connectionFactory;
    private RedisSerializer serializer;
    private boolean managedListenerContainer;
    private boolean managedConnectionFactory;

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate != null ? this.redisTemplate : this.createDefaultTemplate();
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public RedisMessageListenerContainer getListenerContainer() {
        return this.listenerContainer != null ? this.listenerContainer : this.createDefaultListenerContainer();
    }

    public void setListenerContainer(RedisMessageListenerContainer listenerContainer) {
        this.listenerContainer = listenerContainer;
    }

    public String getChannels() {
        return this.channels;
    }

    public void setChannels(String channels) {
        this.channels = channels;
    }

    public void setConnectionFactory(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public RedisConnectionFactory getConnectionFactory() {
        return this.connectionFactory != null ? this.connectionFactory : this.createDefaultConnectionFactory();
    }

    public RedisSerializer getSerializer() {
        return this.serializer != null ? this.serializer : this.createDefaultSerializer();
    }

    public void setSerializer(RedisSerializer serializer) {
        this.serializer = serializer;
    }

    private RedisConnectionFactory createDefaultConnectionFactory() {
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory();
        this.managedConnectionFactory = true;
        if (this.host != null) {
            jedisConnectionFactory.setHostName(this.host);
        }
        if (this.port != null) {
            jedisConnectionFactory.setPort(this.port.intValue());
        }
        jedisConnectionFactory.afterPropertiesSet();
        this.connectionFactory = jedisConnectionFactory;
        return jedisConnectionFactory;
    }

    private RedisTemplate createDefaultTemplate() {
        this.redisTemplate = new RedisTemplate();
        this.redisTemplate.setDefaultSerializer(this.getSerializer());
        this.redisTemplate.setConnectionFactory(this.getConnectionFactory());
        this.redisTemplate.afterPropertiesSet();
        return this.redisTemplate;
    }

    private RedisMessageListenerContainer createDefaultListenerContainer() {
        this.listenerContainer = new RedisMessageListenerContainer();
        this.managedListenerContainer = true;
        this.listenerContainer.setConnectionFactory(this.getConnectionFactory());
        this.listenerContainer.afterPropertiesSet();
        this.listenerContainer.start();
        return this.listenerContainer;
    }

    private RedisSerializer createDefaultSerializer() {
        this.serializer = new JdkSerializationRedisSerializer();
        return this.serializer;
    }

    public void stop() throws Exception {
        if (this.managedConnectionFactory) {
            ((JedisConnectionFactory)this.connectionFactory).destroy();
        }
        if (this.managedListenerContainer) {
            this.listenerContainer.destroy();
        }
    }
}

